/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.ms100;

import java.util.Vector;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.loconet.LnPacketizer;
import jmri.jmrix.loconet.LnPortController;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.ms100.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MS100Adapter
extends LnPortController {
    Vector<String> portNameVector = null;
    private static final Logger log = LoggerFactory.getLogger(MS100Adapter.class);

    public MS100Adapter() {
        super(new LocoNetSystemConnectionMemo());
        this.option2Name = "CommandStation";
        this.option3Name = "TurnoutHandle";
        this.options.put(this.option2Name, new AbstractPortController.Option(Bundle.getMessage("CommandStationTypeLabel"), this.commandStationNames, false));
        this.options.put(this.option3Name, new AbstractPortController.Option(Bundle.getMessage("TurnoutHandling"), new String[]{Bundle.getMessage("HandleNormal"), Bundle.getMessage("HandleSpread"), Bundle.getMessage("HandleOneOnly"), Bundle.getMessage("HandleBoth")}));
    }

    @Override
    public String openPort(String portName, String appName) {
        this.currentSerialPort = this.activatePort(portName, log);
        if (this.currentSerialPort == null) {
            log.error("failed to connect MS100 to {}", (Object)portName);
            return Bundle.getMessage("SerialPortNotFound", portName);
        }
        log.info("Connecting MS100 via {} {}", (Object)portName, (Object)this.currentSerialPort);
        this.setBaudRate(this.currentSerialPort, 16600);
        this.configureLeads(this.currentSerialPort, true, false);
        this.setFlowControl(this.currentSerialPort, AbstractSerialPortController.FlowControl.NONE);
        this.setComPortTimeouts(this.currentSerialPort, AbstractSerialPortController.Blocking.READ_SEMI_BLOCKING, 100);
        this.reportPortStatus(log, portName);
        this.opened = true;
        return null;
    }

    @Override
    public void configure() {
        this.setCommandStationType(this.getOptionState(this.option2Name));
        this.setTurnoutHandling(this.getOptionState(this.option3Name));
        LnPacketizer packets = new LnPacketizer(this.getSystemConnectionMemo());
        packets.connectPort(this);
        this.getSystemConnectionMemo().setLnTrafficController(packets);
        this.getSystemConnectionMemo().configureCommandStation(this.commandStationType, this.mTurnoutNoRetry, this.mTurnoutExtraSpace, this.mTranspondingAvailable, this.mInterrogateAtStart, this.mLoconetProtocolAutoDetect);
        this.getSystemConnectionMemo().configureManagers();
        packets.startThreads();
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        return new String[]{"fixed at 16,600 baud"};
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[]{16600};
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }

    @Override
    public void configureOption2(String value) {
        super.configureOption2(value);
        log.debug("configureOption2: {}", (Object)value);
        this.setCommandStationType(value);
    }
}

