/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.pr3;

import jmri.AddressedProgrammerManager;
import jmri.ConsistManager;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.PowerManager;
import jmri.ShutDownManager;
import jmri.ThrottleManager;
import jmri.jmrix.loconet.LnPowerManager;
import jmri.jmrix.loconet.LnPr2ThrottleManager;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.SlotManager;
import jmri.jmrix.loconet.pr2.LnPr2PowerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PR3SystemConnectionMemo
extends LocoNetSystemConnectionMemo {
    static final int PR3MODE = 0;
    static final int MS100MODE = 1;
    int mode = 0;
    private Runnable restoreToLocoNetInterfaceModeTask;
    private static final Logger log = LoggerFactory.getLogger(PR3SystemConnectionMemo.class);

    public PR3SystemConnectionMemo(LnTrafficController lt, SlotManager sm) {
        super(lt, sm);
    }

    public PR3SystemConnectionMemo() {
    }

    @Override
    public <T> T get(Class<T> T) {
        if (this.getDisabled()) {
            return null;
        }
        if (this.mode == 1) {
            return super.get(T);
        }
        if (T.equals(GlobalProgrammerManager.class)) {
            return (T)this.getProgrammerManager();
        }
        if (T.equals(AddressedProgrammerManager.class)) {
            return (T)this.getProgrammerManager();
        }
        if (T.equals(ThrottleManager.class)) {
            return (T)this.getThrottleManager();
        }
        if (T.equals(PowerManager.class)) {
            return (T)this.getPowerManager();
        }
        if (T.equals(ConsistManager.class)) {
            return (T)this.getConsistManager();
        }
        return null;
    }

    public void configureManagersPR2() {
        this.mode = 0;
        log.info("Connection [{}] initialized as \"Stand Alone Programmer\", no access to attached devices. (see preferences)", (Object)this.getSystemPrefix());
        InstanceManager.store(this.getPowerManager(), PowerManager.class);
        InstanceManager.setThrottleManager(this.getThrottleManager());
        if (this.getProgrammerManager().isAddressedModePossible()) {
            InstanceManager.store(this.getProgrammerManager(), AddressedProgrammerManager.class);
        }
        if (this.getProgrammerManager().isGlobalProgrammerAvailable()) {
            InstanceManager.store(this.getProgrammerManager(), GlobalProgrammerManager.class);
        }
        if (this.restoreToLocoNetInterfaceModeTask == null) {
            this.restoreToLocoNetInterfaceModeTask = () -> {
                LnTrafficController tc;
                if (this.mode == 0 && (tc = this.getLnTrafficController()) != null) {
                    LocoNetMessage msg = new LocoNetMessage(6);
                    msg.setOpCode(211);
                    msg.setElement(1, 16);
                    msg.setElement(2, 0);
                    msg.setElement(3, 0);
                    msg.setElement(4, 0);
                    tc.sendLocoNetMessage(msg);
                    log.info("Configuring PR3 for 'LocoNet Interface' mode");
                }
            };
            InstanceManager.getDefault(ShutDownManager.class).register(this.restoreToLocoNetInterfaceModeTask);
        }
        this.register();
    }

    @Override
    public ThrottleManager getThrottleManager() {
        if (super.getDisabled()) {
            return null;
        }
        if (this.mode == 1) {
            return super.getThrottleManager();
        }
        return (ThrottleManager)this.classObjectMap.computeIfAbsent(ThrottleManager.class, c -> new LnPr2ThrottleManager(this));
    }

    @Override
    public boolean provides(Class<?> type) {
        if (this.getDisabled()) {
            return false;
        }
        if (this.mode == 1) {
            return super.provides(type);
        }
        if (type.equals(GlobalProgrammerManager.class)) {
            return this.getProgrammerManager().isGlobalProgrammerAvailable();
        }
        if (type.equals(AddressedProgrammerManager.class)) {
            return this.getProgrammerManager().isAddressedModePossible();
        }
        if (type.equals(ThrottleManager.class)) {
            return true;
        }
        if (type.equals(PowerManager.class)) {
            return true;
        }
        if (type.equals(ConsistManager.class)) {
            return this.getConsistManager() != null;
        }
        return false;
    }

    @Override
    public LnPowerManager getPowerManager() {
        if (this.getDisabled()) {
            return null;
        }
        if (this.mode == 1) {
            return super.getPowerManager();
        }
        return (LnPowerManager)this.classObjectMap.computeIfAbsent(PowerManager.class, c -> new LnPr2PowerManager(this));
    }

    public void configureManagersMS100() {
        this.mode = 1;
        log.info("Connection [{}] initialized as LocoNet interface, allows access to attached devices. (see preferences)", (Object)this.getSystemPrefix());
        super.configureManagers();
    }

    @Override
    public void dispose() {
        InstanceManager.deregister(this, PR3SystemConnectionMemo.class);
        if (this.tm != null) {
            this.tm.dispose();
        }
        super.dispose();
    }
}

