/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.pr3.swing;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.pr3.swing.Bundle;
import jmri.jmrix.loconet.swing.LnPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pr3SelectPane
extends LnPanel
implements LocoNetListener {
    JLabel status = new JLabel(Bundle.getMessage("StatusUnknown"));
    private static final Logger log = LoggerFactory.getLogger(Pr3SelectPane.class);

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.loconet.pr3.swing.Pr3Select";
    }

    @Override
    public String getTitle() {
        return this.getTitle(Bundle.getMessage("MenuItemPr3ModeSelect"));
    }

    public Pr3SelectPane() {
        this.setLayout(new FlowLayout());
        JButton b = new JButton(Bundle.getMessage("ButtonPr2Mode"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Pr3SelectPane.this.selectPR2mode();
            }
        });
        this.add(b);
        b = new JButton(Bundle.getMessage("ButtonMs100Mode"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Pr3SelectPane.this.selectMS100mode();
            }
        });
        this.add(b);
        this.add(this.status);
    }

    @Override
    public void initComponents(LocoNetSystemConnectionMemo memo) {
        super.initComponents(memo);
        if (memo.getLnTrafficController() != null) {
            memo.getLnTrafficController().addLocoNetListener(-1, this);
        } else {
            log.error("No LocoNet connection available, can't function");
        }
        LocoNetMessage msg = new LocoNetMessage(2);
        msg.setOpCode(129);
        memo.getLnTrafficController().sendLocoNetMessage(msg);
    }

    void selectPR2mode() {
        this.status.setText(Bundle.getMessage("StatusPr2"));
        LocoNetMessage msg = new LocoNetMessage(6);
        msg.setOpCode(211);
        msg.setElement(1, 16);
        msg.setElement(2, 1);
        msg.setElement(3, 0);
        msg.setElement(4, 0);
        this.memo.getLnTrafficController().sendLocoNetMessage(msg);
    }

    void selectMS100mode() {
        this.status.setText(Bundle.getMessage("StatusMs100"));
        LocoNetMessage msg = new LocoNetMessage(6);
        msg.setOpCode(211);
        msg.setElement(1, 16);
        msg.setElement(2, 0);
        msg.setElement(3, 0);
        msg.setElement(4, 0);
        this.memo.getLnTrafficController().sendLocoNetMessage(msg);
    }

    @Override
    public void message(LocoNetMessage msg) {
        if (msg.getOpCode() == 229 && msg.getElement(1) == 16 && msg.getElement(2) == 34 && msg.getElement(3) == 34 && msg.getElement(4) == 1) {
            int mode = msg.getElement(8) & 0xC;
            if (mode == 0) {
                this.status.setText(Bundle.getMessage("StatusPr2"));
            } else {
                this.status.setText(Bundle.getMessage("StatusMs100"));
            }
        }
    }
}

