/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.pr4;

import jmri.jmrix.AbstractPortController;
import jmri.jmrix.loconet.LnCommandStationType;
import jmri.jmrix.loconet.LnPacketizer;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.locobuffer.LocoBufferAdapter;
import jmri.jmrix.loconet.pr2.LnPr2Packetizer;
import jmri.jmrix.loconet.pr4.Bundle;
import jmri.jmrix.loconet.pr4.PR4SystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PR4Adapter
extends LocoBufferAdapter {
    private static final Logger log = LoggerFactory.getLogger(PR4Adapter.class);

    public PR4Adapter() {
        super(new PR4SystemConnectionMemo());
        this.options.remove(this.option2Name);
        this.options.put(this.option2Name, new AbstractPortController.Option(Bundle.getMessage("CommandStationTypeLabel"), this.commandStationOptions(), false));
    }

    @Override
    protected void reportOpen(String portName) {
        log.info("Connecting PR4 via {} {}", (Object)portName, (Object)this.currentSerialPort);
    }

    @Override
    public void configure() {
        this.setCommandStationType(this.getOptionState(this.option2Name));
        this.setTurnoutHandling(this.getOptionState(this.option3Name));
        if (this.commandStationType == LnCommandStationType.COMMAND_STATION_PR4_ALONE) {
            LnPr2Packetizer packets = new LnPr2Packetizer(this.getSystemConnectionMemo());
            packets.connectPort(this);
            this.getSystemConnectionMemo().setLnTrafficController(packets);
            this.getSystemConnectionMemo().configureCommandStation(this.commandStationType, this.mTurnoutNoRetry, this.mTurnoutExtraSpace, this.mTranspondingAvailable, this.mInterrogateAtStart, this.mLoconetProtocolAutoDetect);
            this.getSystemConnectionMemo().configureManagersPR2();
            packets.startThreads();
            LocoNetMessage msg = new LocoNetMessage(6);
            msg.setOpCode(211);
            msg.setElement(1, 16);
            msg.setElement(2, 1);
            msg.setElement(3, 0);
            msg.setElement(4, 0);
            packets.sendLocoNetMessage(msg);
        } else {
            this.setTranspondingAvailable(this.getOptionState("TranspondingPresent"));
            this.setInterrogateOnStart(this.getOptionState("InterrogateOnStart"));
            this.setLoconetProtocolAutoDetect(this.getOptionState("LoconetProtocolAutoDetect"));
            LnPacketizer packets = this.getPacketizer(this.getOptionState(this.option4Name));
            packets.connectPort(this);
            this.getSystemConnectionMemo().setLnTrafficController(packets);
            this.getSystemConnectionMemo().configureCommandStation(this.commandStationType, this.mTurnoutNoRetry, this.mTurnoutExtraSpace, this.mTranspondingAvailable, this.mInterrogateAtStart, this.mLoconetProtocolAutoDetect);
            this.getSystemConnectionMemo().configureManagersMS100();
            packets.startThreads();
            LocoNetMessage msg = new LocoNetMessage(6);
            msg.setOpCode(211);
            msg.setElement(1, 16);
            msg.setElement(2, 0);
            msg.setElement(3, 0);
            msg.setElement(4, 0);
            packets.sendLocoNetMessage(msg);
        }
    }

    @Override
    public String[] validBaudRates() {
        return new String[]{"57,600 baud"};
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[]{57600};
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }

    public String[] commandStationOptions() {
        String[] retval = new String[this.commandStationNames.length + 2];
        retval[0] = LnCommandStationType.COMMAND_STATION_PR4_ALONE.getName();
        for (int i = 0; i < this.commandStationNames.length; ++i) {
            retval[i + 1] = this.commandStationNames[i];
        }
        retval[retval.length - 1] = LnCommandStationType.COMMAND_STATION_STANDALONE.getName() + " (using external LocoNet Data Termination!)";
        return retval;
    }

    @Override
    public PR4SystemConnectionMemo getSystemConnectionMemo() {
        LocoNetSystemConnectionMemo m = super.getSystemConnectionMemo();
        if (m instanceof PR4SystemConnectionMemo) {
            return (PR4SystemConnectionMemo)m;
        }
        log.error("Cannot cast the system connection memo to a PR4SystemConnection Memo.");
        return null;
    }
}

