/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.sdf;

import java.util.ArrayList;
import jmri.jmrix.loconet.sdf.SdfBuffer;
import jmri.jmrix.loconet.sdf.SdfMacro;

public class ChannelStart
extends SdfMacro {
    int number;

    public ChannelStart(int number) {
        this.number = number;
    }

    @Override
    public String name() {
        return "CHANNEL_START";
    }

    @Override
    public int length() {
        return 2;
    }

    public static SdfMacro match(SdfBuffer buff) {
        int peek;
        if ((buff.getAtIndex() & 0xFF) != 129) {
            return null;
        }
        buff.getAtIndexAndInc();
        ChannelStart result = new ChannelStart(buff.getAtIndexAndInc());
        while (buff.moreData() && (peek = buff.getAtIndex() & 0xFF) != 241 && peek != 129) {
            SdfMacro next = ChannelStart.decodeInstruction(buff);
            if (result.children == null) {
                result.children = new ArrayList();
            }
            result.children.add(next);
        }
        return result;
    }

    @Override
    public void loadByteArray(SdfBuffer buffer) {
        buffer.setAtIndexAndInc(129);
        buffer.setAtIndexAndInc(this.number);
        super.loadByteArray(buffer);
    }

    @Override
    public String toString() {
        return "Channel " + this.number + "\n";
    }

    @Override
    public String oneInstructionString() {
        return this.name() + " " + this.number + "\n";
    }

    @Override
    public String allInstructionString(String indent) {
        StringBuilder output = new StringBuilder(indent);
        output.append(this.oneInstructionString());
        if (this.children == null) {
            return output.toString();
        }
        for (int i = 0; i < this.children.size(); ++i) {
            output.append(((SdfMacro)this.children.get(i)).allInstructionString(indent + "  "));
        }
        return output.toString();
    }
}

