/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.sdf;

import jmri.jmrix.loconet.sdf.SdfBuffer;
import jmri.jmrix.loconet.sdf.SdfMacro;
import jmri.util.StringUtil;

public class GenerateTrigger
extends SdfMacro {
    int trigger;

    public GenerateTrigger(int trigger) {
        this.trigger = trigger;
    }

    @Override
    public String name() {
        return "GENERATE_TRIGGER";
    }

    @Override
    public int length() {
        return 2;
    }

    public static SdfMacro match(SdfBuffer buff) {
        if ((buff.getAtIndex() & 0xFF) != 177) {
            return null;
        }
        buff.getAtIndexAndInc();
        return new GenerateTrigger(buff.getAtIndexAndInc());
    }

    String triggerVal() {
        String trigName = StringUtil.getNameFromState(this.trigger, triggerCodes, triggerNames);
        if (trigName != null) {
            return trigName;
        }
        return "(trigger = 0x" + StringUtil.twoHexFromInt(this.trigger) + ")";
    }

    @Override
    public void loadByteArray(SdfBuffer buffer) {
        buffer.setAtIndexAndInc(177);
        buffer.setAtIndexAndInc(this.trigger);
        super.loadByteArray(buffer);
    }

    @Override
    public String toString() {
        return "Cause Trigger " + this.triggerVal() + "\n";
    }

    @Override
    public String oneInstructionString() {
        return this.name() + " " + this.triggerVal() + "\n";
    }

    @Override
    public String allInstructionString(String indent) {
        return indent + this.oneInstructionString();
    }
}

