/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.sdf;

import jmri.jmrix.loconet.sdf.SdfBuffer;
import jmri.jmrix.loconet.sdf.SdfMacro;
import jmri.util.StringUtil;

public class Play
extends SdfMacro {
    int handle;
    int brk;
    int wavebrkFlags;
    int byte1;
    int byte2;

    public Play(int byte1, int byte2) {
        this.byte1 = byte1;
        this.byte2 = byte2;
        this.handle = byte2 & 0x3F;
        this.wavebrkFlags = byte1 & 0x18;
        this.brk = ((byte1 & 7) << 2) + ((byte2 & 0xC0) >> 6);
        this.byte1 = byte1;
        this.byte2 = byte2;
    }

    @Override
    public String name() {
        return "PLAY";
    }

    public String handleVal() {
        return "" + this.handle;
    }

    public void setHandle(int val) {
        this.handle = val;
        this.byte2 = this.byte2 & 0xC0 | val & 0x3F;
    }

    public String brkVal() {
        return this.decodeState(this.brk, loopCodes, loopNames);
    }

    public void setBrk(String name) {
        int val = StringUtil.getStateFromName(name, loopCodes, loopNames);
        if (val == -1) {
            val = 0;
        }
        this.setBrk(val);
    }

    public void setBrk(int n) {
        this.byte1 = this.byte1 & 0xF8 | n >> 2 & 7;
        this.byte2 = this.byte2 & 0x3F | n << 6 & 0xC0;
        this.brk = ((this.byte1 & 7) << 2) + ((this.byte2 & 0xC0) >> 6);
    }

    public String wavebrkFlagsVal() {
        return this.decodeFlags(this.wavebrkFlags, wavebrkCodes, wavebrkMasks, wavebrkNames);
    }

    public int getWaveBrkFlags() {
        return this.wavebrkFlags >> 3;
    }

    public void setWaveBrkFlags(String name) {
        int val = StringUtil.getStateFromName(name, wavebrkCodes, wavebrkNames);
        if (val == -1) {
            val = 0;
        }
        this.setWaveBrkFlags(val >> 3);
    }

    public void setWaveBrkFlags(int n) {
        this.byte1 = this.byte1 & 0xE7 | n << 3 & 0x18;
        this.wavebrkFlags = this.byte1 & 0x18;
    }

    @Override
    public int length() {
        return 2;
    }

    public static SdfMacro match(SdfBuffer buff) {
        if ((buff.getAtIndex() & 0xC0) != 64) {
            return null;
        }
        int byte1 = buff.getAtIndexAndInc();
        int byte2 = buff.getAtIndexAndInc();
        return new Play(byte1, byte2);
    }

    @Override
    public void loadByteArray(SdfBuffer buffer) {
        buffer.setAtIndexAndInc(this.byte1);
        buffer.setAtIndexAndInc(this.byte2);
        super.loadByteArray(buffer);
    }

    @Override
    public String toString() {
        return "Play Fragment " + this.handleVal() + "\n";
    }

    @Override
    public String oneInstructionString() {
        return this.name() + " " + this.handleVal() + "," + this.brkVal() + "," + this.wavebrkFlagsVal() + "\n";
    }

    @Override
    public String allInstructionString(String indent) {
        return indent + this.oneInstructionString();
    }
}

