/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.sdf;

import java.util.ArrayList;
import java.util.List;
import jmri.jmrix.loconet.sdf.BranchTo;
import jmri.jmrix.loconet.sdf.ChannelStart;
import jmri.jmrix.loconet.sdf.DelaySound;
import jmri.jmrix.loconet.sdf.EndSound;
import jmri.jmrix.loconet.sdf.FourByteMacro;
import jmri.jmrix.loconet.sdf.GenerateTrigger;
import jmri.jmrix.loconet.sdf.InitiateSound;
import jmri.jmrix.loconet.sdf.LoadModifier;
import jmri.jmrix.loconet.sdf.MaskCompare;
import jmri.jmrix.loconet.sdf.Play;
import jmri.jmrix.loconet.sdf.SdfBuffer;
import jmri.jmrix.loconet.sdf.SdfConstants;
import jmri.jmrix.loconet.sdf.SdlVersion;
import jmri.jmrix.loconet.sdf.SkemeStart;
import jmri.jmrix.loconet.sdf.SkipOnTrigger;
import jmri.jmrix.loconet.sdf.TwoByteMacro;
import jmri.util.StringUtil;

public abstract class SdfMacro
implements SdfConstants {
    ArrayList<SdfMacro> children = null;

    public abstract String name();

    public abstract int length();

    public abstract String toString();

    public abstract String oneInstructionString();

    public abstract String allInstructionString(String var1);

    public List<SdfMacro> getChildren() {
        return this.children;
    }

    public int totalLength() {
        int result = this.length();
        List<SdfMacro> l = this.getChildren();
        if (l == null) {
            return result;
        }
        for (int i = 0; i < l.size(); ++i) {
            result += l.get(i).totalLength();
        }
        return result;
    }

    public void loadByteArray(SdfBuffer buffer) {
        List<SdfMacro> l = this.getChildren();
        if (l == null) {
            return;
        }
        for (int i = 0; i < l.size(); ++i) {
            l.get(i).loadByteArray(buffer);
        }
    }

    public static SdfMacro decodeInstruction(SdfBuffer buff) {
        SdfMacro m = ChannelStart.match(buff);
        if (m != null) {
            return m;
        }
        m = SdlVersion.match(buff);
        if (m != null) {
            return m;
        }
        m = SkemeStart.match(buff);
        if (m != null) {
            return m;
        }
        m = GenerateTrigger.match(buff);
        if (m != null) {
            return m;
        }
        m = EndSound.match(buff);
        if (m != null) {
            return m;
        }
        m = DelaySound.match(buff);
        if (m != null) {
            return m;
        }
        m = SkipOnTrigger.match(buff);
        if (m != null) {
            return m;
        }
        m = InitiateSound.match(buff);
        if (m != null) {
            return m;
        }
        m = MaskCompare.match(buff);
        if (m != null) {
            return m;
        }
        m = LoadModifier.match(buff);
        if (m != null) {
            return m;
        }
        m = BranchTo.match(buff);
        if (m != null) {
            return m;
        }
        m = Play.match(buff);
        if (m != null) {
            return m;
        }
        m = FourByteMacro.match(buff);
        if (m != null) {
            return m;
        }
        return TwoByteMacro.match(buff);
    }

    String decodeFlags(int input, int[] values, int[] masks, String[] labels) {
        String[] names = StringUtil.getNamesFromStateMasked(input, values, masks, labels);
        if (names.length == 0) {
            return labels[labels.length - 1];
        }
        if (names.length == 1) {
            return names[0];
        }
        StringBuilder output = new StringBuilder(names[0]);
        for (int i = 1; i < names.length; ++i) {
            output.append("+").append(names[i]);
        }
        return output.toString();
    }

    String decodeState(int input, int[] values, String[] labels) {
        String val = StringUtil.getNameFromState(input, values, labels);
        if (val == null) {
            return labels[labels.length - 1];
        }
        return val;
    }
}

