/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.sdf;

import jmri.jmrix.loconet.sdf.SdfBuffer;
import jmri.jmrix.loconet.sdf.SdfMacro;
import jmri.util.StringUtil;

public class SkipOnTrigger
extends SdfMacro {
    int byte1;
    int byte2;
    int logic;
    int trigger;

    public SkipOnTrigger(int byte1, int byte2) {
        this.byte1 = byte1;
        this.byte2 = byte2;
        this.logic = byte1 & 3;
        this.trigger = byte2;
    }

    @Override
    public String name() {
        return "SKIP_ON_TRIGGER";
    }

    @Override
    public int length() {
        return 2;
    }

    String logicVal() {
        return this.decodeFlags(this.logic, trigLogicCodes, trigLogicMasks, trigLogicNames);
    }

    String triggerVal() {
        String trigName = StringUtil.getNameFromState(this.trigger, triggerCodes, triggerNames);
        if (trigName != null) {
            return trigName;
        }
        return "(trigger = 0x" + StringUtil.twoHexFromInt(this.trigger) + ")";
    }

    public static SdfMacro match(SdfBuffer buff) {
        if ((buff.getAtIndex() & 0xFC) != 4) {
            return null;
        }
        int byte1 = buff.getAtIndexAndInc();
        int byte2 = buff.getAtIndexAndInc();
        return new SkipOnTrigger(byte1, byte2);
    }

    @Override
    public void loadByteArray(SdfBuffer buffer) {
        buffer.setAtIndexAndInc(this.byte1);
        buffer.setAtIndexAndInc(this.byte2);
        super.loadByteArray(buffer);
    }

    @Override
    public String toString() {
        return "Skip on Trigger\n";
    }

    @Override
    public String oneInstructionString() {
        return this.name() + " " + this.logicVal() + ", " + this.triggerVal() + "\n";
    }

    @Override
    public String allInstructionString(String indent) {
        return indent + this.oneInstructionString();
    }
}

