/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.sdf;

import jmri.jmrix.loconet.sdf.SdfBuffer;
import jmri.jmrix.loconet.sdf.SdfMacro;
import jmri.util.StringUtil;

public class TwoByteMacro
extends SdfMacro {
    byte[] bytes = new byte[2];

    public TwoByteMacro(int byte1, int byte2) {
        this.bytes[0] = (byte)(byte1 & 0xFF);
        this.bytes[1] = (byte)(byte2 & 0xFF);
    }

    @Override
    public String name() {
        return "Two Byte Macro";
    }

    @Override
    public int length() {
        return 2;
    }

    public static SdfMacro match(SdfBuffer buff) {
        return new TwoByteMacro(buff.getAtIndexAndInc(), buff.getAtIndexAndInc());
    }

    @Override
    public void loadByteArray(SdfBuffer buffer) {
        buffer.setAtIndexAndInc(this.bytes[0]);
        buffer.setAtIndexAndInc(this.bytes[1]);
        super.loadByteArray(buffer);
    }

    @Override
    public String toString() {
        return this.name() + " " + StringUtil.hexStringFromBytes(this.bytes) + "\n";
    }

    @Override
    public String oneInstructionString() {
        return this.name() + " " + StringUtil.hexStringFromBytes(this.bytes) + "\n";
    }

    @Override
    public String allInstructionString(String indent) {
        return indent + this.oneInstructionString();
    }
}

