/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.sdfeditor;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import jmri.jmrix.loconet.sdf.BranchTo;
import jmri.jmrix.loconet.sdf.ChannelStart;
import jmri.jmrix.loconet.sdf.DelaySound;
import jmri.jmrix.loconet.sdf.EndSound;
import jmri.jmrix.loconet.sdf.FourByteMacro;
import jmri.jmrix.loconet.sdf.GenerateTrigger;
import jmri.jmrix.loconet.sdf.InitiateSound;
import jmri.jmrix.loconet.sdf.LoadModifier;
import jmri.jmrix.loconet.sdf.MaskCompare;
import jmri.jmrix.loconet.sdf.Play;
import jmri.jmrix.loconet.sdf.SdfMacro;
import jmri.jmrix.loconet.sdf.SdlVersion;
import jmri.jmrix.loconet.sdf.SkemeStart;
import jmri.jmrix.loconet.sdf.SkipOnTrigger;
import jmri.jmrix.loconet.sdf.TwoByteMacro;
import jmri.jmrix.loconet.sdfeditor.BranchToEditor;
import jmri.jmrix.loconet.sdfeditor.ChannelStartEditor;
import jmri.jmrix.loconet.sdfeditor.DelaySoundEditor;
import jmri.jmrix.loconet.sdfeditor.EditorPane;
import jmri.jmrix.loconet.sdfeditor.EndSoundEditor;
import jmri.jmrix.loconet.sdfeditor.FourByteMacroEditor;
import jmri.jmrix.loconet.sdfeditor.GenerateTriggerEditor;
import jmri.jmrix.loconet.sdfeditor.InitiateSoundEditor;
import jmri.jmrix.loconet.sdfeditor.LoadModifierEditor;
import jmri.jmrix.loconet.sdfeditor.MaskCompareEditor;
import jmri.jmrix.loconet.sdfeditor.PlayEditor;
import jmri.jmrix.loconet.sdfeditor.SdlVersionEditor;
import jmri.jmrix.loconet.sdfeditor.SkemeStartEditor;
import jmri.jmrix.loconet.sdfeditor.SkipOnTriggerEditor;
import jmri.jmrix.loconet.sdfeditor.TwoByteMacroEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SdfMacroEditor
extends JPanel {
    SdfMacro inst;
    DefaultMutableTreeNode treenode = null;
    EditorPane editor = null;
    private static final Logger log = LoggerFactory.getLogger(SdfMacroEditor.class);

    public SdfMacroEditor(SdfMacro inst) {
        this.inst = inst;
        this.add(new JLabel("This instruction has no options to set."));
    }

    public void update() {
    }

    SdfMacro getMacro() {
        return this.inst;
    }

    public void updated() {
        if (this.treenode != null) {
            this.treenode.setUserObject(this);
        }
        if (this.editor != null) {
            this.editor.updateSummary();
        }
    }

    @Override
    public String toString() {
        return this.inst.toString();
    }

    public String oneInstructionString() {
        return this.inst.oneInstructionString();
    }

    public String allInstructionString(String indent) {
        return this.inst.allInstructionString(indent);
    }

    public void setNotify(DefaultMutableTreeNode node, EditorPane pane) {
        this.treenode = node;
        this.editor = pane;
    }

    public static SdfMacroEditor attachEditor(SdfMacro inst) {
        if (inst instanceof ChannelStart) {
            return new ChannelStartEditor(inst);
        }
        if (inst instanceof SdlVersion) {
            return new SdlVersionEditor(inst);
        }
        if (inst instanceof SkemeStart) {
            return new SkemeStartEditor(inst);
        }
        if (inst instanceof GenerateTrigger) {
            return new GenerateTriggerEditor(inst);
        }
        if (inst instanceof EndSound) {
            return new EndSoundEditor(inst);
        }
        if (inst instanceof DelaySound) {
            return new DelaySoundEditor(inst);
        }
        if (inst instanceof SkipOnTrigger) {
            return new SkipOnTriggerEditor(inst);
        }
        if (inst instanceof InitiateSound) {
            return new InitiateSoundEditor(inst);
        }
        if (inst instanceof MaskCompare) {
            return new MaskCompareEditor(inst);
        }
        if (inst instanceof LoadModifier) {
            return new LoadModifierEditor(inst);
        }
        if (inst instanceof BranchTo) {
            return new BranchToEditor(inst);
        }
        if (inst instanceof Play) {
            return new PlayEditor(inst);
        }
        if (inst instanceof FourByteMacro) {
            return new FourByteMacroEditor(inst);
        }
        if (inst instanceof TwoByteMacro) {
            return new TwoByteMacroEditor(inst);
        }
        log.error("PANIC");
        return null;
    }
}

