/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.slotmon;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import jmri.CommandStation;
import jmri.NmraPacket;
import jmri.Throttle;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSlot;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.SlotListener;
import jmri.jmrix.loconet.slotmon.Bundle;
import jmri.util.StringUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotMonDataModel
extends AbstractTableModel
implements SlotListener {
    public static final int SLOTCOLUMN = 0;
    public static final int ESTOPCOLUMN = 1;
    public static final int ADDRCOLUMN = 2;
    public static final int SPDCOLUMN = 3;
    public static final int TYPECOLUMN = 4;
    public static final int STATCOLUMN = 5;
    public static final int DISPCOLUMN = 6;
    public static final int CONSCOLUMN = 7;
    public static final int CONSISTADDRESS = 8;
    public static final int THROTCOLUMN = 9;
    public static final int DIRCOLUMN = 10;
    public static final int F0COLUMN = 11;
    public static final int F1COLUMN = 12;
    public static final int F2COLUMN = 13;
    public static final int F3COLUMN = 14;
    public static final int F4COLUMN = 15;
    public static final int F5COLUMN = 16;
    public static final int F6COLUMN = 17;
    public static final int F7COLUMN = 18;
    public static final int F8COLUMN = 19;
    public static final int F9COLUMN = 20;
    public static final int F10COLUMN = 21;
    public static final int F11COLUMN = 22;
    public static final int F12COLUMN = 23;
    public static final int F13COLUMN = 24;
    public static final int F14COLUMN = 25;
    public static final int F15COLUMN = 26;
    public static final int F16COLUMN = 27;
    public static final int F17COLUMN = 28;
    public static final int F18COLUMN = 29;
    public static final int F19COLUMN = 30;
    public static final int F20COLUMN = 31;
    public static final int F21COLUMN = 32;
    public static final int F22COLUMN = 33;
    public static final int F23COLUMN = 34;
    public static final int F24COLUMN = 35;
    public static final int F25COLUMN = 36;
    public static final int F26COLUMN = 37;
    public static final int F27COLUMN = 38;
    public static final int F28COLUMN = 39;
    private int numRows = 128;
    private int columns;
    private final transient LocoNetSystemConnectionMemo memo;
    private static final Logger log = LoggerFactory.getLogger(SlotMonDataModel.class);

    SlotMonDataModel(int row, int column, LocoNetSystemConnectionMemo memo) {
        this.memo = memo;
        this.columns = column;
        this.numRows = row;
        memo.getSlotManager().addSlotListener(this);
        memo.getSlotManager().update();
    }

    public void refreshSlots() {
        this.memo.getSlotManager().update();
    }

    @Override
    public int getRowCount() {
        return this.numRows;
    }

    @Override
    public int getColumnCount() {
        return this.columns;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("SlotCol");
            }
            case 1: {
                return "";
            }
            case 2: {
                return Bundle.getMessage("AddressCol");
            }
            case 3: {
                return Bundle.getMessage("SpeedCol");
            }
            case 4: {
                return Bundle.getMessage("StatusCol");
            }
            case 5: {
                return Bundle.getMessage("UseCol");
            }
            case 7: {
                return Bundle.getMessage("ConsistedCol");
            }
            case 8: {
                return Bundle.getMessage("ConsistAddress");
            }
            case 10: {
                return Bundle.getMessage("DirectionCol");
            }
            case 6: {
                return "";
            }
            case 11: {
                return Throttle.getFunctionString(0);
            }
            case 12: {
                return Throttle.getFunctionString(1);
            }
            case 13: {
                return Throttle.getFunctionString(2);
            }
            case 14: {
                return Throttle.getFunctionString(3);
            }
            case 15: {
                return Throttle.getFunctionString(4);
            }
            case 16: {
                return Throttle.getFunctionString(5);
            }
            case 17: {
                return Throttle.getFunctionString(6);
            }
            case 18: {
                return Throttle.getFunctionString(7);
            }
            case 19: {
                return Throttle.getFunctionString(8);
            }
            case 20: {
                return Throttle.getFunctionString(9);
            }
            case 21: {
                return Throttle.getFunctionString(10);
            }
            case 22: {
                return Throttle.getFunctionString(11);
            }
            case 23: {
                return Throttle.getFunctionString(12);
            }
            case 24: {
                return Throttle.getFunctionString(13);
            }
            case 25: {
                return Throttle.getFunctionString(14);
            }
            case 26: {
                return Throttle.getFunctionString(15);
            }
            case 27: {
                return Throttle.getFunctionString(16);
            }
            case 28: {
                return Throttle.getFunctionString(17);
            }
            case 29: {
                return Throttle.getFunctionString(16);
            }
            case 30: {
                return Throttle.getFunctionString(19);
            }
            case 31: {
                return Throttle.getFunctionString(20);
            }
            case 32: {
                return Throttle.getFunctionString(21);
            }
            case 33: {
                return Throttle.getFunctionString(22);
            }
            case 34: {
                return Throttle.getFunctionString(23);
            }
            case 35: {
                return Throttle.getFunctionString(24);
            }
            case 36: {
                return Throttle.getFunctionString(25);
            }
            case 37: {
                return Throttle.getFunctionString(26);
            }
            case 38: {
                return Throttle.getFunctionString(27);
            }
            case 39: {
                return Throttle.getFunctionString(28);
            }
            case 9: {
                return Bundle.getMessage("ThrottleIDCol");
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: 
            case 2: 
            case 8: {
                return Integer.class;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                return String.class;
            }
            case 1: 
            case 6: {
                return JButton.class;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                return Boolean.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        LocoNetSlot s = this.memo.getSlotManager().slot(row);
        switch (col) {
            case 1: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                return !s.isSystemSlot();
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        LocoNetSlot s = this.memo.getSlotManager().slot(row);
        if (s == null) {
            log.error("slot pointer was null for slot row: {} col: {}", (Object)row, (Object)col);
            return null;
        }
        switch (col) {
            case 0: {
                return row;
            }
            case 1: {
                return Bundle.getMessage("ButtonEstop");
            }
            case 2: {
                return s.locoAddr();
            }
            case 3: {
                switch (s.consistStatus()) {
                    case 0: 
                    case 8: {
                        Object t = s.speed() == 1 ? "(estop) 1" : "          " + s.speed();
                        return ((String)t).substring(((String)t).length() - 9, ((String)t).length());
                    }
                    case 64: 
                    case 72: {
                        return Bundle.getMessage("SlotSpeedConsist");
                    }
                }
                return Bundle.getMessage("StateError");
            }
            case 4: {
                switch (s.decoderType()) {
                    case 7: {
                        return "128 step adv";
                    }
                    case 4: {
                        return " 28 step adv";
                    }
                    case 3: {
                        return "128 step";
                    }
                    case 2: {
                        return " 14 step";
                    }
                    case 1: {
                        return " 28 step trinary";
                    }
                    case 0: {
                        return " 28 step";
                    }
                }
                return Bundle.getMessage("StateUnknown");
            }
            case 5: {
                switch (s.slotStatus()) {
                    case 48: {
                        return Bundle.getMessage("StateInUse");
                    }
                    case 32: {
                        return Bundle.getMessage("StateIdle");
                    }
                    case 16: {
                        return Bundle.getMessage("StateCommon");
                    }
                    case 0: {
                        return Bundle.getMessage("StateFree");
                    }
                }
                return Bundle.getMessage("StateError");
            }
            case 7: {
                switch (s.consistStatus()) {
                    case 72: {
                        if (s.getProtocol() == 2) {
                            return Bundle.getMessage("SlotConsistMidX", s.getLeadSlot());
                        }
                        String t = Bundle.getMessage("SlotConsistMidX", s.speed());
                        return t;
                    }
                    case 8: {
                        return Bundle.getMessage("SlotConsistTop");
                    }
                    case 64: {
                        if (s.getProtocol() == 2) {
                            return Bundle.getMessage("SlotConsistSubX", s.getLeadSlot());
                        }
                        String t = Bundle.getMessage("SlotConsistSubX", s.speed());
                        return t;
                    }
                    case 0: {
                        return Bundle.getMessage("SlotConsistNone");
                    }
                }
                return Bundle.getMessage("StateError");
            }
            case 8: {
                switch (s.consistStatus()) {
                    case 8: {
                        return s.locoAddr();
                    }
                    case 64: 
                    case 72: {
                        if (s.getProtocol() == 2) {
                            return this.memo.getSlotManager().slot(s.getLeadSlot()).locoAddr();
                        }
                        return this.memo.getSlotManager().slot(s.speed()).locoAddr();
                    }
                    case 0: {
                        return 0;
                    }
                }
                return 0;
            }
            case 6: {
                return Bundle.getMessage("ButtonRelease");
            }
            case 10: {
                return s.isForward() ? Bundle.getMessage("DirColForward") : Bundle.getMessage("DirColReverse");
            }
            case 11: {
                return s.isF0();
            }
            case 12: {
                return s.isF1();
            }
            case 13: {
                return s.isF2();
            }
            case 14: {
                return s.isF3();
            }
            case 15: {
                return s.isF4();
            }
            case 16: {
                return s.isF5();
            }
            case 17: {
                return s.isF6();
            }
            case 18: {
                return s.isF7();
            }
            case 19: {
                return s.isF8();
            }
            case 20: {
                return s.isF9();
            }
            case 21: {
                return s.isF10();
            }
            case 22: {
                return s.isF11();
            }
            case 23: {
                return s.isF12();
            }
            case 24: {
                return s.isF13();
            }
            case 25: {
                return s.isF14();
            }
            case 26: {
                return s.isF15();
            }
            case 27: {
                return s.isF16();
            }
            case 28: {
                return s.isF17();
            }
            case 29: {
                return s.isF18();
            }
            case 30: {
                return s.isF19();
            }
            case 31: {
                return s.isF20();
            }
            case 32: {
                return s.isF21();
            }
            case 33: {
                return s.isF22();
            }
            case 34: {
                return s.isF23();
            }
            case 35: {
                return s.isF24();
            }
            case 36: {
                return s.isF25();
            }
            case 37: {
                return s.isF26();
            }
            case 38: {
                return s.isF27();
            }
            case 39: {
                return s.isF28();
            }
            case 9: {
                int upper = s.id() >> 7 & 0x7F;
                int lower = s.id() & 0x7F;
                return StringUtil.twoHexFromInt(upper) + " " + StringUtil.twoHexFromInt(lower);
            }
        }
        log.error("internal state inconsistent with table requst for {} {}", (Object)row, (Object)col);
        return null;
    }

    public int getPreferredWidth(int col) {
        switch (col) {
            case 0: {
                return new JTextField((int)3).getPreferredSize().width;
            }
            case 1: {
                return new JButton((String)Bundle.getMessage((String)"ButtonEstop")).getPreferredSize().width;
            }
            case 2: {
                return new JTextField((int)5).getPreferredSize().width;
            }
            case 3: 
            case 5: {
                return new JTextField((int)6).getPreferredSize().width;
            }
            case 4: {
                return new JTextField((int)12).getPreferredSize().width;
            }
            case 7: {
                return new JTextField((int)4).getPreferredSize().width;
            }
            case 8: {
                return new JTextField((String)" 0000 ").getPreferredSize().width;
            }
            case 10: {
                int m = Math.max(Bundle.getMessage("DirColForward").length(), Bundle.getMessage("DirColReverse").length());
                m = Math.max(m, Bundle.getMessage("DirectionCol").length());
                return new JTextField((int)m).getPreferredSize().width;
            }
            case 6: {
                return new JButton((String)Bundle.getMessage((String)"ButtonRelease")).getPreferredSize().width;
            }
            case 9: {
                return new JTextField((int)7).getPreferredSize().width;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                return Math.max(new JCheckBox().getPreferredSize().width, new JTextField((String)"F99").getPreferredSize().width);
            }
        }
        return new JLabel((String)" <unknown> ").getPreferredSize().width;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        LocoNetSlot s = this.memo.getSlotManager().slot(row);
        if (s == null) {
            log.error("slot pointer was null for slot row: {} col: {}", (Object)row, (Object)col);
            return;
        }
        switch (col) {
            case 1: {
                log.debug("Start estop in slot {}", (Object)row);
                if (s.consistStatus() == 64 || s.consistStatus() == 72) {
                    Object[] options = new Object[]{Bundle.getMessage("ButtonOK"), Bundle.getMessage("ButtonCancel")};
                    int result = JmriJOptionPane.showOptionDialog(null, Bundle.getMessage("SlotEstopWarning"), Bundle.getMessage("WarningTitle"), -1, 2, null, options, options[1]);
                    if (result != 0) {
                        return;
                    }
                }
                LocoNetMessage msg = s.writeSpeed(1);
                this.memo.getLnTrafficController().sendLocoNetMessage(msg);
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 11: {
                if (s.getProtocol() != 2) {
                    this.sendFunctionGroup1(s, col, row);
                } else {
                    this.sendExpFunctionGroup1(s, col, row);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 12: {
                if (s.getProtocol() != 2) {
                    this.sendFunctionGroup1(s, col, row);
                } else {
                    this.sendExpFunctionGroup1(s, col, row);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 13: {
                if (s.getProtocol() != 2) {
                    this.sendFunctionGroup1(s, col, row);
                } else {
                    this.sendExpFunctionGroup1(s, col, row);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 14: {
                if (s.getProtocol() != 2) {
                    this.sendFunctionGroup1(s, col, row);
                } else {
                    this.sendExpFunctionGroup1(s, col, row);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 15: {
                if (s.getProtocol() != 2) {
                    this.sendFunctionGroup1(s, col, row);
                } else {
                    this.sendExpFunctionGroup1(s, col, row);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 16: {
                if (s.getProtocol() != 2) {
                    this.sendFunctionGroup2(s, col, row);
                } else {
                    this.sendExpFunctionGroup1(s, col, row);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 17: {
                if (s.getProtocol() != 2) {
                    this.sendFunctionGroup2(s, col, row);
                } else {
                    this.sendExpFunctionGroup1(s, col, row);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 18: {
                if (s.getProtocol() != 2) {
                    this.sendFunctionGroup2(s, col, row);
                } else {
                    this.sendExpFunctionGroup2(s, col, row);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 19: {
                if (s.getProtocol() != 2) {
                    this.sendFunctionGroup2(s, col, row);
                } else {
                    this.sendExpFunctionGroup2(s, col, row);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 20: {
                if (s.getProtocol() != 2) {
                    this.sendFunctionGroup3(s, col, row);
                } else {
                    this.sendExpFunctionGroup2(s, col, row);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 21: {
                if (s.getProtocol() != 2) {
                    this.sendFunctionGroup3(s, col, row);
                } else {
                    this.sendExpFunctionGroup2(s, col, row);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 22: {
                if (s.getProtocol() != 2) {
                    this.sendFunctionGroup3(s, col, row);
                } else {
                    this.sendExpFunctionGroup2(s, col, row);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 23: {
                if (s.getProtocol() != 2) {
                    this.sendFunctionGroup3(s, col, row);
                } else {
                    this.sendExpFunctionGroup2(s, col, row);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 24: {
                if (s.getProtocol() != 2) {
                    this.sendFunctionGroup4(s, col, row);
                } else {
                    this.sendExpFunctionGroup2(s, col, row);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 25: {
                if (s.getProtocol() != 2) {
                    this.sendFunctionGroup4(s, col, row);
                } else {
                    this.sendExpFunctionGroup3(s, col, row);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 26: {
                if (s.getProtocol() != 2) {
                    this.sendFunctionGroup4(s, col, row);
                } else {
                    this.sendExpFunctionGroup3(s, col, row);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 27: {
                if (s.getProtocol() != 2) {
                    this.sendFunctionGroup4(s, col, row);
                } else {
                    this.sendExpFunctionGroup3(s, col, row);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 28: {
                if (s.getProtocol() != 2) {
                    this.sendFunctionGroup4(s, col, row);
                } else {
                    this.sendExpFunctionGroup3(s, col, row);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 29: {
                if (s.getProtocol() != 2) {
                    this.sendFunctionGroup4(s, col, row);
                } else {
                    this.sendExpFunctionGroup3(s, col, row);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 30: {
                if (s.getProtocol() != 2) {
                    this.sendFunctionGroup4(s, col, row);
                } else {
                    this.sendExpFunctionGroup3(s, col, row);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 31: {
                if (s.getProtocol() != 2) {
                    this.sendFunctionGroup4(s, col, row);
                } else {
                    this.sendExpFunctionGroup3(s, col, row);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 32: {
                if (s.getProtocol() != 2) {
                    this.sendFunctionGroup5(s, col, row);
                } else {
                    this.sendExpFunctionGroup4(s, col, row);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 33: {
                if (s.getProtocol() != 2) {
                    this.sendFunctionGroup5(s, col, row);
                } else {
                    this.sendExpFunctionGroup4(s, col, row);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 34: {
                if (s.getProtocol() != 2) {
                    this.sendFunctionGroup5(s, col, row);
                } else {
                    this.sendExpFunctionGroup4(s, col, row);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 35: {
                if (s.getProtocol() != 2) {
                    this.sendFunctionGroup5(s, col, row);
                } else {
                    this.sendExpFunctionGroup4(s, col, row);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 36: {
                if (s.getProtocol() != 2) {
                    this.sendFunctionGroup5(s, col, row);
                } else {
                    this.sendExpFunctionGroup4(s, col, row);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 37: {
                if (s.getProtocol() != 2) {
                    this.sendFunctionGroup5(s, col, row);
                } else {
                    this.sendExpFunctionGroup4(s, col, row);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 38: {
                if (s.getProtocol() != 2) {
                    this.sendFunctionGroup5(s, col, row);
                } else {
                    this.sendExpFunctionGroup4(s, col, row);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 39: {
                if (s.getProtocol() != 2) {
                    this.sendFunctionGroup5(s, col, row);
                } else {
                    this.sendExpFunctionGroup4(s, col, row);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 6: {
                log.debug("Start freeing slot {}", (Object)row);
                if (s.slotStatus() != 0) {
                    if (s.consistStatus() != 0) {
                        Object[] options = new Object[]{Bundle.getMessage("ButtonOK"), Bundle.getMessage("ButtonCancel")};
                        int result = JmriJOptionPane.showOptionDialog(null, "Freeing a consist member will destroy the consist.\n\nAre you sure you want to do that?", Bundle.getMessage("WarningTitle"), -1, 2, null, options, options[1]);
                        if (result != 0) {
                            return;
                        }
                    }
                    this.memo.getLnTrafficController().sendLocoNetMessage(s.writeStatus(0));
                } else {
                    log.debug("Slot not in use");
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
        }
    }

    public void clearAllSlots() {
        int count = this.getRowCount();
        for (int row = 0; row < count - 1; ++row) {
            LocoNetSlot s = this.memo.getSlotManager().slot(row);
            if (s.slotStatus() != 48 && s.consistStatus() == 0) {
                log.debug("Freeing {} from slot {}, old status: {}", new Object[]{s.locoAddr(), s.getSlot(), s.slotStatus()});
                this.memo.getLnTrafficController().sendLocoNetMessage(s.writeStatus(0));
                this.fireTableRowsUpdated(row, row);
            }
            count = this.getRowCount();
        }
    }

    public void configureTable(JTable slotTable) {
    }

    @Override
    public synchronized void notifyChangedSlot(LocoNetSlot s) {
        int slotNum = s.getSlot();
        if (slotNum == 127) {
            int slotStatus2 = s.ss2() & 0x78;
            if (slotStatus2 > 0) {
                this.memo.getSlotManager().update();
            }
        } else {
            slotNum = -1;
        }
        SwingUtilities.invokeLater(new Notify(slotNum, this));
    }

    protected LocoNetSlot getSlot(int row) {
        return this.memo.getSlotManager().slot(row);
    }

    public void estopAll() {
        for (int slotNum = 0; slotNum < 120; ++slotNum) {
            LocoNetSlot s = this.memo.getSlotManager().slot(slotNum);
            if (s.slotStatus() == 0 || s.consistStatus() != 0 && s.consistStatus() != 8 || s.speed() == 1) continue;
            LocoNetMessage msg = s.writeSpeed(1);
            this.memo.getLnTrafficController().sendLocoNetMessage(msg);
        }
    }

    protected void sendFunctionGroup1(LocoNetSlot slot, int col, int row) {
        boolean tempF3;
        boolean tempF2;
        boolean tempF1;
        boolean tempF0;
        log.debug("F0-F4 change requested {}", (Object)row);
        if (slot == null) {
            log.error("slot pointer was null for slot row: {} col: {}", (Object)row, (Object)col);
            return;
        }
        boolean bl = col == 11 ? !slot.isF0() : (tempF0 = slot.isF0());
        boolean bl2 = col == 12 ? !slot.isF1() : (tempF1 = slot.isF1());
        boolean bl3 = col == 13 ? !slot.isF2() : (tempF2 = slot.isF2());
        boolean bl4 = col == 14 ? !slot.isF3() : (tempF3 = slot.isF3());
        boolean tempF4 = col == 15 ? !slot.isF4() : slot.isF4();
        int new_dirf = (slot.isForward() ? 0 : 32) | (tempF0 ? 16 : 0) | (tempF1 ? 1 : 0) | (tempF2 ? 2 : 0) | (tempF3 ? 4 : 0) | (tempF4 ? 8 : 0);
        int status = slot.slotStatus();
        if (status != 48) {
            this.memo.getLnTrafficController().sendLocoNetMessage(slot.writeStatus(48));
        }
        LocoNetMessage msg = new LocoNetMessage(4);
        msg.setOpCode(161);
        msg.setElement(1, slot.getSlot());
        msg.setElement(2, new_dirf);
        this.memo.getLnTrafficController().sendLocoNetMessage(msg);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ex) {
            log.error("Interuppted Sleep", (Throwable)ex);
        }
        if (status != 48) {
            this.memo.getLnTrafficController().sendLocoNetMessage(slot.writeStatus(status));
        }
    }

    protected void sendFunctionGroup2(LocoNetSlot slot, int col, int row) {
        boolean tempF7;
        boolean tempF6;
        boolean tempF5;
        boolean bl = col == 16 ? !slot.isF5() : (tempF5 = slot.isF5());
        boolean bl2 = col == 17 ? !slot.isF6() : (tempF6 = slot.isF6());
        boolean bl3 = col == 18 ? !slot.isF7() : (tempF7 = slot.isF7());
        boolean tempF8 = col == 19 ? !slot.isF8() : slot.isF8();
        int new_snd = (tempF8 ? 8 : 0) | (tempF7 ? 4 : 0) | (tempF6 ? 2 : 0) | (tempF5 ? 1 : 0);
        int status = slot.slotStatus();
        if (status != 48) {
            this.memo.getLnTrafficController().sendLocoNetMessage(slot.writeStatus(48));
        }
        LocoNetMessage msg = new LocoNetMessage(4);
        msg.setOpCode(162);
        msg.setElement(1, slot.getSlot());
        msg.setElement(2, new_snd);
        this.memo.getLnTrafficController().sendLocoNetMessage(msg);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ex) {
            log.error("Interuppted Sleep", (Throwable)ex);
        }
        if (status != 48) {
            this.memo.getLnTrafficController().sendLocoNetMessage(slot.writeStatus(status));
        }
    }

    protected void sendFunctionGroup3(LocoNetSlot slot, int col, int row) {
        boolean tempF11;
        boolean tempF10;
        boolean tempF9;
        boolean bl = col == 20 ? !slot.isF9() : (tempF9 = slot.isF9());
        boolean bl2 = col == 21 ? !slot.isF10() : (tempF10 = slot.isF10());
        boolean bl3 = col == 22 ? !slot.isF11() : (tempF11 = slot.isF11());
        boolean tempF12 = col == 23 ? !slot.isF12() : slot.isF12();
        byte[] result = NmraPacket.function9Through12Packet(slot.locoAddr(), slot.locoAddr() >= 128, tempF9, tempF10, tempF11, tempF12);
        log.debug("sendFunctionGroup3 sending {} to LocoNet slot {}", (Object)result, (Object)slot.getSlot());
        this.memo.get(CommandStation.class).sendPacket(result, 4);
    }

    protected void sendFunctionGroup4(LocoNetSlot slot, int col, int row) {
        boolean tempF19;
        boolean tempF18;
        boolean tempF17;
        boolean tempF16;
        boolean tempF15;
        boolean tempF14;
        boolean tempF13;
        boolean bl = col == 24 ? !slot.isF13() : (tempF13 = slot.isF13());
        boolean bl2 = col == 25 ? !slot.isF14() : (tempF14 = slot.isF14());
        boolean bl3 = col == 26 ? !slot.isF15() : (tempF15 = slot.isF15());
        boolean bl4 = col == 27 ? !slot.isF16() : (tempF16 = slot.isF16());
        boolean bl5 = col == 28 ? !slot.isF17() : (tempF17 = slot.isF17());
        boolean bl6 = col == 29 ? !slot.isF18() : (tempF18 = slot.isF18());
        boolean bl7 = col == 30 ? !slot.isF19() : (tempF19 = slot.isF19());
        boolean tempF20 = col == 31 ? !slot.isF20() : slot.isF20();
        byte[] result = NmraPacket.function13Through20Packet(slot.locoAddr(), slot.locoAddr() >= 128, tempF13, tempF14, tempF15, tempF16, tempF17, tempF18, tempF19, tempF20);
        log.debug("sendFunctionGroup4 sending {} to LocoNet slot {}", (Object)result, (Object)slot.getSlot());
        this.memo.get(CommandStation.class).sendPacket(result, 4);
    }

    protected void sendFunctionGroup5(LocoNetSlot slot, int col, int row) {
        boolean tempF27;
        boolean tempF26;
        boolean tempF25;
        boolean tempF24;
        boolean tempF23;
        boolean tempF22;
        boolean tempF21;
        boolean bl = col == 32 ? !slot.isF21() : (tempF21 = slot.isF21());
        boolean bl2 = col == 33 ? !slot.isF22() : (tempF22 = slot.isF22());
        boolean bl3 = col == 34 ? !slot.isF23() : (tempF23 = slot.isF23());
        boolean bl4 = col == 35 ? !slot.isF24() : (tempF24 = slot.isF24());
        boolean bl5 = col == 36 ? !slot.isF25() : (tempF25 = slot.isF25());
        boolean bl6 = col == 37 ? !slot.isF26() : (tempF26 = slot.isF26());
        boolean bl7 = col == 38 ? !slot.isF27() : (tempF27 = slot.isF27());
        boolean tempF28 = col == 39 ? !slot.isF28() : slot.isF28();
        byte[] result = NmraPacket.function21Through28Packet(slot.locoAddr(), slot.locoAddr() >= 128, tempF21, tempF22, tempF23, tempF24, tempF25, tempF26, tempF27, tempF28);
        log.debug("sendFunctionGroup5 sending {} to LocoNet slot {}", (Object)result, (Object)slot.getSlot());
        this.memo.get(CommandStation.class).sendPacket(result, 4);
    }

    protected void sendExpFunctionGroup1(LocoNetSlot slot, int col, int row) {
        boolean tempF5;
        boolean tempF4;
        boolean tempF3;
        boolean tempF2;
        boolean tempF1;
        boolean tempF0;
        boolean bl = col == 11 ? !slot.isF0() : (tempF0 = slot.isF0());
        boolean bl2 = col == 12 ? !slot.isF1() : (tempF1 = slot.isF1());
        boolean bl3 = col == 13 ? !slot.isF2() : (tempF2 = slot.isF2());
        boolean bl4 = col == 14 ? !slot.isF3() : (tempF3 = slot.isF3());
        boolean bl5 = col == 15 ? !slot.isF4() : (tempF4 = slot.isF4());
        boolean bl6 = col == 16 ? !slot.isF5() : (tempF5 = slot.isF5());
        boolean tempF6 = col == 17 ? !slot.isF6() : slot.isF6();
        int new_F0F6 = (tempF5 ? 32 : 0) | (tempF6 ? 64 : 0) | (tempF0 ? 16 : 0) | (tempF1 ? 1 : 0) | (tempF2 ? 2 : 0) | (tempF3 ? 4 : 0) | (tempF4 ? 8 : 0);
        LocoNetMessage msg = new LocoNetMessage(6);
        msg.setOpCode(213);
        msg.setElement(1, slot.getSlot() / 128 | 0x10);
        msg.setElement(2, slot.getSlot() & 0x7F);
        msg.setElement(3, slot.id() & 0x7F);
        msg.setElement(4, new_F0F6);
        this.memo.getLnTrafficController().sendLocoNetMessage(msg);
    }

    protected void sendExpFunctionGroup2(LocoNetSlot slot, int col, int row) {
        boolean tempF12;
        boolean tempF11;
        boolean tempF10;
        boolean tempF9;
        boolean tempF8;
        boolean tempF7;
        boolean bl = col == 18 ? !slot.isF7() : (tempF7 = slot.isF7());
        boolean bl2 = col == 19 ? !slot.isF8() : (tempF8 = slot.isF8());
        boolean bl3 = col == 20 ? !slot.isF9() : (tempF9 = slot.isF9());
        boolean bl4 = col == 21 ? !slot.isF10() : (tempF10 = slot.isF10());
        boolean bl5 = col == 22 ? !slot.isF11() : (tempF11 = slot.isF11());
        boolean bl6 = col == 23 ? !slot.isF12() : (tempF12 = slot.isF12());
        boolean tempF13 = col == 24 ? !slot.isF13() : slot.isF13();
        int new_F7F13 = (tempF7 ? 1 : 0) | (tempF8 ? 2 : 0) | (tempF9 ? 4 : 0) | (tempF10 ? 8 : 0) | (tempF11 ? 16 : 0) | (tempF12 ? 32 : 0) | (tempF13 ? 64 : 0);
        LocoNetMessage msg = new LocoNetMessage(6);
        msg.setOpCode(213);
        msg.setElement(1, slot.getSlot() / 128 | 0x18);
        msg.setElement(2, slot.getSlot() & 0x7F);
        msg.setElement(3, slot.id() & 0x7F);
        msg.setElement(4, new_F7F13);
        this.memo.getLnTrafficController().sendLocoNetMessage(msg);
    }

    protected void sendExpFunctionGroup3(LocoNetSlot slot, int col, int row) {
        boolean tempF19;
        boolean tempF18;
        boolean tempF17;
        boolean tempF16;
        boolean tempF15;
        boolean tempF14;
        boolean bl = col == 25 ? !slot.isF14() : (tempF14 = slot.isF14());
        boolean bl2 = col == 26 ? !slot.isF15() : (tempF15 = slot.isF15());
        boolean bl3 = col == 27 ? !slot.isF16() : (tempF16 = slot.isF16());
        boolean bl4 = col == 28 ? !slot.isF17() : (tempF17 = slot.isF17());
        boolean bl5 = col == 29 ? !slot.isF18() : (tempF18 = slot.isF18());
        boolean bl6 = col == 30 ? !slot.isF19() : (tempF19 = slot.isF19());
        boolean tempF20 = col == 31 ? !slot.isF20() : slot.isF20();
        int new_F14F20 = (tempF14 ? 1 : 0) | (tempF15 ? 2 : 0) | (tempF16 ? 4 : 0) | (tempF17 ? 8 : 0) | (tempF18 ? 16 : 0) | (tempF19 ? 32 : 0) | (tempF20 ? 64 : 0);
        LocoNetMessage msg = new LocoNetMessage(6);
        msg.setOpCode(213);
        msg.setElement(1, slot.getSlot() / 128 | 0x20);
        msg.setElement(2, slot.getSlot() & 0x7F);
        msg.setElement(3, slot.id() & 0x7F);
        msg.setElement(4, new_F14F20);
        this.memo.getLnTrafficController().sendLocoNetMessage(msg);
    }

    protected void sendExpFunctionGroup4(LocoNetSlot slot, int col, int row) {
        boolean tempF27;
        boolean tempF26;
        boolean tempF25;
        boolean tempF24;
        boolean tempF23;
        boolean tempF22;
        boolean tempF21;
        boolean bl = col == 32 ? !slot.isF21() : (tempF21 = slot.isF21());
        boolean bl2 = col == 33 ? !slot.isF22() : (tempF22 = slot.isF22());
        boolean bl3 = col == 34 ? !slot.isF23() : (tempF23 = slot.isF23());
        boolean bl4 = col == 35 ? !slot.isF24() : (tempF24 = slot.isF24());
        boolean bl5 = col == 36 ? !slot.isF25() : (tempF25 = slot.isF25());
        boolean bl6 = col == 37 ? !slot.isF26() : (tempF26 = slot.isF26());
        boolean bl7 = col == 38 ? !slot.isF27() : (tempF27 = slot.isF27());
        boolean tempF28 = col == 39 ? !slot.isF28() : slot.isF28();
        int new_F14F20 = (tempF21 ? 1 : 0) | (tempF22 ? 2 : 0) | (tempF23 ? 4 : 0) | (tempF24 ? 8 : 0) | (tempF25 ? 16 : 0) | (tempF26 ? 32 : 0) | (tempF27 ? 64 : 0);
        LocoNetMessage msg = new LocoNetMessage(6);
        msg.setOpCode(213);
        if (!tempF28) {
            msg.setElement(1, slot.getSlot() / 128 | 0x28);
        } else {
            msg.setElement(1, slot.getSlot() / 128 | 0x30);
        }
        msg.setElement(2, slot.getSlot() & 0x7F);
        msg.setElement(3, slot.id() & 0x7F);
        msg.setElement(4, new_F14F20);
        this.memo.getLnTrafficController().sendLocoNetMessage(msg);
    }

    public void dispose() {
        this.memo.getSlotManager().removeSlotListener(this);
    }

    private static class Notify
    implements Runnable {
        private final int _row;
        AbstractTableModel _model;

        public Notify(int row, AbstractTableModel model) {
            this._row = row;
            this._model = model;
        }

        @Override
        public void run() {
            if (-1 == this._row) {
                this._model.fireTableDataChanged();
            } else {
                this._model.fireTableRowsUpdated(this._row, this._row);
            }
        }
    }
}

