/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.slotmon;

import java.lang.invoke.StringConcatFactory;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import jmri.InstanceManager;
import jmri.jmrix.loconet.LocoNetSlot;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.SlotListener;
import jmri.jmrix.loconet.SlotMapEntry;
import jmri.jmrix.loconet.slotmon.Bundle;
import jmri.jmrix.loconet.slotmon.SlotMonDataModel;
import jmri.jmrix.loconet.swing.LnPanel;
import jmri.swing.JmriJTablePersistenceManager;
import jmri.util.swing.WrapLayout;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import jmri.util.table.JTableToCsvAction;

public class SlotMonPane
extends LnPanel
implements SlotListener {
    protected final JCheckBox showUnusedCheckBox = new JCheckBox();
    protected final JCheckBox showSystemCheckBox = new JCheckBox();
    private JLabel dcsCSLabel = new JLabel(Bundle.getMessage("SlotMonCSLabel"));
    private JTextField dcsType = new JTextField();
    private JLabel dcsSlotsLabel = new JLabel(Bundle.getMessage("SlotMonTotalSlots"));
    private JTextField dcsSlots = new JTextField();
    private final JButton estopAllButton = new JButton(Bundle.getMessage("ButtonSlotMonEStopAll"));
    private final JButton clearAllButton = new JButton(Bundle.getMessage("ButtonSlotMonClearAll"));
    private final JButton refreshAllButton = new JButton(Bundle.getMessage("ButtonSlotRefresh"));
    private JPanel topPanel;
    private SlotMonDataModel slotModel;
    private JTable slotTable;
    private JScrollPane slotScroll;
    private transient TableRowSorter<SlotMonDataModel> sorter;

    @Override
    public void initComponents(LocoNetSystemConnectionMemo memo) {
        super.initComponents(memo);
        int columns = 40;
        if (memo.getSlotManager().getLoconetProtocol() != 2) {
            columns = 20;
        }
        this.slotModel = new SlotMonDataModel(memo.getSlotManager().getNumSlots(), columns, memo);
        this.slotTable = new JTable(this.slotModel);
        this.slotTable.setName(this.getTitle());
        this.sorter = new TableRowSorter<SlotMonDataModel>(this.slotModel);
        this.slotTable.setRowSorter(this.sorter);
        this.slotScroll = new JScrollPane(this.slotTable);
        this.showUnusedCheckBox.setText(Bundle.getMessage("TextSlotMonShowUnused"));
        this.showUnusedCheckBox.setVisible(true);
        this.showUnusedCheckBox.setSelected(false);
        this.showUnusedCheckBox.setToolTipText(Bundle.getMessage("TooltipSlotMonShowUnused"));
        this.showSystemCheckBox.setText(Bundle.getMessage("TextSlotMonShowSystem"));
        this.showSystemCheckBox.setVisible(true);
        this.showSystemCheckBox.setSelected(false);
        this.showSystemCheckBox.setToolTipText(Bundle.getMessage("TooltipSlotMonShowSystem"));
        this.slotTable.getTableHeader().setReorderingAllowed(true);
        this.slotTable.setAutoResizeMode(0);
        for (int i = 0; i < this.slotTable.getColumnCount(); ++i) {
            int width = this.slotModel.getPreferredWidth(i);
            this.slotTable.getColumnModel().getColumn(i).setPreferredWidth(width);
        }
        this.slotTable.sizeColumnsToFit(-1);
        InstanceManager.getOptionalDefault(JmriJTablePersistenceManager.class).ifPresent(tpm -> {});
        this.setColumnToHoldButton(this.slotTable, this.slotTable.convertColumnIndexToView(6));
        this.setColumnToHoldEStopButton(this.slotTable, this.slotTable.convertColumnIndexToView(1));
        this.setColumnForBlankWhenZero(this.slotTable, this.slotTable.convertColumnIndexToView(8));
        this.refreshAllButton.addActionListener(e -> this.slotModel.refreshSlots());
        this.showUnusedCheckBox.addActionListener(e -> this.filter());
        this.showSystemCheckBox.addActionListener(e -> this.filter());
        this.estopAllButton.addActionListener(e -> this.slotModel.estopAll());
        this.clearAllButton.addActionListener(e -> this.slotModel.clearAllSlots());
        this.filter();
        this.setLayout(new BoxLayout(this, 1));
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new WrapLayout());
        this.topPanel.add(this.dcsCSLabel);
        this.dcsType.setEditable(false);
        this.topPanel.add(this.dcsType);
        this.topPanel.add(this.dcsSlotsLabel);
        this.dcsSlots.setEditable(false);
        this.topPanel.add(this.dcsSlots);
        this.showHideSlot250Data(false);
        this.topPanel.add(this.refreshAllButton);
        this.topPanel.add(this.showUnusedCheckBox);
        this.topPanel.add(this.showSystemCheckBox);
        this.topPanel.add(this.estopAllButton);
        this.topPanel.add(this.clearAllButton);
        this.add(this.topPanel);
        this.add(this.slotScroll);
        memo.getSlotManager().addSlotListener(this);
        if (this.topPanel.getMaximumSize().height > 0 && this.topPanel.getMaximumSize().width > 0) {
            this.topPanel.setMaximumSize(this.topPanel.getPreferredSize());
        }
    }

    void setColumnToHoldButton(JTable slotTable, int column) {
        TableColumnModel tcm = slotTable.getColumnModel();
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        tcm.getColumn(column).setCellRenderer(buttonRenderer);
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        slotTable.setDefaultEditor(JButton.class, buttonEditor);
        slotTable.setRowHeight(new JButton((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"  \u0001"}, (Object)this.slotModel.getValueAt((int)1, (int)column)))).getPreferredSize().height);
        slotTable.getColumnModel().getColumn(column).setPreferredWidth(new JButton((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"  \u0001"}, (Object)this.slotModel.getValueAt((int)1, (int)column)))).getPreferredSize().width);
    }

    void setColumnForBlankWhenZero(JTable slotTable, int column) {
        TableColumnModel tcm = slotTable.getColumnModel();
        NumberFormatRenderer renderer = new NumberFormatRenderer("####", true);
        tcm.getColumn(column).setCellRenderer(renderer);
    }

    void setColumnToHoldEStopButton(JTable slotTable, int column) {
        TableColumnModel tcm = slotTable.getColumnModel();
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        tcm.getColumn(column).setCellRenderer(buttonRenderer);
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        slotTable.setDefaultEditor(JButton.class, buttonEditor);
        slotTable.setRowHeight(new JButton((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"  \u0001"}, (Object)this.slotModel.getValueAt((int)1, (int)column)))).getPreferredSize().height);
        slotTable.getColumnModel().getColumn(column).setPreferredWidth(new JButton((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"  \u0001"}, (Object)this.slotModel.getValueAt((int)1, (int)column)))).getPreferredSize().width);
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.loconet.slotmon.SlotMonFrame";
    }

    @Override
    public String getTitle() {
        return this.getTitle(Bundle.getMessage("MenuItemSlotMonitor"));
    }

    @Override
    public void dispose() {
        this.slotModel.dispose();
        this.slotModel = null;
        this.slotTable = null;
        this.slotScroll = null;
        super.dispose();
    }

    private void filter() {
        RowFilter<SlotMonDataModel, Integer> rf = new RowFilter<SlotMonDataModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends SlotMonDataModel, ? extends Integer> entry) {
                boolean include;
                LocoNetSlot slot = entry.getModel().getSlot(entry.getIdentifier());
                boolean bl = include = entry.getModel().getSlot(entry.getIdentifier()).slotStatus() != 0 && slot.getSlotType() == SlotMapEntry.SlotType.LOCO;
                if (slot.getSlotType() == SlotMapEntry.SlotType.UNKNOWN) {
                    return false;
                }
                if (!include && SlotMonPane.this.showUnusedCheckBox.isSelected() && !slot.isSystemSlot()) {
                    include = true;
                }
                if (!include && SlotMonPane.this.showSystemCheckBox.isSelected() && slot.isSystemSlot()) {
                    include = true;
                }
                return include;
            }
        };
        this.sorter.setRowFilter(rf);
    }

    @Override
    public List<JMenu> getMenus() {
        ArrayList<JMenu> menuList = new ArrayList<JMenu>();
        menuList.add(this.getFileMenu());
        return menuList;
    }

    private JMenu getFileMenu() {
        JMenu fileMenu = new JMenu(Bundle.getMessage("MenuFile"));
        fileMenu.add(new JTableToCsvAction(Bundle.getMessage("ExportCsvAll"), null, this.slotModel, "Slot_Monitor_All.csv", new int[]{1}));
        fileMenu.add(new JTableToCsvAction(Bundle.getMessage("ExportCsvView"), this.slotTable, this.slotModel, "Slot_Monitor_View.csv", new int[]{1}));
        return fileMenu;
    }

    @Override
    public synchronized void notifyChangedSlot(LocoNetSlot s) {
        if (s.getSlot() == 250 && this.memo.getSlotManager().getSlot250CSSlots() > 0) {
            this.showHideSlot250Data(true);
            this.dcsSlots.setText(Integer.toString(this.memo.getSlotManager().getSlot250CSSlots()));
            this.dcsType.setText(this.memo.getSlotManager().getSlot248CommandStationType());
            if (this.topPanel.getMaximumSize().height > 0 && this.topPanel.getMaximumSize().width > 0) {
                this.topPanel.setMaximumSize(this.topPanel.getPreferredSize());
            }
            this.topPanel.revalidate();
        }
    }

    void showHideSlot250Data(boolean b) {
        this.dcsCSLabel.setVisible(b);
        this.dcsSlots.setVisible(b);
        this.dcsSlotsLabel.setVisible(b);
        this.dcsType.setVisible(b);
        if (this.topPanel.getMaximumSize().height > 0 && this.topPanel.getMaximumSize().width > 0) {
            this.topPanel.setMaximumSize(this.topPanel.getPreferredSize());
        }
        this.topPanel.revalidate();
    }

    private static class NumberFormatRenderer
    extends DefaultTableCellRenderer {
        private String pattern;
        private boolean suppressZero;

        public NumberFormatRenderer(String pattern, boolean suppressZero) {
            this.pattern = pattern;
            this.suppressZero = suppressZero;
            this.setHorizontalAlignment(4);
        }

        @Override
        public void setValue(Object value) {
            try {
                if (value != null && value instanceof Number) {
                    if (this.suppressZero && ((Number)value).doubleValue() == 0.0) {
                        value = "";
                    }
                    DecimalFormat formatter = new DecimalFormat(this.pattern);
                    value = formatter.format(value);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            super.setValue(value);
        }
    }
}

