/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.soundloader;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.soundloader.Bundle;
import jmri.jmrix.loconet.spjfile.SpjFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoaderEngine {
    static final int CMD_START = 4;
    static final int CMD_ADD = 8;
    static final int TYPE_SDF = 1;
    static final int TYPE_WAV = 0;
    static final int SENDPAGESIZE = 256;
    static final int SENDDATASIZE = 128;
    SpjFile spjFile;
    private boolean transferStart;
    private int transferType;
    private int transferHandle;
    private String transferName;
    private byte[] transferContents;
    private int transferIndex;
    LocoNetSystemConnectionMemo memo;
    LnTrafficController controller = null;
    private static final Logger log = LoggerFactory.getLogger(LoaderEngine.class);

    public LoaderEngine(LocoNetSystemConnectionMemo memo) {
        this.memo = memo;
    }

    public void runDownload(SpjFile file) {
        this.spjFile = file;
        this.initController();
        try {
            this.notify(Bundle.getMessage("EngineEraseFlash"));
            this.controller.sendLocoNetMessage(this.getEraseMessage());
            this.protectedWait(1000);
            this.notify(Bundle.getMessage("EngineEraseWait"));
            this.protectedWait(20000);
            this.notify(Bundle.getMessage("EngineSendInit"));
            this.controller.sendLocoNetMessage(this.getInitMessage());
            this.protectedWait(250);
            this.sendSDF();
            this.sendAllWAV();
            this.controller.sendLocoNetMessage(this.getExitMessage());
            this.notify(Bundle.getMessage("EngineDone"));
        }
        catch (DelayException e) {
            this.notify(Bundle.getMessage("EngineAbortDelay"));
        }
    }

    void sendSDF() throws DelayException {
        this.notify(Bundle.getMessage("EngineSendSdf"));
        SpjFile.Header header = this.spjFile.findSdfHeader();
        int handle = header.getHandle();
        String name = header.getName();
        byte[] contents = header.getByteArray();
        LocoNetMessage m = this.initTransfer(1, handle, name, contents);
        this.controller.sendLocoNetMessage(m);
        this.throttleOutbound(m);
        while ((m = this.nextTransfer()) != null) {
            this.controller.sendLocoNetMessage(m);
            this.throttleOutbound(m);
        }
    }

    void sendAllWAV() throws DelayException {
        this.notify(Bundle.getMessage("EngineSendWav"));
        for (int i = 1; i < this.spjFile.numHeaders(); ++i) {
            if (!this.spjFile.getHeader(i).isWAV()) continue;
            this.sendOneWav(i);
        }
    }

    public void sendOneWav(int index) throws DelayException {
        this.notify(Bundle.getMessage("EngineSendWavBlock", index));
        SpjFile.Header header = this.spjFile.getHeader(index);
        int handle = header.getHandle();
        String name = header.getName();
        byte[] buffer = header.getByteArray();
        int offset = header.getDataStart() - header.getRecordStart();
        int len = header.getDataLength();
        byte[] contents = new byte[len];
        for (int i = 0; i < len; ++i) {
            contents[i] = buffer[i + offset];
        }
        LocoNetMessage m = this.initTransfer(0, handle, name, contents);
        this.controller.sendLocoNetMessage(m);
        this.throttleOutbound(m);
        while ((m = this.nextTransfer()) != null) {
            this.controller.sendLocoNetMessage(m);
            this.throttleOutbound(m);
        }
    }

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="passing debug message String unchanged")
    public void notify(String message) {
        log.debug(message);
    }

    void throttleOutbound(LocoNetMessage m) throws DelayException {
        this.protectedWait(50);
        for (int i = 1; i < 100; ++i) {
            if (!this.controller.isXmtBusy()) {
                return;
            }
            this.protectedWait(10);
        }
        throw new DelayException("Ran out of time after sending " + m.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void protectedWait(int millis) {
        LoaderEngine loaderEngine = this;
        synchronized (loaderEngine) {
            try {
                this.wait(millis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    LocoNetMessage initTransfer(int type, int handle, String name, byte[] contents) {
        this.transferType = type;
        this.transferStart = true;
        this.transferHandle = handle;
        this.transferName = name;
        this.transferContents = contents;
        return this.getStartDataMessage(this.transferType, handle, contents.length);
    }

    public LocoNetMessage nextTransfer() {
        if (this.transferStart) {
            int i;
            this.transferStart = false;
            this.transferIndex = 0;
            byte[] header = new byte[40];
            header[0] = (byte)this.transferHandle;
            header[1] = (byte)(this.transferContents.length & 0xFF);
            header[2] = (byte)(this.transferContents.length / 256 & 0xFF);
            header[3] = (byte)(this.transferContents.length / 256 / 256 & 0xFF);
            header[4] = 0;
            header[5] = 0;
            header[6] = 0;
            header[7] = 0;
            for (i = 8; i < 40; ++i) {
                header[i] = 0;
            }
            if (this.transferName.length() > 32) {
                log.error("name {} is too long, truncated", (Object)this.transferName);
            }
            for (i = 0; i < Math.min(32, this.transferName.length()); ++i) {
                header[i + 8] = (byte)this.transferName.charAt(i);
            }
            return this.getSendDataMessage(this.transferType, this.transferHandle, header);
        }
        int remaining = this.transferContents.length - this.transferIndex;
        if (remaining < 0) {
            log.error("Did not expect to find length {} and index {}", (Object)this.transferContents.length, (Object)this.transferIndex);
        }
        if (remaining <= 0) {
            return null;
        }
        int sendSize = remaining;
        if (remaining > 128) {
            sendSize = 128;
        }
        byte[] buffer = new byte[sendSize];
        for (int i = 0; i < sendSize; ++i) {
            buffer[i] = this.transferContents[this.transferIndex + i];
        }
        this.transferIndex += sendSize;
        return this.getSendDataMessage(this.transferType, this.transferHandle, buffer);
    }

    LocoNetMessage getStartDataMessage(int type, int handle, int length) {
        int pagecount = length / 256;
        int remainder = length - pagecount * 256;
        if (remainder != 0) {
            ++pagecount;
        }
        if (log.isDebugEnabled()) {
            log.debug("getStartDataMessage: {},{},{};{},{}", new Object[]{type, handle, length, pagecount, remainder});
        }
        LocoNetMessage m = new LocoNetMessage(new int[]{211, type | 4, handle, pagecount & 0x7F, pagecount / 128, 0});
        m.setParity();
        return m;
    }

    LocoNetMessage getSendDataMessage(int type, int handle, byte[] contents) {
        int length = contents.length;
        LocoNetMessage m = new LocoNetMessage(length + 7);
        m.setElement(0, 211);
        m.setElement(1, type | 8);
        m.setElement(2, handle);
        m.setElement(3, length & 0x7F);
        m.setElement(4, length / 128);
        m.setElement(5, 0);
        for (int i = 0; i < length; ++i) {
            m.setElement(6 + i, contents[i]);
        }
        m.setParity();
        return m;
    }

    LocoNetMessage getEraseMessage() {
        LocoNetMessage m = new LocoNetMessage(new int[]{211, 2, 1, 127, 0, 80});
        m.setParity();
        return m;
    }

    LocoNetMessage getInitMessage() {
        LocoNetMessage m = new LocoNetMessage(new int[]{211, 1, 0, 0, 0, 45});
        m.setParity();
        return m;
    }

    LocoNetMessage getExitMessage() {
        LocoNetMessage m = new LocoNetMessage(new int[]{211, 0, 0, 0, 0, 44});
        m.setParity();
        return m;
    }

    void initController() {
        if (this.controller == null) {
            this.controller = this.memo.getLnTrafficController();
        }
    }

    public void dispose() {
    }

    static class DelayException
    extends Exception {
        DelayException(String s) {
            super(s);
        }
    }
}

