/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.streamport;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import jmri.jmrix.AbstractStreamPortController;
import jmri.jmrix.loconet.LnCommandStationType;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.streamport.Bundle;
import jmri.jmrix.loconet.streamport.LnStreamPortPacketizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnStreamPortController
extends AbstractStreamPortController {
    protected LnCommandStationType commandStationType = null;
    protected boolean mTurnoutNoRetry = false;
    protected boolean mTurnoutExtraSpace = false;
    protected boolean mInterrogateAtStart = false;
    private static final Logger log = LoggerFactory.getLogger(LnStreamPortController.class);

    public LnStreamPortController(LocoNetSystemConnectionMemo connectionMemo, DataInputStream in, DataOutputStream out, String pname) {
        super(connectionMemo, in, out, pname);
        this.setManufacturer("Digitrax");
    }

    public LnStreamPortController(DataInputStream in, DataOutputStream out, String pname) {
        super(new LocoNetSystemConnectionMemo(), in, out, pname);
        this.setManufacturer("Digitrax");
    }

    public LnStreamPortController() {
        super(new LocoNetSystemConnectionMemo());
        this.setManufacturer("Digitrax");
    }

    @Override
    public boolean status() {
        return true;
    }

    @Override
    public void configure() {
        this.setCommandStationType(LnCommandStationType.COMMAND_STATION_STANDALONE);
        this.setTurnoutHandling("");
        LnStreamPortPacketizer packets = new LnStreamPortPacketizer(this.getSystemConnectionMemo());
        packets.connectPort(this);
        this.getSystemConnectionMemo().setLnTrafficController(packets);
        this.getSystemConnectionMemo().configureCommandStation(this.commandStationType, this.mTurnoutNoRetry, this.mTurnoutExtraSpace, false, false, false);
        this.getSystemConnectionMemo().configureManagers();
        packets.startThreads();
    }

    public boolean okToSend() {
        return true;
    }

    public void setCommandStationType(LnCommandStationType value) {
        if (value == null) {
            return;
        }
        log.debug("setCommandStationType: {}", (Object)value);
        this.commandStationType = value;
    }

    public void setTurnoutHandling(String value) {
        if (value.equals("One Only") || value.equals(Bundle.getMessage("HandleOneOnly")) || value.equals("Both") || value.equals(Bundle.getMessage("HandleBoth"))) {
            this.mTurnoutNoRetry = true;
        }
        log.debug("turnout no retry: {}", (Object)this.mTurnoutNoRetry);
        if (value.equals("Spread") || value.equals(Bundle.getMessage("HandleSpread")) || value.equals("Both") || value.equals(Bundle.getMessage("HandleBoth"))) {
            this.mTurnoutExtraSpace = true;
        }
        log.debug("turnout extra space: {}", (Object)this.mTurnoutExtraSpace);
    }

    public void setInterrogateOnStart(String value) {
        this.mInterrogateAtStart = !value.equals("No") && !value.equals(Bundle.getMessage("ButtonNo"));
        log.debug("Interrogate at StartUp: {}", (Object)this.mInterrogateAtStart);
    }

    @Override
    public LocoNetSystemConnectionMemo getSystemConnectionMemo() {
        return (LocoNetSystemConnectionMemo)super.getSystemConnectionMemo();
    }
}

