/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.streamport;

import java.io.IOException;
import jmri.jmrix.loconet.LnPacketizer;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.streamport.LnStreamPortController;
import jmri.util.StringUtil;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnStreamPortPacketizer
extends LnPacketizer {
    public LnStreamPortController streamController = null;
    private static final Logger log = LoggerFactory.getLogger(LnStreamPortPacketizer.class);

    public LnStreamPortPacketizer(LocoNetSystemConnectionMemo m) {
        super(m);
    }

    @Override
    public boolean isXmtBusy() {
        return this.streamController != null;
    }

    public void connectPort(LnStreamPortController p) {
        this.istream = p.getInputStream();
        this.ostream = p.getOutputStream();
        if (this.controller != null) {
            log.warn("connectPort: connect called while connected");
        }
        this.streamController = p;
    }

    public void disconnectPort(LnStreamPortController p) {
        this.istream = null;
        this.ostream = null;
        if (this.streamController != p) {
            log.warn("disconnectPort: disconnect called from non-connected LnStreamPortController");
        }
        this.streamController = null;
    }

    @Override
    public void startThreads() {
        int xmtpriority;
        int priority = Thread.currentThread().getPriority();
        log.debug("startThreads current priority = {} max available = 10 default = 5 min available = 1", (Object)priority);
        int n = xmtpriority = 9 > priority ? 9 : 10;
        if (this.xmtHandler == null) {
            this.xmtHandler = new XmtHandler();
        }
        this.xmtThread = ThreadingUtil.newThread(this.xmtHandler, "LocoNet transmit handler");
        log.debug("Xmt thread starts at priority {}", (Object)xmtpriority);
        this.xmtThread.setDaemon(true);
        this.xmtThread.setPriority(9);
        this.xmtThread.start();
        if (this.rcvHandler == null) {
            this.rcvHandler = new LnPacketizer.RcvHandler(this);
        }
        this.rcvThread = ThreadingUtil.newThread(this.rcvHandler, "LocoNet receive handler");
        this.rcvThread.setDaemon(true);
        this.rcvThread.setPriority(10);
        this.rcvThread.start();
    }

    class XmtHandler
    implements Runnable {
        XmtHandler() {
        }

        @Override
        public void run() {
            while (!LnStreamPortPacketizer.this.threadStopRequest) {
                try {
                    log.trace("check for input");
                    byte[] msg = (byte[])LnStreamPortPacketizer.this.xmtList.take();
                    try {
                        if (LnStreamPortPacketizer.this.ostream != null) {
                            if (!LnStreamPortPacketizer.this.streamController.okToSend()) {
                                log.debug("LocoNet port not ready to receive");
                            }
                            if (log.isDebugEnabled()) {
                                log.debug("start write to stream: {}", (Object)StringUtil.hexStringFromBytes(msg));
                            }
                            LnStreamPortPacketizer.this.ostream.write(msg);
                            LnStreamPortPacketizer.this.ostream.flush();
                            if (log.isTraceEnabled()) {
                                log.trace("end write to stream: {}", (Object)StringUtil.hexStringFromBytes(msg));
                            }
                            LnStreamPortPacketizer.this.messageTransmitted(msg);
                            continue;
                        }
                        log.warn("sendLocoNetMessage: no connection established");
                    }
                    catch (IOException e) {
                        log.warn("sendLocoNetMessage: IOException: {}", (Object)e.toString());
                    }
                }
                catch (InterruptedException ie) {
                    return;
                }
            }
        }
    }
}

