/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.swing;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.MissingResourceException;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JSeparator;
import jmri.jmrix.loconet.LnCommandStationType;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.bdl16.BDL16Panel;
import jmri.jmrix.loconet.clockmon.ClockMonPane;
import jmri.jmrix.loconet.cmdstnconfig.CmdStnConfigPane;
import jmri.jmrix.loconet.downloader.LoaderPane;
import jmri.jmrix.loconet.ds64.Ds64TabbedPanel;
import jmri.jmrix.loconet.duplexgroup.swing.DuplexGroupTabbedPanel;
import jmri.jmrix.loconet.locogen.LocoGenPanel;
import jmri.jmrix.loconet.locoid.LocoIdPanel;
import jmri.jmrix.loconet.locomon.LocoMonPane;
import jmri.jmrix.loconet.loconetovertcp.LnTcpServerAction;
import jmri.jmrix.loconet.locostats.swing.LocoStatsPanel;
import jmri.jmrix.loconet.pm4.PM4Panel;
import jmri.jmrix.loconet.pr3.swing.Pr3SelectPane;
import jmri.jmrix.loconet.se8.SE8Panel;
import jmri.jmrix.loconet.slotmon.SlotMonPane;
import jmri.jmrix.loconet.soundloader.EditorPane;
import jmri.jmrix.loconet.swing.Bundle;
import jmri.jmrix.loconet.swing.LnNamedPaneAction;
import jmri.jmrix.loconet.swing.LocoNetMenuItem;
import jmri.jmrix.loconet.swing.lncvprog.LncvProgPane;
import jmri.jmrix.loconet.swing.lnsv1prog.Lnsv1ProgPane;
import jmri.jmrix.loconet.swing.menuitemspi.MenuItemsService;
import jmri.jmrix.loconet.swing.throttlemsg.MessagePanel;
import jmri.util.swing.WindowInterface;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoNetMenu
extends JMenu {
    private boolean lastWasSeparator;
    private static final Logger log = LoggerFactory.getLogger(LocoNetMenu.class);

    public LocoNetMenu(LocoNetSystemConnectionMemo memo) {
        ArrayList<LocoNetMenuItem> panelItems = new ArrayList<LocoNetMenuItem>();
        panelItems.add(new LocoNetMenuItem("MenuItemLocoNetMonitor", LocoMonPane.class, false, true));
        panelItems.add(new LocoNetMenuItem("MenuItemSlotMonitor", SlotMonPane.class, false, true));
        panelItems.add(new LocoNetMenuItem("MenuItemClockMon", ClockMonPane.class, true, true));
        panelItems.add(new LocoNetMenuItem("MenuItemLocoStats", LocoStatsPanel.class, false, true));
        panelItems.add(null);
        panelItems.add(new LocoNetMenuItem("MenuItemBDL16Programmer", BDL16Panel.class, true, true));
        panelItems.add(new LocoNetMenuItem("MenuItemPM4Programmer", PM4Panel.class, true, true));
        panelItems.add(new LocoNetMenuItem("MenuItemSE8cProgrammer", SE8Panel.class, true, true));
        panelItems.add(new LocoNetMenuItem("MenuItemDS64Programmer", Ds64TabbedPanel.class, true, true));
        panelItems.add(new LocoNetMenuItem("MenuItemCmdStnConfig", CmdStnConfigPane.class, true, true));
        panelItems.add(new LocoNetMenuItem("MenuItemSetID", LocoIdPanel.class, true, true));
        panelItems.add(new LocoNetMenuItem("MenuItemDuplex", DuplexGroupTabbedPanel.class, true, true));
        panelItems.add(null);
        panelItems.add(new LocoNetMenuItem("MenuItemLnsv1Prog", Lnsv1ProgPane.class, true, true));
        panelItems.add(new LocoNetMenuItem("MenuItemLncvProg", LncvProgPane.class, true, true));
        panelItems.add(null);
        panelItems.add(new LocoNetMenuItem("MenuItemThrottleMessages", MessagePanel.class, true, true));
        panelItems.add(new LocoNetMenuItem("MenuItemSendPacket", LocoGenPanel.class, false, true));
        panelItems.add(new LocoNetMenuItem("MenuItemPr3ModeSelect", Pr3SelectPane.class, false, true));
        panelItems.add(null);
        panelItems.add(new LocoNetMenuItem("MenuItemDownload", LoaderPane.class, false, true));
        panelItems.add(new LocoNetMenuItem("MenuItemSoundload", jmri.jmrix.loconet.soundloader.LoaderPane.class, false, true));
        panelItems.add(new LocoNetMenuItem("MenuItemSoundEditor", EditorPane.class, false, true));
        panelItems.add(null);
        panelItems.add(new LocoNetMenuItem("MenuItemLocoNetOverTCPServer", LnTcpServerAction.class, false, false));
        LnCommandStationType cmdStation = null;
        if (memo != null) {
            this.setText(memo.getUserName());
            cmdStation = memo.getSlotManager().getCommandStationType();
        } else {
            this.setText(Bundle.getMessage("MenuLocoNet"));
        }
        JmriJFrameInterface wi = new JmriJFrameInterface();
        boolean isLocoNetInterface = cmdStation == null || !cmdStation.equals((Object)LnCommandStationType.COMMAND_STATION_PR2_ALONE) && !cmdStation.equals((Object)LnCommandStationType.COMMAND_STATION_PR3_ALONE) && !cmdStation.equals((Object)LnCommandStationType.COMMAND_STATION_PR4_ALONE) && !cmdStation.equals((Object)LnCommandStationType.COMMAND_STATION_USB_DCS240_ALONE) && !cmdStation.equals((Object)LnCommandStationType.COMMAND_STATION_USB_DCS52_ALONE);
        LocoNetMenu hostMenu = this;
        this.lastWasSeparator = true;
        this.processItems(hostMenu, panelItems, isLocoNetInterface, wi, memo);
        this.lastWasSeparator = false;
        this.add(hostMenu);
        panelItems.clear();
        ArrayList<JMenu> extensionMenus = this.getExtensionMenuItems(isLocoNetInterface, wi, memo);
        log.trace("number of extension items is {}.", (Object)panelItems.size());
        while (!extensionMenus.isEmpty() && extensionMenus.get(extensionMenus.size() - 1) == null) {
            extensionMenus.remove(panelItems.size() - 1);
        }
        if (!extensionMenus.isEmpty()) {
            this.add(new JSeparator());
            log.debug("number of items {}", (Object)panelItems.size());
            while (!extensionMenus.isEmpty()) {
                JMenu menu = extensionMenus.get(0);
                this.add(menu);
                log.trace("Added extension menu {}", (Object)menu.getName());
                extensionMenus.remove(0);
            }
        }
    }

    public Action processExternalItem(LocoNetMenuItem item, boolean isLocoNetInterface, WindowInterface wi, LocoNetSystemConnectionMemo memo) {
        if (item == null) {
            return null;
        }
        if (item.hasGui()) {
            if (isLocoNetInterface || !item.isInterfaceOnly()) {
                log.trace("created GUI menu item {}.", (Object)item.getName());
                return this.createGuiAction(item, wi, memo);
            }
            log.trace("not displaying item {} ({}) account requires interface which is not present in current configuration.", (Object)item.getName(), (Object)item.getClassToLoad().getCanonicalName());
            return null;
        }
        log.trace("created non-GUI menu item {}.", (Object)item.getName());
        return this.createNonGuiAction(item);
    }

    public Action createGuiAction(LocoNetMenuItem item, WindowInterface wi, LocoNetSystemConnectionMemo memo) {
        String translatedMenuItemName;
        try {
            translatedMenuItemName = Bundle.getMessage(item.getName());
        }
        catch (MissingResourceException e) {
            translatedMenuItemName = item.getName();
        }
        return new LnNamedPaneAction(translatedMenuItemName, wi, item.getClassToLoad().getCanonicalName(), memo);
    }

    public Action createNonGuiAction(LocoNetMenuItem item) {
        Action menuItem = null;
        try {
            menuItem = (Action)item.getClassToLoad().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            menuItem.putValue("NAME", item.getName());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            log.warn("could not load menu item {} ({})", new Object[]{item.getName(), item.getClassToLoad().getCanonicalName(), ex});
        }
        return menuItem;
    }

    public final ArrayList<JMenu> getExtensionMenuItems(boolean isConnectionWithHardwareInterface, WindowInterface wi, LocoNetSystemConnectionMemo memo) {
        ArrayList<JMenu> locoNetMenuItems = new ArrayList<JMenu>();
        log.trace("searching for extensions for the canonical name {}", (Object)this.getClass().getCanonicalName());
        MenuItemsService lnMenuItemServiceInstance = MenuItemsService.getInstance();
        locoNetMenuItems.addAll(lnMenuItemServiceInstance.getMenuExtensionsItems(isConnectionWithHardwareInterface, wi, memo));
        log.trace("LocoNetItems size is {}", (Object)locoNetMenuItems.size());
        return locoNetMenuItems;
    }

    private void processItems(JMenu menu, ArrayList<LocoNetMenuItem> items, boolean isLocoNetInterface, WindowInterface wi, LocoNetSystemConnectionMemo memo) {
        items.forEach(item -> this.processAnItem(menu, (LocoNetMenuItem)item, isLocoNetInterface, wi, memo));
    }

    private void processAnItem(JMenu menu, LocoNetMenuItem item, boolean isLocoNetInterface, WindowInterface wi, LocoNetSystemConnectionMemo memo) {
        if (item == null) {
            if (!this.lastWasSeparator) {
                menu.add(new JSeparator());
                log.trace("Added new JSeparator");
                this.lastWasSeparator = true;
            }
        } else if (item.hasGui()) {
            if (isLocoNetInterface || !item.isInterfaceOnly()) {
                this.addGuiItem(menu, item, wi, memo);
                log.trace("added GUI item {}", (Object)item.getName());
            } else {
                log.trace("not displaying item {} ({}) account requires interface which is not present in current configuration.", (Object)item.getName(), (Object)item.getClassToLoad().getCanonicalName());
            }
        } else {
            this.addNonGuiItem(menu, item);
            log.trace("added non-GUI item {}", (Object)item.getName());
        }
    }

    private void addNonGuiItem(JMenu menu, LocoNetMenuItem item) {
        if (item != null) {
            Action menuItem = this.createNonGuiAction(item);
            menu.add(menuItem);
            log.debug("Adding (non-gui) item {} ({})", (Object)item.getName(), item.getClassToLoad());
            this.lastWasSeparator = false;
        } else {
            menu.add(new JSeparator());
            this.lastWasSeparator = true;
            log.trace("adding a JSeparator account null item");
        }
    }

    private void addGuiItem(JMenu menu, LocoNetMenuItem item, WindowInterface wi, LocoNetSystemConnectionMemo memo) {
        Action a = this.createGuiAction(item, wi, memo);
        menu.add(a);
        this.lastWasSeparator = false;
        log.debug("Added new GUI-based item for {} ({}).", (Object)item.getName(), (Object)item.getClassToLoad().getCanonicalName());
    }
}

