/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.swing.lncvprog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableRowSorter;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrix.loconet.LncvDevicesManager;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.swing.LnPanel;
import jmri.jmrix.loconet.swing.lncvprog.Bundle;
import jmri.jmrix.loconet.swing.lncvprog.LncvProgTableModel;
import jmri.jmrix.loconet.uhlenbrock.LncvDevice;
import jmri.jmrix.loconet.uhlenbrock.LncvMessageContents;
import jmri.swing.JTablePersistenceManager;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LncvProgPane
extends LnPanel
implements LocoNetListener {
    private LocoNetSystemConnectionMemo memo;
    protected JToggleButton allProgButton = new JToggleButton();
    protected JToggleButton modProgButton = new JToggleButton();
    protected JButton readButton = new JButton(Bundle.getMessage("ButtonRead"));
    protected JButton writeButton = new JButton(Bundle.getMessage("ButtonWrite"));
    protected JTextField articleField = new JTextField(4);
    protected JTextField addressField = new JTextField(4);
    protected JTextField cvField = new JTextField(4);
    protected JTextField valueField = new JTextField(4);
    protected JCheckBox directCheckBox = new JCheckBox(Bundle.getMessage("DirectModeBox"));
    protected JCheckBox rawCheckBox = new JCheckBox(Bundle.getMessage("ButtonShowRaw"));
    protected JTable moduleTable = null;
    protected LncvProgTableModel moduleTableModel = null;
    public static final int ROW_HEIGHT = new JButton((String)"X").getPreferredSize().height * 9 / 10;
    protected JPanel tablePanel = null;
    protected JLabel statusText1 = new JLabel();
    protected JLabel statusText2 = new JLabel();
    protected JLabel articleFieldLabel = new JLabel(Bundle.getMessage("LabelArticleNum", 4));
    protected JLabel addressFieldLabel = new JLabel(Bundle.getMessage("LabelModuleAddress", 4));
    protected JLabel cvFieldLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("HeadingCv")), 4);
    protected JLabel valueFieldLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("HeadingValue")), 4);
    protected JTextArea result = new JTextArea(6, 50);
    protected String reply = "";
    protected int art;
    protected int adr = 1;
    protected int cv = 0;
    protected int val;
    boolean writeConfirmed = false;
    private final String rawDataCheck = this.getClass().getName() + ".RawData";
    private final String dontWarnOnClose = this.getClass().getName() + ".DontWarnOnClose";
    private UserPreferencesManager pm;
    private transient TableRowSorter<LncvProgTableModel> sorter;
    private LncvDevicesManager lncvdm;
    private boolean allProgRunning = false;
    private int moduleProgRunning = -1;
    private JPanel ledPanel;
    private static final Logger log = LoggerFactory.getLogger(LncvProgPane.class);

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.loconet.swing.lncvprog.LncvProgPane";
    }

    @Override
    public String getTitle() {
        return Bundle.getMessage("MenuItemLncvProg");
    }

    @Override
    public void initComponents() {
        this.setLayout(new BoxLayout(this, 3));
        this.add(this.initButtonPanel());
        this.add(this.initDirectPanel());
        this.add(this.initStatusPanel());
        this.addHierarchyListener(e -> {
            JmriJFrame toolFrame;
            Component comp;
            if ((e.getChangeFlags() & 4L) != 0L && (comp = e.getChanged()) instanceof JmriJFrame && Objects.equals((toolFrame = (JmriJFrame)comp).getTitle(), this.getTitle()) && !toolFrame.isVisible()) {
                this.handleCloseEvent();
                log.debug("Component hidden: {}", (Object)comp);
            }
        });
    }

    @Override
    public synchronized void initComponents(LocoNetSystemConnectionMemo memo) {
        super.initComponents(memo);
        this.memo = memo;
        this.lncvdm = memo.getLncvDevicesManager();
        this.pm = InstanceManager.getDefault(UserPreferencesManager.class);
        if (memo.getLnTrafficController() == null) {
            log.error("No traffic controller is available");
        } else {
            memo.getLnTrafficController().addLocoNetListener(-1, this);
        }
        this.moduleTableModel = new LncvProgTableModel(this, memo);
        this.moduleTable = new JTable(this.moduleTableModel);
        this.moduleTable.setRowSelectionAllowed(false);
        this.moduleTable.setPreferredScrollableViewportSize(new Dimension(300, 200));
        this.moduleTable.setRowHeight(ROW_HEIGHT);
        this.moduleTable.setDefaultEditor(JButton.class, new ButtonEditor(new JButton()));
        this.moduleTable.setDefaultRenderer(JButton.class, new ButtonRenderer());
        this.moduleTable.setRowSelectionAllowed(true);
        this.moduleTable.getSelectionModel().addListSelectionListener(event -> {
            LncvProgPane lncvProgPane = this;
            synchronized (lncvProgPane) {
                if (this.moduleTable.getSelectedRow() > -1 && this.moduleTable.getSelectedRow() < this.moduleTable.getRowCount()) {
                    this.copyEntry((Integer)this.moduleTable.getValueAt(this.moduleTable.getSelectedRow(), 1), (Integer)this.moduleTable.getValueAt(this.moduleTable.getSelectedRow(), 2));
                }
            }
        });
        this.sorter = new TableRowSorter<LncvProgTableModel>(this.moduleTableModel);
        this.moduleTable.setRowSorter(this.sorter);
        this.moduleTable.setName("LNCV Device Management");
        InstanceManager.getOptionalDefault(JTablePersistenceManager.class).ifPresent(tpm -> {
            LncvProgPane lncvProgPane = this;
            synchronized (lncvProgPane) {
                tpm.resetState(this.moduleTable);
                tpm.persist(this.moduleTable, true);
            }
        });
        JScrollPane tableScrollPane = new JScrollPane(this.moduleTable);
        this.tablePanel = new JPanel();
        Border resultBorder = BorderFactory.createEtchedBorder();
        TitledBorder resultTitled = BorderFactory.createTitledBorder(resultBorder, Bundle.getMessage("LncvTableTitle"));
        this.tablePanel.setBorder(resultTitled);
        this.tablePanel.setLayout(new BoxLayout(this.tablePanel, 1));
        this.tablePanel.add((Component)tableScrollPane, "Center");
        JSplitPane splitPane = new JSplitPane(0, this.tablePanel, this.getMonitorPanel());
        splitPane.setOneTouchExpandable(true);
        splitPane.setAlignmentX(0.5f);
        splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.add(splitPane);
        this.rawCheckBox.setSelected(this.pm.getSimplePreferenceState(this.rawDataCheck));
    }

    protected JPanel getMonitorPanel() {
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 1));
        JPanel panel31 = new JPanel();
        panel31.setLayout(new BoxLayout(panel31, 1));
        JScrollPane resultScrollPane = new JScrollPane(this.result);
        panel31.add(resultScrollPane);
        panel31.add(this.rawCheckBox);
        this.rawCheckBox.setVisible(true);
        this.rawCheckBox.setToolTipText(Bundle.getMessage("TooltipShowRaw"));
        panel3.add(panel31);
        Border panel3Border = BorderFactory.createEtchedBorder();
        TitledBorder panel3Titled = BorderFactory.createTitledBorder(panel3Border, Bundle.getMessage("LncvMonitorTitle"));
        panel3.setBorder(panel3Titled);
        return panel3;
    }

    protected JPanel initButtonPanel() {
        JPanel panel4 = new JPanel();
        panel4.setLayout(new BoxLayout(panel4, 0));
        panel4.add(Box.createHorizontalGlue());
        JPanel panel41 = new JPanel();
        panel41.setLayout(new BoxLayout(panel41, 3));
        this.allProgButton.setText(this.allProgRunning ? Bundle.getMessage("ButtonStopAllProg") : Bundle.getMessage("ButtonStartAllProg"));
        this.allProgButton.setToolTipText(Bundle.getMessage("TipAllProgButton"));
        this.allProgButton.addActionListener(e -> this.allProgButtonActionPerformed());
        panel41.add(this.allProgButton);
        this.modProgButton.setText(this.moduleProgRunning >= 0 ? Bundle.getMessage("ButtonStopModProg") : Bundle.getMessage("ButtonStartModProg"));
        this.modProgButton.setToolTipText(Bundle.getMessage("TipModuleProgButton"));
        this.modProgButton.addActionListener(e -> this.modProgButtonActionPerformed());
        panel41.add(this.modProgButton);
        panel4.add(panel41);
        JPanel panel42 = new JPanel();
        panel42.setLayout(new BoxLayout(panel42, 3));
        JPanel panel421 = new JPanel();
        panel421.add(this.articleFieldLabel);
        this.articleField.setToolTipText(Bundle.getMessage("TipModuleArticleField"));
        panel421.add(this.articleField);
        panel42.add(panel421);
        JPanel panel422 = new JPanel();
        panel422.add(this.addressFieldLabel);
        this.addressField.setText("1");
        panel422.add(this.addressField);
        panel42.add(panel422);
        panel42.add(this.directCheckBox);
        this.directCheckBox.addActionListener(e -> this.directActionPerformed());
        this.directCheckBox.setToolTipText(Bundle.getMessage("TipDirectMode"));
        panel4.add(panel42);
        JPanel panel43 = new JPanel();
        Border panel43Border = BorderFactory.createEtchedBorder();
        panel43.setBorder(panel43Border);
        panel43.setLayout(new BoxLayout(panel43, 2));
        JPanel panel431 = new JPanel();
        panel431.setLayout(new BoxLayout(panel431, 3));
        this.cvFieldLabel.setAlignmentX(1.0f);
        this.cvFieldLabel.setMinimumSize(new Dimension(60, new JTextField("X").getHeight() + 5));
        panel431.add(this.cvFieldLabel);
        this.valueFieldLabel.setMinimumSize(new Dimension(60, new JTextField("X").getHeight() + 5));
        this.valueFieldLabel.setAlignmentX(1.0f);
        panel431.add(this.valueFieldLabel);
        panel43.add(panel431);
        JPanel panel432 = new JPanel();
        panel432.setMaximumSize(new Dimension(50, 50));
        panel432.setPreferredSize(new Dimension(50, 50));
        panel432.setMinimumSize(new Dimension(50, 50));
        panel432.setLayout(new BoxLayout(panel432, 3));
        this.cvField.setText("0");
        panel432.add(this.cvField);
        this.valueField.setText("1");
        panel432.add(this.valueField);
        panel43.add(panel432);
        JPanel panel433 = new JPanel();
        panel433.setLayout(new BoxLayout(panel433, 3));
        panel433.add(this.readButton);
        this.readButton.setEnabled(false);
        this.readButton.addActionListener(e -> this.readButtonActionPerformed());
        panel433.add(this.writeButton);
        this.writeButton.setEnabled(false);
        this.writeButton.addActionListener(e -> this.writeButtonActionPerformed());
        panel43.add(panel433);
        panel4.add(panel43);
        panel4.add(Box.createHorizontalGlue());
        panel4.setAlignmentX(0.5f);
        return panel4;
    }

    protected JPanel initStatusPanel() {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 3));
        this.statusText1.setText("   ");
        this.statusText1.setHorizontalAlignment(0);
        panel2.add(this.statusText1);
        this.statusText2.setText("   ");
        this.statusText2.setHorizontalAlignment(0);
        panel2.add(this.statusText2);
        panel2.setAlignmentX(0.5f);
        return panel2;
    }

    public void allProgButtonActionPerformed() {
        if (this.moduleProgRunning >= 0) {
            this.statusText1.setText(Bundle.getMessage("FeedBackModProgRunning"));
            return;
        }
        if (this.directCheckBox.isSelected()) {
            this.statusText1.setText(Bundle.getMessage("FeedBackDirectRunning"));
            return;
        }
        this.readButton.setEnabled(!this.allProgRunning);
        this.writeButton.setEnabled(!this.allProgRunning);
        log.debug("AllProg pressed, allProgRunning={}", (Object)this.allProgRunning);
        if (this.allProgRunning) {
            log.debug("Session was running, closing");
            this.memo.getLnTrafficController().sendLocoNetMessage(LncvMessageContents.createAllProgEndRequest(this.art));
            this.statusText1.setText(Bundle.getMessage("FeedBackStopAllProg"));
            this.allProgButton.setText(Bundle.getMessage("ButtonStartAllProg"));
            this.articleField.setEditable(true);
            this.addressField.setEditable(true);
            this.allProgRunning = false;
            return;
        }
        this.articleField.setEditable(false);
        this.addressField.setEditable(false);
        this.art = -1;
        if (!this.articleField.getText().isEmpty()) {
            try {
                this.art = this.inDomain(this.articleField.getText(), 9999);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Object[] dialogBoxButtonOptions = new Object[]{Bundle.getMessage("ButtonProceed"), Bundle.getMessage("ButtonCancel")};
        int userReply = JmriJOptionPane.showOptionDialog(this.getParent(), Bundle.getMessage("DialogAllWarning"), Bundle.getMessage("WarningTitle"), -1, 3, null, dialogBoxButtonOptions, dialogBoxButtonOptions[1]);
        if (userReply != 0) {
            return;
        }
        this.statusText1.setText(Bundle.getMessage("FeedBackStartAllProg"));
        LocoNetMessage m = LncvMessageContents.createAllProgStartRequest(this.art);
        this.memo.getLnTrafficController().sendLocoNetMessage(m);
        this.statusText1.setText(Bundle.getMessage("FeedBackStartAllProg"));
        this.allProgButton.setText(Bundle.getMessage("ButtonStopAllProg"));
        this.allProgRunning = true;
        log.debug("AllProgRunning=TRUE, allProgButtonActionPerformed ready");
    }

    public void modProgButtonActionPerformed() {
        if (this.allProgRunning) {
            this.statusText1.setText(Bundle.getMessage("FeedBackAllProgRunning"));
            return;
        }
        if (this.directCheckBox.isSelected()) {
            this.statusText1.setText(Bundle.getMessage("FeedBackDirectRunning"));
            return;
        }
        if (this.articleField.getText().isEmpty()) {
            this.statusText1.setText(Bundle.getMessage("FeedBackEnterArticle"));
            this.articleField.setBackground(Color.RED);
            this.modProgButton.setSelected(false);
            return;
        }
        if (this.addressField.getText().isEmpty()) {
            this.statusText1.setText(Bundle.getMessage("FeedBackEnterAddress"));
            this.addressField.setBackground(Color.RED);
            this.modProgButton.setSelected(false);
            return;
        }
        this.articleField.setBackground(Color.WHITE);
        this.readButton.setEnabled(this.moduleProgRunning < 0);
        this.writeButton.setEnabled(this.moduleProgRunning < 0);
        if (this.moduleProgRunning >= 0) {
            try {
                this.art = this.inDomain(this.articleField.getText(), 9999);
                this.adr = this.moduleProgRunning;
                this.memo.getLnTrafficController().sendLocoNetMessage(LncvMessageContents.createModProgEndRequest(this.art, this.adr));
                this.statusText1.setText(Bundle.getMessage("FeedBackModProgClosed", this.adr));
                this.modProgButton.setText(Bundle.getMessage("ButtonStartModProg"));
                this.moduleProgRunning = -1;
                this.articleField.setEditable(true);
                this.addressField.setEditable(true);
            }
            catch (NumberFormatException e) {
                this.statusText1.setText(Bundle.getMessage("FeedBackEnterArticle"));
                this.modProgButton.setSelected(true);
            }
            return;
        }
        if (!this.articleField.getText().isEmpty() && !this.addressField.getText().isEmpty()) {
            try {
                this.art = this.inDomain(this.articleField.getText(), 9999);
                this.adr = this.inDomain(this.addressField.getText(), 65535);
                this.memo.getLnTrafficController().sendLocoNetMessage(LncvMessageContents.createModProgStartRequest(this.art, this.adr));
                this.statusText1.setText(Bundle.getMessage("FeedBackModProgOpen", this.adr));
                this.modProgButton.setText(Bundle.getMessage("ButtonStopModProg"));
                this.moduleProgRunning = this.adr;
                this.articleField.setEditable(false);
                this.addressField.setEditable(false);
            }
            catch (NumberFormatException e) {
                log.error("invalid entry, must be number");
            }
        }
    }

    public void readButtonActionPerformed() {
        String sArt = "65535";
        if (this.moduleProgRunning >= 0) {
            sArt = this.articleField.getText();
            this.articleField.setBackground(Color.WHITE);
        }
        if (sArt != null && this.addressField.getText() != null && this.cvField.getText() != null) {
            try {
                this.art = this.inDomain(sArt, 9999);
                this.adr = this.inDomain(this.addressField.getText(), 65535);
                this.cv = this.inDomain(this.cvField.getText(), 9999);
                this.memo.getLnTrafficController().sendLocoNetMessage(LncvMessageContents.createCvReadRequest(this.art, this.adr, this.cv));
            }
            catch (NumberFormatException e) {
                log.error("invalid entry, must be number");
            }
        } else {
            this.statusText1.setText(Bundle.getMessage("FeedBackEnterArticle"));
            this.articleField.setBackground(Color.RED);
            return;
        }
        this.statusText1.setText(Bundle.getMessage("FeedBackRead", "LNCV"));
    }

    public void writeButtonActionPerformed() {
        String sArt = "65535";
        if (this.moduleProgRunning >= 0) {
            sArt = this.articleField.getText();
        }
        if (sArt != null && this.cvField.getText() != null && this.valueField.getText() != null) {
            this.articleField.setBackground(Color.WHITE);
            try {
                this.art = this.inDomain(sArt, 9999);
                this.cv = this.inDomain(this.cvField.getText(), 9999);
                this.val = this.inDomain(this.valueField.getText(), 65535);
                if (this.cv == 0 && (this.val > 65534 || this.val < 1)) {
                    this.statusText1.setText(Bundle.getMessage("FeedBackValidAddressRange"));
                    this.valueField.setBackground(Color.RED);
                    return;
                }
                this.writeConfirmed = false;
                this.memo.getLnTrafficController().sendLocoNetMessage(LncvMessageContents.createCvWriteRequest(this.art, this.cv, this.val));
                this.valueField.setBackground(Color.ORANGE);
            }
            catch (NumberFormatException e) {
                log.error("invalid entry, must be number");
            }
        } else {
            this.statusText1.setText(Bundle.getMessage("FeedBackEnterArticle"));
            this.articleField.setBackground(Color.RED);
            return;
        }
        this.statusText1.setText(Bundle.getMessage("FeedBackWrite", "LNCV"));
    }

    private JPanel initDirectPanel() {
        this.ledPanel = new JPanel();
        for (int i = 0; i < 16; ++i) {
            JCheckBox ledBox = new JCheckBox("" + i);
            this.ledPanel.add(ledBox);
        }
        JPanel options = new JPanel();
        options.setLayout(new BoxLayout(options, 1));
        JToggleButton buttonAll = new JToggleButton(Bundle.getMessage("AllOn"));
        buttonAll.addActionListener(e -> this.toggleAll(buttonAll.isSelected()));
        options.add(buttonAll);
        JCheckBox serieTwo = new JCheckBox("LED2");
        serieTwo.addActionListener(e -> this.renumber(serieTwo.isSelected()));
        options.add(serieTwo);
        this.ledPanel.add(options);
        JButton buttonSet = new JButton(Bundle.getMessage("ButtonSetDirect"));
        this.ledPanel.add(buttonSet);
        buttonSet.addActionListener(e -> this.setDirect(serieTwo.isSelected()));
        this.ledPanel.setVisible(false);
        return this.ledPanel;
    }

    private void toggleAll(boolean on) {
        for (int j = 0; j < 16; ++j) {
            ((JCheckBox)this.ledPanel.getComponent(j)).setSelected(on);
        }
    }

    protected void directActionPerformed() {
        if (this.allProgRunning || this.moduleProgRunning > -1) {
            this.directCheckBox.setSelected(false);
            return;
        }
        if (this.directCheckBox.isSelected()) {
            this.articleField.setEditable(false);
            this.articleField.setText("6900");
            this.articleField.setBackground(Color.WHITE);
            this.readButton.setEnabled(false);
            this.ledPanel.setVisible(true);
        } else {
            this.articleField.setText("");
            this.articleField.setEditable(true);
            this.readButton.setEnabled(true);
            this.ledPanel.setVisible(false);
        }
    }

    protected void renumber(boolean range2) {
        for (int j = 0; j < 16; ++j) {
            ((JCheckBox)this.ledPanel.getComponent(j)).setText(range2 ? "" + (j + 16) : "" + j);
        }
    }

    protected void setDirect(boolean range2) {
        if (this.addressField.getText() != null) {
            try {
                this.adr = this.inDomain(this.addressField.getText(), 65535);
                int cv = 0;
                for (int j = 0; j < 16; ++j) {
                    cv += ((JCheckBox)this.ledPanel.getComponent(j)).isSelected() ? 1 << j : 0;
                }
                this.memo.getLnTrafficController().sendLocoNetMessage(LncvMessageContents.createDirectWriteRequest(this.adr, cv, range2));
            }
            catch (NumberFormatException e) {
                log.error("invalid entry, must be number");
            }
        } else {
            this.statusText1.setText(Bundle.getMessage("FeedBackEnterArticle"));
            this.addressField.setBackground(Color.RED);
            return;
        }
        this.statusText1.setText(Bundle.getMessage("FeedBackSetDirect"));
    }

    private int inDomain(String entry, int max) {
        int n = -1;
        try {
            n = Integer.parseInt(entry);
        }
        catch (NumberFormatException e) {
            log.error("invalid entry, must be number");
        }
        if (0 <= n && n <= max) {
            return n;
        }
        this.statusText1.setText(Bundle.getMessage("FeedBackInputOutsideRange"));
        return 0;
    }

    public void copyEntry(int art, int mod) {
        if (this.moduleProgRunning < 0 && !this.allProgRunning) {
            this.articleField.setText("" + art);
            this.addressField.setText("" + mod);
        }
    }

    @Override
    public synchronized void message(LocoNetMessage m) {
        if (LncvMessageContents.isSupportedLncvMessage(m)) {
            Object raw = this.rawCheckBox.isSelected() ? "[" + m + "] " : "";
            String formatted = m.toMonitorString(this.memo.getSystemPrefix());
            this.reply = this.reply + (String)raw + formatted;
        }
        if (m.getOpCode() == 180 && m.getElement(1) == 109) {
            this.writeConfirmed = true;
            if (m.getElement(2) == 127) {
                this.valueField.setBackground(Color.GREEN);
                this.reply = this.reply + Bundle.getMessage("LNCV_WRITE_CONFIRMED", this.moduleProgRunning) + "\n";
            } else if (m.getElement(2) == 1) {
                this.valueField.setBackground(Color.RED);
                this.reply = this.reply + Bundle.getMessage("LNCV_WRITE_CV_NOTSUPPORTED", this.moduleProgRunning, this.cv) + "\n";
            } else if (m.getElement(2) == 2) {
                this.valueField.setBackground(Color.RED);
                this.reply = this.reply + Bundle.getMessage("LNCV_WRITE_CV_READONLY", this.moduleProgRunning, this.cv) + "\n";
            } else if (m.getElement(2) == 3) {
                this.valueField.setBackground(Color.RED);
                this.reply = this.reply + Bundle.getMessage("LNCV_WRITE_CV_OUTOFBOUNDS", this.moduleProgRunning, this.val) + "\n";
            }
        }
        if (LncvMessageContents.extractMessageType(m) == LncvMessageContents.LncvCommand.LNCV_WRITE) {
            this.reply = this.reply + Bundle.getMessage("LNCV_WRITE_MOD_MONITOR", this.moduleProgRunning == -1 ? "ALL" : Integer.valueOf(this.moduleProgRunning)) + "\n";
        }
        if (LncvMessageContents.extractMessageType(m) == LncvMessageContents.LncvCommand.LNCV_READ) {
            this.reply = this.reply + Bundle.getMessage("LNCV_READ_MOD_MONITOR", this.moduleProgRunning == -1 ? "ALL" : Integer.valueOf(this.moduleProgRunning)) + "\n";
        }
        if (LncvMessageContents.extractMessageType(m) == LncvMessageContents.LncvCommand.LNCV_READ_REPLY || LncvMessageContents.extractMessageType(m) == LncvMessageContents.LncvCommand.LNCV_READ_REPLY2) {
            LncvMessageContents contents = new LncvMessageContents(m);
            int msgArt = contents.getLncvArticleNum();
            int msgAdr = this.moduleProgRunning;
            int msgCv = contents.getCvNum();
            int msgVal = contents.getCvValue();
            if (msgCv == 0 || msgArt == this.art) {
                msgAdr = msgVal;
            }
            String foundMod = "(LNCV) " + Bundle.getMessage("LabelArticle") + this.art + " " + Bundle.getMessage("LabelAddress") + msgAdr + " " + Bundle.getMessage("LabelCv") + msgCv + " " + Bundle.getMessage("LabelValue") + msgVal + "\n";
            this.reply = this.reply + foundMod;
            log.debug("ReadReply={}", (Object)this.reply);
            this.cvField.setText("" + msgCv);
            this.cvField.setBackground(Color.WHITE);
            this.valueField.setText("" + msgVal);
            this.valueField.setBackground(Color.WHITE);
            LncvDevice dev = this.memo.getLncvDevicesManager().getDevice(this.art, this.adr);
            if (dev != null) {
                dev.setCvNum(msgCv);
                dev.setCvValue(msgVal);
            }
            this.memo.getLncvDevicesManager().firePropertyChange("DeviceListChanged", true, false);
        }
        if (this.reply != null) {
            this.allProgFinished(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allProgFinished(String error) {
        if (error != null) {
            log.error("LNCV process finished with error: {}", (Object)error);
            this.statusText2.setText(Bundle.getMessage("FeedBackDiscoverFail"));
        } else {
            LncvProgPane lncvProgPane = this;
            synchronized (lncvProgPane) {
                if (this.lncvdm.getDeviceCount() == 1) {
                    this.statusText2.setText(Bundle.getMessage("FeedBackDiscoverSuccessOne"));
                } else {
                    this.statusText2.setText(Bundle.getMessage("FeedBackDiscoverSuccess", this.lncvdm.getDeviceCount()));
                }
                this.result.setText(this.reply);
            }
        }
    }

    public void handleCloseEvent() {
        if ((this.allProgRunning || this.moduleProgRunning > 0) && this.pm != null && !this.pm.getSimplePreferenceState(this.dontWarnOnClose)) {
            JDialog dialog = new JDialog();
            dialog.setTitle(Bundle.getMessage("ReminderTitle"));
            dialog.setLocationRelativeTo(null);
            dialog.setDefaultCloseOperation(2);
            JPanel container = new JPanel();
            container.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            container.setLayout(new BoxLayout(container, 1));
            JLabel question = new JLabel(Bundle.getMessage("DialogRunningWarning"), 0);
            question.setAlignmentX(0.5f);
            container.add(question);
            JButton okButton = new JButton(Bundle.getMessage("ButtonOK"));
            JPanel buttons = new JPanel();
            buttons.setAlignmentX(0.5f);
            buttons.add(okButton);
            container.add(buttons);
            JCheckBox remember = new JCheckBox(Bundle.getMessage("DontRemind"));
            remember.setAlignmentX(0.5f);
            remember.setFont(remember.getFont().deriveFont(10.0f));
            container.add(remember);
            okButton.addActionListener(e -> {
                if (remember.isSelected() && this.pm != null) {
                    this.pm.setSimplePreferenceState(this.dontWarnOnClose, remember.isSelected());
                }
                dialog.dispose();
            });
            dialog.getContentPane().add(container);
            dialog.pack();
            dialog.setModal(true);
            dialog.setVisible(true);
        }
    }

    @Override
    public void dispose() {
        if (this.memo != null && this.memo.getLnTrafficController() != null) {
            this.memo.getLnTrafficController().removeLocoNetListener(-1, this);
        }
        if (this.pm != null) {
            this.pm.setSimplePreferenceState(this.rawDataCheck, this.rawCheckBox.isSelected());
        }
        if (this.moduleProgRunning >= 0) {
            this.modProgButtonActionPerformed();
        }
        if (this.allProgRunning) {
            this.allProgButtonActionPerformed();
        }
        super.setVisible(false);
        InstanceManager.getOptionalDefault(JTablePersistenceManager.class).ifPresent(tpm -> {
            LncvProgPane lncvProgPane = this;
            synchronized (lncvProgPane) {
                tpm.stopPersisting(this.moduleTable);
            }
        });
        super.dispose();
    }

    protected String getArticleEntry() {
        if (!this.articleField.isEditable()) {
            return "locked";
        }
        return this.articleField.getText();
    }

    protected String getAddressEntry() {
        if (!this.addressField.isEditable()) {
            return "locked";
        }
        return this.addressField.getText();
    }

    protected synchronized String getMonitorContents() {
        return this.reply;
    }

    protected void setCvFields(int cvNum, int cvVal) {
        this.cvField.setText("" + cvNum);
        if (cvVal > -1) {
            this.valueField.setText("" + cvVal);
        } else {
            this.valueField.setText("");
        }
    }

    protected synchronized LncvDevice getModule(int i) {
        if (this.lncvdm == null) {
            this.lncvdm = this.memo.getLncvDevicesManager();
        }
        log.debug("lncvdm.getDeviceCount()={}", (Object)this.lncvdm.getDeviceCount());
        if (i > -1 && i < this.lncvdm.getDeviceCount()) {
            return this.lncvdm.getDeviceList().getDevice(i);
        }
        log.debug("getModule({}) failed", (Object)i);
        return null;
    }
}

