/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.swing.lnsv1prog;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableRowSorter;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrit.beantable.EnablingCheckboxRenderer;
import jmri.jmrix.loconet.Lnsv1DevicesManager;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.lnsvf1.Lnsv1Device;
import jmri.jmrix.loconet.lnsvf1.Lnsv1MessageContents;
import jmri.jmrix.loconet.swing.LnPanel;
import jmri.jmrix.loconet.swing.lnsv1prog.Bundle;
import jmri.jmrix.loconet.swing.lnsv1prog.Lnsv1ProgTableModel;
import jmri.swing.JTablePersistenceManager;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lnsv1ProgPane
extends LnPanel
implements LocoNetListener {
    private LocoNetSystemConnectionMemo memo;
    protected JButton probeAllButton = new JButton();
    protected JButton setAllAddressButton = new JButton();
    protected JButton readButton = new JButton(Bundle.getMessage("ButtonRead"));
    protected JButton writeButton = new JButton(Bundle.getMessage("ButtonWrite"));
    protected JTextField addressField = new JTextField(4);
    protected JTextField subAddressField = new JTextField(4);
    protected JTextField svField = new JTextField(4);
    protected JTextField valueField = new JTextField(4);
    protected JCheckBox rawCheckBox = new JCheckBox(Bundle.getMessage("ButtonShowRaw"));
    protected JCheckBox decimalCheckBox = new JCheckBox(Bundle.getMessage("ButtonShowDecimal"));
    protected JTable moduleTable = null;
    protected Lnsv1ProgTableModel moduleTableModel = null;
    public static final int ROW_HEIGHT = new JButton((String)"X").getPreferredSize().height * 9 / 10;
    protected JPanel tablePanel = null;
    protected JLabel statusText1 = new JLabel();
    protected JLabel statusText2 = new JLabel();
    protected JLabel sepFieldLabel = new JLabel("/", 4);
    protected JLabel addressFieldLabel = new JLabel(Bundle.getMessage("LabelModuleAddress", 4));
    protected JLabel svFieldLabel = new JLabel(Bundle.getMessage("LabelSv"), 4);
    protected JLabel valueFieldLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("HeadingValue")), 4);
    protected JTextArea result = new JTextArea(6, 50);
    protected String reply = "";
    protected int addr;
    protected int subAddr;
    protected int sv = 0;
    protected int val;
    boolean writeConfirmed = false;
    private final String rawDataCheck = this.getClass().getName() + ".RawData";
    private final String decimalDataCheck = this.getClass().getName() + ".DecimalData";
    private UserPreferencesManager pm;
    private transient TableRowSorter<Lnsv1ProgTableModel> sorter;
    private Lnsv1DevicesManager lnsv1dm;
    private static final Logger log = LoggerFactory.getLogger(Lnsv1ProgPane.class);

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.loconet.swing.lnsv1prog.Lnsv1ProgPane";
    }

    @Override
    public String getTitle() {
        return Bundle.getMessage("MenuItemLnsv1Prog");
    }

    @Override
    public void initComponents() {
        this.setLayout(new BoxLayout(this, 3));
        this.add(this.initButtonPanel());
        this.add(this.initStatusPanel());
    }

    @Override
    public synchronized void initComponents(LocoNetSystemConnectionMemo memo) {
        super.initComponents(memo);
        this.memo = memo;
        this.lnsv1dm = memo.getLnsv1DevicesManager();
        this.pm = InstanceManager.getDefault(UserPreferencesManager.class);
        if (memo.getLnTrafficController() == null) {
            log.error("No traffic controller is available");
        } else {
            memo.getLnTrafficController().addLocoNetListener(-1, this);
        }
        this.moduleTableModel = new Lnsv1ProgTableModel(this, memo);
        this.moduleTable = new JTable(this.moduleTableModel);
        this.moduleTable.setRowSelectionAllowed(false);
        this.moduleTable.setPreferredScrollableViewportSize(new Dimension(300, 200));
        this.moduleTable.setRowHeight(ROW_HEIGHT);
        this.moduleTable.setDefaultEditor(JButton.class, new ButtonEditor(new JButton()));
        this.moduleTable.setDefaultRenderer(JButton.class, new ButtonRenderer());
        this.moduleTable.setDefaultRenderer(Boolean.class, new EnablingCheckboxRenderer());
        this.moduleTable.setRowSelectionAllowed(true);
        this.moduleTable.getSelectionModel().addListSelectionListener(event -> {
            Lnsv1ProgPane lnsv1ProgPane = this;
            synchronized (lnsv1ProgPane) {
                if (this.moduleTable.getSelectedRow() > -1 && this.moduleTable.getSelectedRow() < this.moduleTable.getRowCount()) {
                    this.copyEntrytoFields((Integer)this.moduleTable.getValueAt(this.moduleTable.getSelectedRow(), 1));
                    this.setCvFields((Integer)this.moduleTable.getValueAt(this.moduleTable.getSelectedRow(), 4), (Integer)this.moduleTable.getValueAt(this.moduleTable.getSelectedRow(), 5));
                }
            }
        });
        this.sorter = new TableRowSorter<Lnsv1ProgTableModel>(this.moduleTableModel);
        this.moduleTable.setRowSorter(this.sorter);
        this.moduleTable.setName("LNSV1 Device Management");
        InstanceManager.getOptionalDefault(JTablePersistenceManager.class).ifPresent(tpm -> {
            Lnsv1ProgPane lnsv1ProgPane = this;
            synchronized (lnsv1ProgPane) {
                tpm.resetState(this.moduleTable);
                tpm.persist(this.moduleTable, true);
            }
        });
        JScrollPane tableScrollPane = new JScrollPane(this.moduleTable);
        this.tablePanel = new JPanel();
        Border resultBorder = BorderFactory.createEtchedBorder();
        TitledBorder resultTitled = BorderFactory.createTitledBorder(resultBorder, Bundle.getMessage("Lnsv1TableTitle"));
        this.tablePanel.setBorder(resultTitled);
        this.tablePanel.setLayout(new BoxLayout(this.tablePanel, 1));
        this.tablePanel.add(tableScrollPane);
        JSplitPane splitPane = new JSplitPane(0, this.tablePanel, this.getMonitorPanel());
        splitPane.setOneTouchExpandable(true);
        splitPane.setAlignmentX(0.5f);
        splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.add(splitPane);
        this.rawCheckBox.setSelected(this.pm.getSimplePreferenceState(this.rawDataCheck));
        this.decimalCheckBox.setSelected(this.pm.getSimplePreferenceState(this.decimalDataCheck));
        this.probeAllButtonActionPerformed();
    }

    protected JPanel getMonitorPanel() {
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 1));
        JPanel panel31 = new JPanel();
        panel31.setLayout(new BoxLayout(panel31, 1));
        JScrollPane resultScrollPane = new JScrollPane(this.result);
        panel31.add(resultScrollPane);
        JPanel panel31b = new JPanel();
        panel31b.setLayout(new BoxLayout(panel31b, 0));
        panel31b.add(this.rawCheckBox);
        this.rawCheckBox.setVisible(true);
        this.rawCheckBox.setToolTipText(Bundle.getMessage("TooltipShowRaw"));
        panel31b.add(this.decimalCheckBox);
        this.decimalCheckBox.setVisible(true);
        this.decimalCheckBox.setToolTipText(Bundle.getMessage("TooltipShowDecimal"));
        panel31.add(panel31b);
        panel3.add(panel31);
        Border panel3Border = BorderFactory.createEtchedBorder();
        TitledBorder panel3Titled = BorderFactory.createTitledBorder(panel3Border, Bundle.getMessage("Lnsv1MonitorTitle"));
        panel3.setBorder(panel3Titled);
        return panel3;
    }

    protected JPanel initButtonPanel() {
        JPanel panel4 = new JPanel();
        panel4.setLayout(new BoxLayout(panel4, 0));
        panel4.add(Box.createHorizontalGlue());
        JPanel panel41 = new JPanel();
        panel41.setLayout(new BoxLayout(panel41, 3));
        this.probeAllButton.setText(Bundle.getMessage("ButtonProbe"));
        this.probeAllButton.setToolTipText(Bundle.getMessage("TipProbeAllButton"));
        this.probeAllButton.addActionListener(e -> this.probeAllButtonActionPerformed());
        panel41.add(this.probeAllButton);
        this.setAllAddressButton.setText(Bundle.getMessage("ButtonSetModuleAddress"));
        this.setAllAddressButton.setToolTipText(Bundle.getMessage("TipSetModuleAddrButton"));
        this.setAllAddressButton.addActionListener(e -> this.setAllAddressButtonActionPerformed());
        panel41.add(this.setAllAddressButton);
        panel4.add(panel41);
        JPanel panel42 = new JPanel();
        panel42.setLayout(new BoxLayout(panel42, 3));
        JPanel panel421 = new JPanel();
        panel421.add(this.addressFieldLabel);
        JPanel panel4211 = new JPanel();
        this.addressField.setToolTipText(Bundle.getMessage("TipModuleAddrEntry"));
        panel4211.add(this.addressField);
        panel4211.add(this.sepFieldLabel);
        this.subAddressField.setToolTipText(Bundle.getMessage("TipModuleSubaddrEntry"));
        panel4211.add(this.subAddressField);
        panel421.add(panel4211);
        panel42.add(panel421);
        panel4.add(panel42);
        JPanel panel43 = new JPanel();
        Border panel43Border = BorderFactory.createEtchedBorder();
        panel43.setBorder(panel43Border);
        panel43.setLayout(new BoxLayout(panel43, 2));
        JPanel panel431 = new JPanel();
        panel431.setLayout(new BoxLayout(panel431, 3));
        this.svFieldLabel.setAlignmentX(1.0f);
        this.svFieldLabel.setMinimumSize(new Dimension(60, new JTextField("X").getHeight() + 5));
        panel431.add(this.svFieldLabel);
        this.valueFieldLabel.setAlignmentX(1.0f);
        this.valueFieldLabel.setMinimumSize(new Dimension(60, new JTextField("X").getHeight() + 5));
        panel431.add(this.valueFieldLabel);
        panel43.add(panel431);
        JPanel panel432 = new JPanel();
        panel432.setMaximumSize(new Dimension(50, 50));
        panel432.setPreferredSize(new Dimension(50, 50));
        panel432.setMinimumSize(new Dimension(50, 50));
        panel432.setLayout(new BoxLayout(panel432, 3));
        panel432.add(this.svField);
        panel432.add(this.valueField);
        panel43.add(panel432);
        JPanel panel433 = new JPanel();
        panel433.setLayout(new BoxLayout(panel433, 3));
        panel433.add(this.readButton);
        this.readButton.setEnabled(true);
        this.readButton.addActionListener(e -> this.readButtonActionPerformed());
        panel433.add(this.writeButton);
        this.writeButton.setEnabled(false);
        this.writeButton.addActionListener(e -> this.writeButtonActionPerformed());
        this.writeButton.setToolTipText(Bundle.getMessage("ButtonWriteInactiveTip"));
        panel43.add(panel433);
        panel4.add(panel43);
        panel4.add(Box.createHorizontalGlue());
        panel4.setAlignmentX(0.5f);
        return panel4;
    }

    protected JPanel initStatusPanel() {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 3));
        this.statusText1.setText("   ");
        this.statusText1.setHorizontalAlignment(0);
        panel2.add(this.statusText1);
        this.statusText2.setText("   ");
        this.statusText2.setHorizontalAlignment(0);
        panel2.add(this.statusText2);
        panel2.setAlignmentX(0.5f);
        return panel2;
    }

    public void probeAllButtonActionPerformed() {
        this.statusText1.setText(Bundle.getMessage("FeedBackProbing"));
        this.probeAllButton.setText(Bundle.getMessage("ButtonProbing"));
        LocoNetMessage m = Lnsv1MessageContents.createBroadcastProbeAll();
        this.memo.getLnTrafficController().sendLocoNetMessage(m);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        this.statusText1.setText(Bundle.getMessage("FeedBackProbingStop"));
        this.probeAllButton.setText(Bundle.getMessage("ButtonProbe"));
    }

    public void setAllAddressButtonActionPerformed() {
        this.addressField.setBackground(Color.WHITE);
        this.subAddressField.setBackground(Color.WHITE);
        if (this.addressField.getText().isEmpty() || this.subAddressField.getText().isEmpty()) {
            this.statusText1.setText(Bundle.getMessage("FeedBackEnterHiLoAddress"));
            if (this.addressField.getText().isEmpty()) {
                this.addressField.setBackground(Color.RED);
            } else {
                this.subAddressField.setBackground(Color.RED);
            }
            this.setAllAddressButton.setSelected(false);
            return;
        }
        Object[] dialogBoxButtonOptions = new Object[]{Bundle.getMessage("ButtonProceed"), Bundle.getMessage("ButtonCancel")};
        int userReply = JmriJOptionPane.showOptionDialog(this.getParent(), Bundle.getMessage("DialogAllLnsv1Warning"), Bundle.getMessage("WarningTitle"), -1, 3, null, dialogBoxButtonOptions, dialogBoxButtonOptions[1]);
        if (userReply != 0) {
            return;
        }
        if (!this.addressField.getText().isEmpty() && !this.subAddressField.getText().isEmpty()) {
            try {
                LocoNetMessage[] messageArray;
                this.addr = this.inDomain(this.addressField.getText(), 1, 127);
                this.subAddr = this.inDomain(this.subAddressField.getText(), 1, 127);
                if (this.addr == 80) {
                    this.locoBufferReservedAddress();
                    return;
                }
                this.setAllAddressButton.setEnabled(false);
                this.statusText1.setText(Bundle.getMessage("FeedBackModAddrStart", this.addr, this.subAddr));
                this.addressField.setEditable(false);
                this.subAddressField.setEditable(false);
                for (LocoNetMessage m : messageArray = Lnsv1MessageContents.createBroadcastSetAddress(this.addr, this.subAddr)) {
                    if (m == null) continue;
                    this.memo.getLnTrafficController().sendLocoNetMessage(m);
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                this.setAllAddressButton.setEnabled(true);
                this.addressField.setEditable(true);
                this.subAddressField.setEditable(true);
            }
            catch (NumberFormatException e) {
                this.statusText1.setText(Bundle.getMessage("FeedBackEnterHiLoAddress"));
                log.error("invalid entry, both must be numbers");
            }
        }
    }

    public void readButtonActionPerformed() {
        this.addressField.setBackground(Color.WHITE);
        this.subAddressField.setBackground(Color.WHITE);
        this.svField.setBackground(Color.WHITE);
        if (this.addressField.getText().isEmpty() || this.subAddressField.getText().isEmpty()) {
            this.statusText1.setText(Bundle.getMessage("FeedBackEnterHiLoAddress"));
            if (this.addressField.getText().isEmpty()) {
                this.addressField.setBackground(Color.RED);
            } else {
                this.subAddressField.setBackground(Color.RED);
            }
            this.setAllAddressButton.setSelected(false);
            return;
        }
        if (this.svField.getText().isEmpty()) {
            this.svField.setBackground(Color.RED);
            this.statusText1.setText(Bundle.getMessage("FeedBackEnterSv"));
            return;
        }
        try {
            this.addr = this.inDomain(this.addressField.getText(), 1, 127);
            this.subAddr = this.inDomain(this.subAddressField.getText(), 1, 127);
            if (this.addr == 80) {
                this.locoBufferReservedAddress();
                return;
            }
            this.sv = this.inDomain(this.svField.getText(), 0, 127);
            log.debug("ReadButtonPressed adrL={}, sub={}, sv={}", new Object[]{this.addr, this.subAddr, this.sv});
            LocoNetMessage m = Lnsv1MessageContents.createSv1ReadRequest(this.addr, this.subAddr, this.sv);
            this.memo.getLnTrafficController().sendLocoNetMessage(m);
        }
        catch (NumberFormatException e) {
            this.statusText1.setText(Bundle.getMessage("FeedBackEnterNumbers"));
            log.error("invalid entry, must be numbers");
        }
        this.statusText1.setText(Bundle.getMessage("FeedBackRead", "LNSV1"));
    }

    public void writeButtonActionPerformed() {
        if (this.addressField.getText() != null && this.subAddressField.getText() != null && this.svField.getText() != null && this.valueField.getText() != null) {
            try {
                this.addr = this.inDomain(this.addressField.getText(), 1, 127);
                this.subAddr = this.inDomain(this.subAddressField.getText(), 1, 127);
                if (this.addr == 80) {
                    this.locoBufferReservedAddress();
                    return;
                }
                this.sv = this.inDomain(this.svField.getText(), 1, 127);
                this.val = this.inDomain(this.valueField.getText(), 0, 127);
                if (this.sv == 100 || this.sv == 80) {
                    this.statusText1.setText(Bundle.getMessage("FeedBackValidAddressRange"));
                    this.valueField.setBackground(Color.RED);
                    return;
                }
                this.writeConfirmed = false;
                LocoNetMessage m = Lnsv1MessageContents.createSv1WriteRequest(this.addr, this.subAddr, this.sv, this.val);
                this.memo.getLnTrafficController().sendLocoNetMessage(m);
                this.valueField.setBackground(Color.ORANGE);
            }
            catch (NumberFormatException e) {
                this.statusText1.setText(Bundle.getMessage("FeedBackEnterNumbers"));
                log.error("invalid entry, must be numbers");
            }
        } else {
            this.statusText1.setText(Bundle.getMessage("FeedBackEnterHiLoAddress"));
            return;
        }
        this.statusText1.setText(Bundle.getMessage("FeedBackWrite", "LNSV1"));
    }

    private int inDomain(String entry, int min, int max) {
        int n = -1;
        try {
            n = Integer.parseInt(entry);
        }
        catch (NumberFormatException e) {
            log.error("invalid entry, must be number");
        }
        if (min <= n && n <= max) {
            return n;
        }
        this.statusText1.setText(Bundle.getMessage("FeedBackInputOutsideRange"));
        return 0;
    }

    public void copyEntrytoFields(int adr) {
        this.addressField.setText("" + (adr & 0x7F));
        this.subAddressField.setText("" + ((adr >> 8 & 0x7F) + 1));
    }

    private void locoBufferReservedAddress() {
        Object[] dialogBoxButtonOptions = new Object[]{Bundle.getMessage("ButtonOK")};
        JmriJOptionPane.showOptionDialog(this.getParent(), Bundle.getMessage("DialogWarnLbReserved"), Bundle.getMessage("WarningTitle"), -1, 2, null, dialogBoxButtonOptions, dialogBoxButtonOptions[0]);
    }

    @Override
    public synchronized void message(LocoNetMessage m) {
        if (!Lnsv1MessageContents.isSupportedSv1Message(m)) {
            log.debug("Rejected by isSupportedSv1Message");
            return;
        }
        Object raw = this.rawCheckBox.isSelected() ? "[" + m + "] " : "";
        String formatted = m.toMonitorString(this.memo.getSystemPrefix());
        this.reply = this.reply + (String)raw + formatted;
        boolean addDec = this.decimalCheckBox.isSelected();
        Lnsv1MessageContents contents = new Lnsv1MessageContents(m);
        if (Lnsv1MessageContents.extractMessageType(m) == Lnsv1MessageContents.Sv1Command.SV1_WRITE) {
            log.debug("SV1_WRITE decode contents");
            if (contents.getSrcL() == 80) {
                if (contents.getDstL() == 0) {
                    log.debug("Write all from LocoBuffer/PC");
                    if (addDec) {
                        this.reply = this.reply + Bundle.getMessage("SV1_WRITE_ALL_INTERPRETED_DEC", contents.getSvNum(), contents.getSv1D4());
                    }
                } else {
                    log.debug("Write request from LocoBuffer/PC");
                    if (addDec) {
                        this.reply = this.reply + Bundle.getMessage("SV1_WRITE_INTERPRETED_DEC", contents.getSrcL(), contents.getSubAddress(), contents.getSvNum(), contents.getSv1D4());
                    }
                }
            } else {
                log.debug("Write Reply from LocoIO");
                if (addDec) {
                    this.reply = this.reply + Bundle.getMessage("SV1_WRITE_REPLY_INTERPRETED_DEC", contents.getSrcL(), contents.getSubAddress(), contents.getSvNum(), contents.getSv1D8());
                }
            }
        }
        if (Lnsv1MessageContents.extractMessageType(m) == Lnsv1MessageContents.Sv1Command.SV1_READ) {
            log.debug("SV1_READ decode contents");
            if (contents.getSrcL() == 80) {
                log.debug("Read request from LocoBuffer/PC");
                if (addDec) {
                    this.reply = this.reply + Bundle.getMessage("SV1_READ_INTERPRETED_DEC", contents.getDstL(), contents.getSubAddress(), contents.getSvNum());
                }
            } else {
                Lnsv1Device dev;
                log.debug("Read Reply from LocoIO");
                if (addDec) {
                    this.reply = this.reply + Bundle.getMessage("SV1_READ_REPLY_INTERPRETED_DEC", contents.getSrcL(), contents.getSubAddress(), contents.getSvNum(), contents.getSv1D6(), contents.getSv1D7(), contents.getSv1D8());
                }
                if (("" + contents.getSrcL()).equals(this.addressField.getText()) && ("" + contents.getSubAddress()).equals(this.subAddressField.getText()) && ("" + contents.getSvNum()).equals(this.svField.getText())) {
                    this.valueField.setText("" + contents.getSvValue());
                }
                if ((dev = this.memo.getLnsv1DevicesManager().getDevice(this.addr, this.subAddr)) != null) {
                    dev.setCvNum(contents.getSvNum());
                    dev.setCvValue(contents.getSv1D4());
                }
                this.memo.getLnsv1DevicesManager().firePropertyChange("DeviceListChanged", true, false);
            }
        }
        if (this.reply != null) {
            this.allProgFinished(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allProgFinished(String error) {
        if (error != null) {
            log.error("LNSV1 process finished with error: {}", (Object)error);
            this.statusText2.setText(Bundle.getMessage("FeedBackDiscoverFail"));
        } else {
            Lnsv1ProgPane lnsv1ProgPane = this;
            synchronized (lnsv1ProgPane) {
                if (this.lnsv1dm.getDeviceCount() == 1) {
                    this.statusText2.setText(Bundle.getMessage("FeedBackDiscoverSuccessOne"));
                } else {
                    this.statusText2.setText(Bundle.getMessage("FeedBackDiscoverSuccess", this.lnsv1dm.getDeviceCount()));
                }
                this.result.setText(this.reply);
            }
        }
    }

    @Override
    public void dispose() {
        if (this.memo != null && this.memo.getLnTrafficController() != null) {
            this.memo.getLnTrafficController().removeLocoNetListener(-1, this);
        }
        if (this.pm != null) {
            this.pm.setSimplePreferenceState(this.rawDataCheck, this.rawCheckBox.isSelected());
            this.pm.setSimplePreferenceState(this.decimalDataCheck, this.decimalCheckBox.isSelected());
        }
        super.setVisible(false);
        InstanceManager.getOptionalDefault(JTablePersistenceManager.class).ifPresent(tpm -> {
            Lnsv1ProgPane lnsv1ProgPane = this;
            synchronized (lnsv1ProgPane) {
                tpm.stopPersisting(this.moduleTable);
            }
        });
        super.dispose();
    }

    protected synchronized String getMonitorContents() {
        return this.reply;
    }

    protected void setCvFields(int cvNum, int cvVal) {
        this.svField.setText("" + cvNum);
        if (cvVal > -1) {
            this.valueField.setText("" + cvVal);
        } else {
            this.valueField.setText("");
        }
    }

    protected synchronized Lnsv1Device getModule(int i) {
        if (this.lnsv1dm == null) {
            this.lnsv1dm = this.memo.getLnsv1DevicesManager();
        }
        if (i > -1 && i < this.lnsv1dm.getDeviceCount()) {
            return this.lnsv1dm.getDeviceList().getDevice(i);
        }
        log.debug("getModule({}) failed", (Object)i);
        return null;
    }
}

