/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.swing.lnsv1prog;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.annotation.Nonnull;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jmri.InstanceManager;
import jmri.Programmer;
import jmri.jmrit.decoderdefn.DecoderFile;
import jmri.jmrit.decoderdefn.DecoderIndexFile;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.symbolicprog.tabbedframe.PaneOpsProgFrame;
import jmri.jmrix.ProgrammingTool;
import jmri.jmrix.loconet.Lnsv1DevicesManager;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.lnsvf1.Lnsv1Device;
import jmri.jmrix.loconet.swing.lnsv1prog.Bundle;
import jmri.jmrix.loconet.swing.lnsv1prog.Lnsv1ProgPane;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lnsv1ProgTableModel
extends AbstractTableModel
implements PropertyChangeListener,
ProgrammingTool {
    public static final int COUNT_COLUMN = 0;
    public static final int MODADDR_COLUMN = 1;
    public static final int MODADDRSPLIT_COLUMN = 2;
    public static final int VERSION_COLUMN = 3;
    public static final int CV_COLUMN = 4;
    public static final int VALUE_COLUMN = 5;
    public static final int ROSTERENTRY_COLUMN = 6;
    public static final int ROSTERSV1MODE_COLUMN = 7;
    public static final int ROSTERNAME_COLUMN = 8;
    public static final int OPENPRGMRBUTTON_COLUMN = 9;
    public static final int NUMCOLUMNS = 10;
    private final Lnsv1ProgPane parent;
    private final transient LocoNetSystemConnectionMemo memo;
    protected Roster _roster;
    protected Lnsv1DevicesManager lnsv1dm;
    private static final Logger log = LoggerFactory.getLogger(Lnsv1ProgTableModel.class);

    Lnsv1ProgTableModel(Lnsv1ProgPane parent, @Nonnull LocoNetSystemConnectionMemo memo) {
        this.parent = parent;
        this.memo = memo;
        this.lnsv1dm = memo.getLnsv1DevicesManager();
        this._roster = Roster.getDefault();
        this.lnsv1dm.addPropertyChangeListener(this);
    }

    public void initTable(JTable lnsv1ModulesTable) {
        TableColumnModel assignmentColumnModel = lnsv1ModulesTable.getColumnModel();
        TableColumn idColumn = assignmentColumnModel.getColumn(0);
        idColumn.setMaxWidth(3);
    }

    @Override
    public String getColumnName(int c) {
        switch (c) {
            case 1: {
                return Bundle.getMessage("HeadingDccAddress");
            }
            case 2: {
                return Bundle.getMessage("HeadingAddressSplit");
            }
            case 3: {
                return Bundle.getMessage("HeadingVersion");
            }
            case 4: {
                return Bundle.getMessage("HeadingCvLastRead");
            }
            case 5: {
                return Bundle.getMessage("HeadingValue");
            }
            case 6: {
                return Bundle.getMessage("HeadingDeviceId");
            }
            case 8: {
                return Bundle.getMessage("HeadingDeviceModel");
            }
            case 7: {
                return Bundle.getMessage("HeadingIsSv1");
            }
            case 9: {
                return Bundle.getMessage("ButtonProgram");
            }
        }
        return "#";
    }

    @Override
    public Class<?> getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                return Integer.class;
            }
            case 9: {
                return JButton.class;
            }
            case 7: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return c == 9;
    }

    @Override
    public int getColumnCount() {
        return 10;
    }

    @Override
    public int getRowCount() {
        if (this.lnsv1dm == null) {
            return 0;
        }
        return this.lnsv1dm.getDeviceCount();
    }

    @Override
    public Object getValueAt(int r, int c) {
        Lnsv1Device dev = this.memo.getLnsv1DevicesManager().getDeviceList().getDevice(r);
        try {
            switch (c) {
                case 1: {
                    assert (dev != null);
                    return dev.getDestAddr();
                }
                case 2: {
                    assert (dev != null);
                    return dev.getDestAddrLow() + "/" + dev.getDestAddrHigh();
                }
                case 3: {
                    assert (dev != null);
                    return dev.getSwVersion();
                }
                case 4: {
                    assert (dev != null);
                    return dev.getCvNum();
                }
                case 5: {
                    assert (dev != null);
                    return dev.getCvValue();
                }
                case 6: {
                    assert (dev != null);
                    return dev.getRosterEntry().getId();
                }
                case 7: {
                    boolean isLnsv1 = false;
                    if (dev != null && dev.getDecoderFile() != null) {
                        isLnsv1 = dev.getDecoderFile().isProgrammingMode("LOCONETSV1MODE");
                    }
                    return isLnsv1;
                }
                case 8: {
                    assert (dev != null);
                    if (dev.getRosterEntry() != null) {
                        return dev.getRosterEntry().getDecoderModel();
                    }
                    return "";
                }
                case 9: {
                    if (dev != null && !dev.getRosterName().isEmpty()) {
                        if (dev.getDecoderFile().isProgrammingMode("LOCONETSV1MODE")) {
                            return Bundle.getMessage("ButtonProgram");
                        }
                        return Bundle.getMessage("ButtonWrongMode");
                    }
                    return Bundle.getMessage("ButtonNoMatchInRoster");
                }
            }
            return r + 1;
        }
        catch (NullPointerException npe) {
            log.warn("No match for Module {}, c{}", (Object)r, (Object)c);
            return "";
        }
    }

    @Override
    public void setValueAt(Object value, int r, int c) {
        if (this.getRowCount() < r + 1) {
            return;
        }
        if (c == 9) {
            if (((String)this.getValueAt(r, c)).compareTo(Bundle.getMessage("ButtonProgram")) == 0) {
                this.openProgrammer(r);
            } else if (((String)this.getValueAt(r, c)).compareTo(Bundle.getMessage("ButtonWrongMode")) == 0) {
                this.infoNotForLnsv1(this.getValueAt(r, 1).toString());
            } else if (((String)this.getValueAt(r, c)).compareTo(Bundle.getMessage("ButtonNoMatchInRoster")) == 0) {
                this.infoNoMatch(this.getValueAt(r, 1).toString());
            }
        } else {
            return;
        }
        if (this.getRowCount() >= 1) {
            this.fireTableRowsUpdated(r, r);
        }
    }

    private void openProgrammer(int r) {
        Lnsv1Device dev = this.memo.getLnsv1DevicesManager().getDeviceList().getDevice(r);
        Lnsv1DevicesManager.ProgrammingResult result = this.lnsv1dm.prepareForSymbolicProgrammer(dev, this);
        switch (result) {
            case SUCCESS_PROGRAMMER_OPENED: {
                return;
            }
            case FAIL_NO_SUCH_DEVICE: {
                JmriJOptionPane.showMessageDialog(this.parent, Bundle.getMessage("FAIL_NO_SUCH_DEVICE"), Bundle.getMessage("TitleOpenRosterEntry"), 0);
                return;
            }
            case FAIL_NO_APPROPRIATE_PROGRAMMER: {
                JmriJOptionPane.showMessageDialog(this.parent, Bundle.getMessage("FAIL_NO_APPROPRIATE_PROGRAMMER"), Bundle.getMessage("TitleOpenRosterEntry"), 0);
                return;
            }
            case FAIL_NO_MATCHING_ROSTER_ENTRY: {
                JmriJOptionPane.showMessageDialog(this.parent, Bundle.getMessage("FAIL_NO_MATCHING_ROSTER_ENTRY"), Bundle.getMessage("TitleOpenRosterEntry"), 0);
                return;
            }
            case FAIL_DESTINATION_ADDRESS_IS_ZERO: {
                JmriJOptionPane.showMessageDialog(this.parent, Bundle.getMessage("FAIL_DESTINATION_ADDRESS_IS_ZERO"), Bundle.getMessage("TitleOpenRosterEntry"), 0);
                return;
            }
            case FAIL_MULTIPLE_DEVICES_SAME_DESTINATION_ADDRESS: {
                JmriJOptionPane.showMessageDialog(this.parent, Bundle.getMessage("FAIL_MULTIPLE_DEVICES_SAME_DESTINATION_ADDRESS", dev.getDestAddr()), Bundle.getMessage("TitleOpenRosterEntry"), 0);
                return;
            }
            case FAIL_NO_ADDRESSED_PROGRAMMER: {
                JmriJOptionPane.showMessageDialog(this.parent, Bundle.getMessage("FAIL_NO_ADDRESSED_PROGRAMMER"), Bundle.getMessage("TitleOpenRosterEntry"), 0);
                return;
            }
            case FAIL_NO_LNSV1_PROGRAMMER: {
                JmriJOptionPane.showMessageDialog(this.parent, Bundle.getMessage("FAIL_NO_LNSV1_PROGRAMMER"), Bundle.getMessage("TitleOpenRosterEntry"), 0);
                return;
            }
        }
        JmriJOptionPane.showMessageDialog(this.parent, Bundle.getMessage("FAIL_UNKNOWN"), Bundle.getMessage("TitleOpenRosterEntry"), 0);
    }

    @Override
    public void openPaneOpsProgFrame(RosterEntry re, String name, String programmerFile, Programmer p) {
        log.debug("attempting to open programmer, re={}, name={}, programmerFile={}, programmer={}", new Object[]{re, name, programmerFile, p});
        DecoderFile decoderFile = InstanceManager.getDefault(DecoderIndexFile.class).fileFromTitle(re.getDecoderModel());
        PaneOpsProgFrame progFrame = new PaneOpsProgFrame(decoderFile, re, name, programmerFile, p);
        progFrame.pack();
        progFrame.setVisible(true);
    }

    private void infoNoMatch(String address) {
        Object[] dialogBoxButtonOptions = new Object[]{Bundle.getMessage("ButtonOK")};
        JmriJOptionPane.showOptionDialog(this.parent, Bundle.getMessage("DialogInfoNoRosterMatch", address), Bundle.getMessage("TitleOpenRosterEntry"), -1, 1, null, dialogBoxButtonOptions, dialogBoxButtonOptions[0]);
    }

    private void infoNotForLnsv1(String address) {
        Object[] dialogBoxButtonOptions = new Object[]{Bundle.getMessage("ButtonOK")};
        JmriJOptionPane.showOptionDialog(this.parent, Bundle.getMessage("DialogInfoMatchNotX", address, "LNSV1"), Bundle.getMessage("TitleOpenRosterEntry"), -1, 1, null, dialogBoxButtonOptions, dialogBoxButtonOptions[0]);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.fireTableDataChanged();
    }

    public void dispose() {
        if (this.memo != null && this.memo.getLnsv1DevicesManager() != null) {
            this.memo.getLnsv1DevicesManager().removePropertyChangeListener(this);
        }
    }
}

