/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.swing.menuitemspi;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.swing.JMenu;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.swing.menuitemspi.spi.MenuItemsInterface;
import jmri.util.swing.WindowInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MenuItemsService {
    private static MenuItemsService service;
    private final ServiceLoader<MenuItemsInterface> loader = ServiceLoader.load(MenuItemsInterface.class);
    private static final Logger log;

    private MenuItemsService() {
    }

    public static synchronized MenuItemsService getInstance() {
        if (service == null) {
            service = new MenuItemsService();
        }
        return service;
    }

    public List<JMenu> getMenuExtensionsItems(boolean isLocoNetInterface, WindowInterface wi, LocoNetSystemConnectionMemo memo) {
        ArrayList<JMenu> menus = new ArrayList<JMenu>();
        try {
            for (MenuItemsInterface mii : this.loader) {
                log.debug("adding menu items for extension {}", mii.getClass());
                ArrayList<JMenu> me = mii.getMenuItems(isLocoNetInterface, wi, memo);
                menus.addAll(me);
            }
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            // empty catch block
        }
        return menus;
    }

    static {
        log = LoggerFactory.getLogger(MenuItemsService.class);
    }
}

