/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.uhlenbrock;

import java.util.Arrays;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.loconet.LnCommandStationType;
import jmri.jmrix.loconet.locobuffer.LocoBufferAdapter;
import jmri.jmrix.loconet.uhlenbrock.Bundle;
import jmri.jmrix.loconet.uhlenbrock.UhlenbrockPacketizer;
import jmri.jmrix.loconet.uhlenbrock.UhlenbrockSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UhlenbrockAdapter
extends LocoBufferAdapter {
    private static final Logger log = LoggerFactory.getLogger(UhlenbrockAdapter.class);

    public UhlenbrockAdapter() {
        super(new UhlenbrockSystemConnectionMemo());
        this.options.remove(this.option2Name);
        this.options.put(this.option2Name, new AbstractPortController.Option(Bundle.getMessage("CommandStationTypeLabel"), this.commandStationOptions(), false));
        this.options.put("InterrogateOnStart", new AbstractPortController.Option(Bundle.getMessage("InterrogateOnStart"), new String[]{Bundle.getMessage("ButtonYes"), Bundle.getMessage("ButtonNo")}));
        this.validSpeeds = new String[]{Bundle.getMessage("Baud19200"), Bundle.getMessage("Baud38400"), Bundle.getMessage("Baud57600"), Bundle.getMessage("Baud115200")};
        this.validSpeedValues = new int[]{19200, 38400, 57600, 115200};
        this.configureBaudRate(this.validSpeeds[3]);
    }

    @Override
    public void configure() {
        this.setCommandStationType(this.getOptionState(this.option2Name));
        this.setTurnoutHandling(this.getOptionState(this.option3Name));
        this.setInterrogateOnStart(this.getOptionState("InterrogateOnStart"));
        UhlenbrockPacketizer packets = new UhlenbrockPacketizer(this.getSystemConnectionMemo());
        packets.connectPort(this);
        this.getSystemConnectionMemo().setLnTrafficController(packets);
        this.getSystemConnectionMemo().configureCommandStation(this.commandStationType, this.mTurnoutNoRetry, this.mTurnoutExtraSpace, this.mTranspondingAvailable, this.mInterrogateAtStart, false);
        this.getSystemConnectionMemo().configureManagers();
        packets.startThreads();
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    @Override
    public int defaultBaudIndex() {
        return 3;
    }

    @Override
    public boolean okToSend() {
        return true;
    }

    @Override
    protected void reportOpen(String portName) {
        log.info("Connecting Uhlenbrock via {} {}", (Object)portName, (Object)this.currentSerialPort);
    }

    @Override
    protected void setLocalFlowControl() {
        AbstractSerialPortController.FlowControl flow = AbstractSerialPortController.FlowControl.NONE;
        this.setFlowControl(this.currentSerialPort, flow);
    }

    public String[] commandStationOptions() {
        String[] retval = new String[]{LnCommandStationType.COMMAND_STATION_IBX_TYPE_2.getName()};
        return retval;
    }
}

