/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.uhlenbrock;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Calendar;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.SwingUtilities;
import jmri.jmrix.loconet.LnPacketizer;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetMessageException;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UhlenbrockPacketizer
extends LnPacketizer {
    public static final int NOTIFIEDSTATE = 15;
    public static final int WAITMSGREPLYSTATE = 25;
    static int defaultWaitTimer = 10000;
    public ConcurrentLinkedQueue<LocoNetMessage> xmtLocoNetList = new ConcurrentLinkedQueue();
    LocoNetMessage lastMessage;
    protected volatile int mCurrentState;
    private static final Logger log = LoggerFactory.getLogger(UhlenbrockPacketizer.class);

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="Only used during system initialization")
    public UhlenbrockPacketizer(LocoNetSystemConnectionMemo m) {
        super(m);
        log.debug("UhlenbrockPacketizer instantiated");
    }

    @Override
    public void sendLocoNetMessage(LocoNetMessage m) {
        log.debug("add to queue message {}", (Object)m.toString());
        ++this.transmittedMsgCount;
        m.setParity();
        int len = m.getNumDataElements();
        byte[] msg = new byte[len];
        for (int i = 0; i < len; ++i) {
            msg[i] = (byte)m.getElement(i);
        }
        if (log.isDebugEnabled()) {
            log.debug("queue LocoNet packet: {}", (Object)m.toString());
        }
        try {
            this.xmtLocoNetList.add(m);
            this.xmtList.add(msg);
        }
        catch (RuntimeException e) {
            log.warn("passing to xmit: unexpected exception: ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transmitWait(int waitTime, int state) {
        long currentTime = Calendar.getInstance().getTimeInMillis();
        long endTime = currentTime + (long)waitTime;
        while (endTime > (currentTime = Calendar.getInstance().getTimeInMillis())) {
            long wait = endTime - currentTime;
            try {
                Runnable runnable = this.xmtHandler;
                synchronized (runnable) {
                    if (this.mCurrentState != state) {
                        return;
                    }
                    this.xmtHandler.wait(wait);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("transmitLoop interrupted");
            }
        }
        log.debug("Timeout in transmitWait, mCurrentState: {}", (Object)this.mCurrentState);
    }

    @Override
    public void startThreads() {
        int xmtpriority;
        int priority = Thread.currentThread().getPriority();
        log.debug("startThreads current priority = {} max available = 10 default = 5 min available = 1", (Object)priority);
        int n = xmtpriority = 9 > priority ? 9 : 10;
        if (this.xmtHandler == null) {
            this.xmtHandler = new XmtHandler();
        }
        this.xmtThread = new Thread(this.xmtHandler, "LocoNet Uhlenbrock transmit handler");
        log.debug("Xmt thread starts at priority {}", (Object)xmtpriority);
        this.xmtThread.setDaemon(true);
        this.xmtThread.setPriority(9);
        this.xmtThread.start();
        if (this.rcvHandler == null) {
            this.rcvHandler = new RcvHandler(this);
        }
        this.rcvThread = new Thread(this.rcvHandler, "LocoNet Uhlenbrock receive handler");
        this.rcvThread.setDaemon(true);
        this.rcvThread.setPriority(10);
        this.rcvThread.start();
    }

    class XmtHandler
    implements Runnable {
        XmtHandler() {
        }

        @Override
        public void run() {
            block4: while (true) {
                try {
                    while (true) {
                        log.debug("check for input");
                        byte[] msg = null;
                        UhlenbrockPacketizer.this.lastMessage = null;
                        msg = (byte[])UhlenbrockPacketizer.this.xmtList.take();
                        UhlenbrockPacketizer.this.lastMessage = (LocoNetMessage)UhlenbrockPacketizer.this.xmtLocoNetList.remove();
                        try {
                            if (UhlenbrockPacketizer.this.ostream != null) {
                                if (!UhlenbrockPacketizer.this.controller.okToSend()) {
                                    log.debug("LocoNet port not ready to receive");
                                }
                                log.debug("start write to stream");
                                while (!UhlenbrockPacketizer.this.controller.okToSend()) {
                                    Thread.yield();
                                }
                                UhlenbrockPacketizer.this.ostream.write(msg);
                                UhlenbrockPacketizer.this.ostream.flush();
                                log.debug("end write to stream");
                                UhlenbrockPacketizer.this.messageTransmitted(msg);
                                UhlenbrockPacketizer.this.mCurrentState = 25;
                                UhlenbrockPacketizer.this.transmitWait(defaultWaitTimer, 25);
                                continue block4;
                            }
                            log.warn("sendLocoNetMessage: no connection established");
                            continue block4;
                        }
                        catch (IOException e) {
                            log.warn("sendLocoNetMessage: IOException: {}", (Object)e.toString());
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException ie) {
                    return;
                }
            }
        }
    }

    class RcvHandler
    implements Runnable {
        LnPacketizer trafficController;

        public RcvHandler(LnPacketizer lt) {
            this.trafficController = lt;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        int opCode;
                        int inbyte = UhlenbrockPacketizer.this.readByteProtected(UhlenbrockPacketizer.this.istream) & 0xFF;
                        while (((opCode = inbyte) & 0x80) == 0) {
                            log.debug("Skipping: {}", (Object)Integer.toHexString(opCode));
                            inbyte = UhlenbrockPacketizer.this.readByteProtected(UhlenbrockPacketizer.this.istream) & 0xFF;
                        }
                        log.debug("Start message with opcode: {}", (Object)Integer.toHexString(opCode));
                        LocoNetMessage msg = null;
                        while (msg == null) {
                            try {
                                int byte2 = UhlenbrockPacketizer.this.readByteProtected(UhlenbrockPacketizer.this.istream) & 0xFF;
                                if ((byte2 & 0x80) != 0) {
                                    log.warn("LocoNet message with opCode: {} ended early. Byte2 is also an opcode: {}", (Object)Integer.toHexString(opCode), (Object)Integer.toHexString(byte2));
                                    opCode = byte2;
                                    throw new LocoNetMessageException();
                                }
                                switch ((opCode & 0x60) >> 5) {
                                    case 0: {
                                        msg = new LocoNetMessage(2);
                                        break;
                                    }
                                    case 1: {
                                        msg = new LocoNetMessage(4);
                                        break;
                                    }
                                    case 2: {
                                        msg = new LocoNetMessage(6);
                                        break;
                                    }
                                    case 3: {
                                        if (byte2 < 2) {
                                            log.error("LocoNet message length invalid: {} opcode: {}", (Object)byte2, (Object)Integer.toHexString(opCode));
                                        }
                                        msg = new LocoNetMessage(byte2);
                                        break;
                                    }
                                    default: {
                                        throw new LocoNetMessageException("decode failure " + byte2);
                                    }
                                }
                                msg.setOpCode(opCode);
                                msg.setElement(1, byte2);
                                int len = msg.getNumDataElements();
                                for (int i = 2; i < len; ++i) {
                                    int b = UhlenbrockPacketizer.this.readByteProtected(UhlenbrockPacketizer.this.istream) & 0xFF;
                                    if ((b & 0x80) != 0) {
                                        log.warn("LocoNet message with opCode: {} ended early. Expected length: {} seen length: {} unexpected byte: {}", new Object[]{Integer.toHexString(opCode), len, i, Integer.toHexString(b)});
                                        opCode = b;
                                        throw new LocoNetMessageException();
                                    }
                                    msg.setElement(i, b);
                                }
                            }
                            catch (LocoNetMessageException e) {
                                msg = null;
                            }
                        }
                        if (!msg.checkParity()) {
                            log.warn("Ignore LocoNet packet with bad checksum: {}", (Object)msg.toString());
                            throw new LocoNetMessageException();
                        }
                        if (msg.equals(UhlenbrockPacketizer.this.lastMessage)) {
                            log.debug("We have our returned message and can send back out our next instruction");
                            UhlenbrockPacketizer.this.mCurrentState = 15;
                        }
                        log.debug("queue message for notification");
                        final LocoNetMessage thisMsg = msg;
                        final LnPacketizer thisTc = this.trafficController;
                        Runnable r = new Runnable(){
                            LocoNetMessage msgForLater;
                            LnPacketizer myTc;
                            {
                                this.msgForLater = thisMsg;
                                this.myTc = thisTc;
                            }

                            @Override
                            public void run() {
                                this.myTc.notify(this.msgForLater);
                            }
                        };
                        SwingUtilities.invokeLater(r);
                    }
                }
                catch (LocoNetMessageException e) {
                    log.warn("run: unexpected LocoNetMessageException: ", (Throwable)e);
                    continue;
                }
                catch (EOFException | InterruptedIOException e) {
                    continue;
                }
                catch (IOException e) {
                    log.debug("IOException, should only happen with HexFile", (Throwable)e);
                    log.debug("End of file");
                    UhlenbrockPacketizer.this.disconnectPort(UhlenbrockPacketizer.this.controller);
                    return;
                }
                catch (RuntimeException e) {
                    log.warn("run: unexpected Exception", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

