/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.usb_dcs210Plus;

import jmri.jmrix.AbstractPortController;
import jmri.jmrix.loconet.LnCommandStationType;
import jmri.jmrix.loconet.LnPacketizer;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.locobuffer.LocoBufferAdapter;
import jmri.jmrix.loconet.pr2.LnPr2Packetizer;
import jmri.jmrix.loconet.usb_dcs210Plus.Bundle;
import jmri.jmrix.loconet.usb_dcs210Plus.UsbDcs210PlusSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsbDcs210PlusAdapter
extends LocoBufferAdapter {
    private static final Logger log = LoggerFactory.getLogger(UsbDcs210PlusAdapter.class);

    public UsbDcs210PlusAdapter() {
        super(new UsbDcs210PlusSystemConnectionMemo());
        this.options.remove(this.option2Name);
        this.options.put(this.option2Name, new AbstractPortController.Option(Bundle.getMessage("CommandStationTypeLabel"), this.commandStationOptions(), false));
    }

    @Override
    protected void reportOpen(String portName) {
        log.info("Connecting USB DCS210Plus via {} {}", (Object)portName, (Object)this.currentSerialPort);
    }

    @Override
    public void configure() {
        this.setCommandStationType(this.getOptionState(this.option2Name));
        this.setTurnoutHandling(this.getOptionState(this.option3Name));
        if (this.commandStationType == LnCommandStationType.COMMAND_STATION_USB_DCS210Plus_ALONE) {
            LnPr2Packetizer packets = new LnPr2Packetizer(this.getSystemConnectionMemo());
            packets.connectPort(this);
            this.getSystemConnectionMemo().setLnTrafficController(packets);
            this.getSystemConnectionMemo().configureCommandStation(this.commandStationType, this.mTurnoutNoRetry, this.mTurnoutExtraSpace, this.mTranspondingAvailable, this.mInterrogateAtStart, this.mLoconetProtocolAutoDetect);
            this.getSystemConnectionMemo().configureManagersPR2();
            this.getSystemConnectionMemo().getSlotManager().serviceModeReplyDelay = 500;
            packets.startThreads();
            LocoNetMessage msg = new LocoNetMessage(6);
            msg.setOpCode(211);
            msg.setElement(1, 16);
            msg.setElement(2, 1);
            msg.setElement(3, 0);
            msg.setElement(4, 0);
            packets.sendLocoNetMessage(msg);
        } else {
            this.setTranspondingAvailable(this.getOptionState("TranspondingPresent"));
            this.setInterrogateOnStart(this.getOptionState("InterrogateOnStart"));
            this.setLoconetProtocolAutoDetect(this.getOptionState("LoconetProtocolAutoDetect"));
            LnPacketizer packets = this.getPacketizer(this.getOptionState(this.option4Name));
            packets.connectPort(this);
            this.getSystemConnectionMemo().setLnTrafficController(packets);
            this.getSystemConnectionMemo().configureCommandStation(this.commandStationType, this.mTurnoutNoRetry, this.mTurnoutExtraSpace, this.mTranspondingAvailable, this.mInterrogateAtStart, this.mLoconetProtocolAutoDetect);
            this.getSystemConnectionMemo().configureManagersMS100();
            this.getSystemConnectionMemo().getSlotManager().serviceModeReplyDelay = 500;
            packets.startThreads();
            LocoNetMessage msg = new LocoNetMessage(6);
            msg.setOpCode(211);
            msg.setElement(1, 16);
            msg.setElement(2, 0);
            msg.setElement(3, 0);
            msg.setElement(4, 0);
            packets.sendLocoNetMessage(msg);
        }
    }

    @Override
    public String[] validBaudRates() {
        return new String[]{"57,600 baud"};
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[]{57600};
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }

    public String[] commandStationOptions() {
        String[] retval = new String[this.commandStationNames.length + 1];
        retval[0] = LnCommandStationType.COMMAND_STATION_DCS210PLUS.getName();
        retval[1] = LnCommandStationType.COMMAND_STATION_USB_DCS210Plus_ALONE.getName();
        int count = 2;
        for (String commandStationName : this.commandStationNames) {
            if (commandStationName.equals(LnCommandStationType.COMMAND_STATION_DCS210PLUS.getName())) continue;
            retval[count++] = commandStationName;
        }
        return retval;
    }

    @Override
    public UsbDcs210PlusSystemConnectionMemo getSystemConnectionMemo() {
        LocoNetSystemConnectionMemo m = super.getSystemConnectionMemo();
        if (m instanceof UsbDcs210PlusSystemConnectionMemo) {
            return (UsbDcs210PlusSystemConnectionMemo)m;
        }
        log.error("Cannot cast the system connection memo to a UsbDcs210PlusSystemConnection Memo.");
        return null;
    }
}

