/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.maple;

import jmri.JmriException;
import jmri.Sensor;
import jmri.jmrix.maple.SerialReply;
import jmri.jmrix.maple.SerialTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputBits {
    private SerialTrafficController tc = null;
    static final int MAXSENSORS = 1000;
    private static int mNumInputBits = 48;
    private static int mTimeoutTime = 2000;
    private int lastUsedSensor = -1;
    protected Sensor[] sensorArray = new Sensor[1001];
    protected int[] sensorLastSetting = new int[1001];
    protected int[] sensorTempSetting = new int[1001];
    protected boolean[] sensorORedSetting = new boolean[1001];
    private static final Logger log = LoggerFactory.getLogger(InputBits.class);

    public InputBits(SerialTrafficController _tc) {
        for (int i = 0; i < 1001; ++i) {
            this.sensorArray[i] = null;
            this.sensorLastSetting[i] = 1;
            this.sensorTempSetting[i] = 1;
            this.sensorORedSetting[i] = false;
        }
        this.tc = _tc;
    }

    public static void setNumInputBits(int n) {
        mNumInputBits = n;
    }

    public static int getNumInputBits() {
        return mNumInputBits;
    }

    public static void setTimeoutTime(int n) {
        mTimeoutTime = n;
    }

    public static int getTimeoutTime() {
        return mTimeoutTime;
    }

    public int getLastSensor() {
        return this.lastUsedSensor;
    }

    public int getMaxSensors() {
        return 1000;
    }

    public void forceSensorsUnknown() {
        for (int i = 0; i <= this.lastUsedSensor; ++i) {
            if (this.sensorArray[i] == null) continue;
            this.sensorLastSetting[i] = 1;
            this.sensorTempSetting[i] = 1;
            this.sensorORedSetting[i] = false;
            try {
                this.sensorArray[i].setKnownState(1);
                continue;
            }
            catch (JmriException ex) {
                log.error("unexpected exception setting sensor i={}", (Object)i, (Object)ex);
            }
        }
    }

    public void markChanges(SerialReply l) {
        int begAddress = this.tc.getSavedPollAddress();
        int count = l.getNumDataElements() - 8;
        for (int i = 0; i < count; ++i) {
            boolean value;
            if (this.sensorArray[i + begAddress - 1] == null || !(value = (l.getElement(5 + i) & 1) != 0 ^ this.sensorArray[i + begAddress - 1].getInverted())) continue;
            this.sensorORedSetting[i + begAddress - 1] = true;
        }
    }

    public void makeChanges() {
        int i;
        try {
            for (i = 0; i <= this.lastUsedSensor; ++i) {
                if (this.sensorArray[i] == null) continue;
                boolean value = this.sensorORedSetting[i];
                if (value) {
                    if ((this.sensorTempSetting[i] == 2 || this.sensorTempSetting[i] == 1) && this.sensorLastSetting[i] != 2) {
                        this.sensorLastSetting[i] = 2;
                        this.sensorArray[i].setKnownState(2);
                    }
                    this.sensorTempSetting[i] = 2;
                    continue;
                }
                if ((this.sensorTempSetting[i] == 4 || this.sensorTempSetting[i] == 1) && this.sensorLastSetting[i] != 4) {
                    this.sensorLastSetting[i] = 4;
                    this.sensorArray[i].setKnownState(4);
                }
                this.sensorTempSetting[i] = 4;
            }
        }
        catch (JmriException e) {
            log.error("exception in makeChanges", (Throwable)e);
        }
        for (i = 0; i < this.lastUsedSensor; ++i) {
            this.sensorORedSetting[i] = false;
        }
    }

    public void registerSensor(Sensor s, int i) {
        if (i < 0 || i >= mNumInputBits) {
            log.error("Unexpected sensor ordinal in registerSensor: {}", (Object)Integer.toString(i + 1));
            return;
        }
        if (this.sensorArray[i] == null) {
            this.sensorArray[i] = s;
            if (this.lastUsedSensor < i) {
                this.lastUsedSensor = i;
            }
            this.sensorLastSetting[i] = 1;
            this.sensorTempSetting[i] = 1;
            this.sensorORedSetting[i] = false;
        }
    }
}

