/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.maple;

import jmri.jmrix.maple.SerialMessage;
import jmri.jmrix.maple.SerialTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputBits {
    private static int mSendDelay = 200;
    private static int mNumOutputBits = 98;
    protected byte[] outputArray = new byte[256];
    private static final Logger log = LoggerFactory.getLogger(OutputBits.class);

    public OutputBits(SerialTrafficController _tc) {
        for (int i = 0; i < 256; ++i) {
            this.outputArray[i] = 0;
        }
    }

    public static void setNumOutputBits(int n) {
        mNumOutputBits = n;
    }

    public static int getNumOutputBits() {
        return mNumOutputBits;
    }

    public static void setSendDelay(int n) {
        mSendDelay = n;
    }

    public static int getSendDelay() {
        return mSendDelay;
    }

    public void setOutputBit(int bitNumber, boolean state) {
        if (bitNumber > mNumOutputBits) {
            log.warn("Output bit out-of-range for configured bits");
            return;
        }
        int byteNumber = (bitNumber - 1) / 8;
        byte bit = (byte)(1 << (bitNumber - 1) % 8);
        if (state) {
            int n = byteNumber;
            this.outputArray[n] = (byte)(this.outputArray[n] & ~bit);
        } else {
            int n = byteNumber;
            this.outputArray[n] = (byte)(this.outputArray[n] | bit);
        }
    }

    public boolean getOutputBit(int bitNumber) {
        int byteNumber = (bitNumber - 1) / 8;
        if (byteNumber >= 256) {
            byteNumber = 255;
        }
        byte bit = (byte)(1 << (bitNumber - 1) % 8);
        byte testByte = this.outputArray[byteNumber];
        return (testByte = (byte)(testByte & bit)) == 0;
    }

    public SerialMessage createOutPacket(int startBitNum, int endBitNum) {
        int nBits = endBitNum - startBitNum + 1;
        if (nBits > 99) {
            log.error("Number of bits for this packet greater than 99 - {}", (Object)nBits);
            return null;
        }
        int sAdd = 1000 + startBitNum;
        SerialMessage m = new SerialMessage(14 + nBits);
        m.setElement(0, 2);
        m.setElement(1, 48);
        m.setElement(2, 48);
        m.setElement(3, 87);
        m.setElement(4, 67);
        m.setElement(5, 48 + sAdd / 1000);
        m.setElement(6, 48 + (sAdd - sAdd / 1000 * 1000) / 100);
        m.setElement(7, 48 + (sAdd - sAdd / 100 * 100) / 10);
        m.setElement(8, 48 + (sAdd - sAdd / 10 * 10));
        m.setElement(9, 48 + nBits / 10);
        m.setElement(10, 48 + (nBits - nBits / 10 * 10));
        for (int i = 0; i < nBits; ++i) {
            int j = i - i / 8 * 8;
            byte val = this.outputArray[i / 8];
            if (j == 0) {
                m.setElement(11 + i, (val & 1) != 0 ? 49 : 48);
                continue;
            }
            if (j == 1) {
                m.setElement(11 + i, (val & 2) != 0 ? 49 : 48);
                continue;
            }
            if (j == 2) {
                m.setElement(11 + i, (val & 4) != 0 ? 49 : 48);
                continue;
            }
            if (j == 3) {
                m.setElement(11 + i, (val & 8) != 0 ? 49 : 48);
                continue;
            }
            if (j == 4) {
                m.setElement(11 + i, (val & 0x10) != 0 ? 49 : 48);
                continue;
            }
            if (j == 5) {
                m.setElement(11 + i, (val & 0x20) != 0 ? 49 : 48);
                continue;
            }
            if (j == 6) {
                m.setElement(11 + i, (val & 0x40) != 0 ? 49 : 48);
                continue;
            }
            if (j != 7) continue;
            m.setElement(11 + i, (val & 0x80) != 0 ? 49 : 48);
        }
        m.setElement(11 + nBits, 3);
        m.setChecksum(12 + nBits);
        m.setTimeout(mSendDelay);
        m.setNoReply();
        return m;
    }
}

