/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.maple;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.Light;
import jmri.Manager;
import jmri.jmrix.maple.Bundle;
import jmri.jmrix.maple.MapleSystemConnectionMemo;
import jmri.jmrix.maple.SerialAddress;
import jmri.jmrix.maple.SerialLight;
import jmri.managers.AbstractLightManager;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialLightManager
extends AbstractLightManager {
    private static final Logger log = LoggerFactory.getLogger(SerialLightManager.class);

    public SerialLightManager(MapleSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public MapleSystemConnectionMemo getMemo() {
        return (MapleSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Light createNewLight(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        int bitNum = SerialAddress.getBitFromSystemName(systemName, this.getSystemPrefix());
        if (bitNum == 0) {
            throw new IllegalArgumentException("Invalid Bit from System Name: " + systemName);
        }
        String conflict = SerialAddress.isOutputBitFree(bitNum, this.getSystemPrefix());
        if (!conflict.isEmpty()) {
            log.error("Assignment conflict with '{}'. Light not created.", (Object)conflict);
            throw new IllegalArgumentException("The output bit, " + bitNum + ", is currently assigned to " + conflict);
        }
        String sysName = SerialAddress.normalizeSystemName(systemName, this.getSystemPrefix());
        if (sysName.isEmpty()) {
            log.error("error when normalizing system name {}", (Object)systemName);
            throw new IllegalArgumentException("Error when normalizing system name: " + systemName);
        }
        if (SerialAddress.validSystemNameFormat(systemName, 'L', this.getSystemPrefix()) == Manager.NameValidity.VALID) {
            SerialLight lgt = new SerialLight(sysName, userName, this.getMemo());
            if (!SerialAddress.validSystemNameConfig(sysName, 'L', this.getMemo())) {
                log.warn("Light system Name '{}' does not refer to configured hardware.", (Object)sysName);
                JmriJOptionPane.showMessageDialog(null, "WARNING - The Light just added, " + sysName + ", refers to an unconfigured output bit.", "Configuration Warning", 1);
            }
            return lgt;
        }
        log.error("Invalid Light system Name format: {}", (Object)systemName);
        throw new IllegalArgumentException("Invalid Light system Name format: " + systemName);
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) {
        return SerialAddress.validateSystemNameFormat(name, this, locale);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return SerialAddress.validSystemNameFormat(systemName, this.typeLetter(), this.getSystemPrefix());
    }

    @Override
    public boolean validSystemNameConfig(@Nonnull String systemName) {
        return SerialAddress.validSystemNameConfig(systemName, 'L', this.getMemo());
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddOutputEntryToolTip");
    }
}

