/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.maple;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInputStream;
import java.io.IOException;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRNodeTrafficController;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.maple.InputBits;
import jmri.jmrix.maple.OutputBits;
import jmri.jmrix.maple.SerialInterface;
import jmri.jmrix.maple.SerialListener;
import jmri.jmrix.maple.SerialMessage;
import jmri.jmrix.maple.SerialNode;
import jmri.jmrix.maple.SerialReply;
import jmri.jmrix.maple.SerialSensorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="multiple variables accessed outside synchronized core, which is quite suspicious, but code seems to interlock properly")
public class SerialTrafficController
extends AbstractMRNodeTrafficController
implements SerialInterface {
    private InputBits mInputBits = null;
    private OutputBits mOutputBits = null;
    SerialSensorManager mSensorManager = null;
    private boolean mNeedSend = true;
    private int mStartBitNumber = 1;
    private boolean mNeedAdditionalPollPacket = false;
    private int mStartPollAddress = 1;
    private int mSavedPollAddress = 1;
    private int mCurrentNodeIndexInPoll = -1;
    protected int wrTimeoutCount = 0;
    private static final Logger log = LoggerFactory.getLogger(SerialTrafficController.class);

    public SerialTrafficController() {
        this.init(0, 127);
        this.mWaitBeforePoll = 5;
        this.mInputBits = new InputBits(this);
        this.mOutputBits = new OutputBits(this);
    }

    public InputBits inputBits() {
        return this.mInputBits;
    }

    public OutputBits outputBits() {
        return this.mOutputBits;
    }

    @Override
    public synchronized void addSerialListener(SerialListener l) {
        this.addListener(l);
    }

    @Override
    public synchronized void removeSerialListener(SerialListener l) {
        this.removeListener(l);
    }

    public void initializeSerialNode(SerialNode node) {
    }

    @Override
    protected AbstractMRMessage enterProgMode() {
        log.warn("enterProgMode doesn't make sense for Maple serial");
        return null;
    }

    @Override
    protected AbstractMRMessage enterNormalMode() {
        return null;
    }

    @Override
    protected void forwardMessage(AbstractMRListener client, AbstractMRMessage m) {
        ((SerialListener)client).message((SerialMessage)m);
    }

    @Override
    protected void forwardReply(AbstractMRListener client, AbstractMRReply m) {
        ((SerialListener)client).reply((SerialReply)m);
    }

    public void setSensorManager(SerialSensorManager m) {
        this.mSensorManager = m;
    }

    @Override
    protected boolean getMustInit(int i) {
        return false;
    }

    public int getSavedPollAddress() {
        return this.mSavedPollAddress;
    }

    @Override
    protected synchronized AbstractMRMessage pollMessage() {
        if (this.getNumNodes() <= 0) {
            return null;
        }
        if (this.curSerialNodeIndex >= this.getNumNodes()) {
            this.curSerialNodeIndex = 0;
            this.mInputBits.makeChanges();
            this.mNeedSend = true;
            this.mStartBitNumber = 1;
        }
        if (this.mNeedSend) {
            int endBitNumber = this.mStartBitNumber + 98;
            if (endBitNumber > OutputBits.getNumOutputBits()) {
                endBitNumber = OutputBits.getNumOutputBits();
                this.mNeedSend = false;
            }
            if (endBitNumber == OutputBits.getNumOutputBits()) {
                this.mNeedSend = false;
            }
            SerialMessage m = this.mOutputBits.createOutPacket(this.mStartBitNumber, endBitNumber);
            this.mCurrentNodeIndexInPoll = -1;
            if (this.mNeedSend) {
                this.mStartBitNumber = endBitNumber + 1;
            }
            return m;
        }
        int count = 99;
        if (count > InputBits.getNumInputBits() - this.mStartPollAddress + 1) {
            count = InputBits.getNumInputBits() - this.mStartPollAddress + 1;
        }
        SerialMessage m = SerialMessage.getPoll(this.getNode(this.curSerialNodeIndex).getNodeAddress(), this.mStartPollAddress, count);
        this.mSavedPollAddress = this.mStartPollAddress;
        this.mCurrentNodeIndexInPoll = this.curSerialNodeIndex++;
        if (this.mStartPollAddress + count - 1 < InputBits.getNumInputBits()) {
            this.mNeedAdditionalPollPacket = true;
            this.mStartPollAddress += 99;
        } else {
            this.mNeedAdditionalPollPacket = false;
            this.mStartPollAddress = 1;
        }
        return m;
    }

    public int getWrTimeoutCount() {
        return this.wrTimeoutCount;
    }

    public void resetWrTimeoutCount() {
        this.wrTimeoutCount = 0;
    }

    @Override
    protected void handleTimeout(AbstractMRMessage m, AbstractMRListener l) {
        if (m.getElement(3) == 87 && m.getElement(4) == 67) {
            ++this.wrTimeoutCount;
        } else if (m.getElement(3) == 82 && m.getElement(4) == 67) {
            if (this.mNeedAdditionalPollPacket) {
                this.getNode(this.curSerialNodeIndex).handleTimeout(m, l);
            } else {
                this.getNode(this.curSerialNodeIndex - 1).handleTimeout(m, l);
            }
        } else {
            log.error("Timeout of unknown message - {}", (Object)m.toString());
        }
    }

    @Override
    protected void resetTimeout(AbstractMRMessage m) {
        if (this.mCurrentNodeIndexInPoll < 0) {
            this.wrTimeoutCount = 0;
        } else {
            this.getNode(this.mCurrentNodeIndexInPoll).resetTimeout(m);
        }
    }

    @Override
    protected AbstractMRListener pollReplyHandler() {
        return this.mSensorManager;
    }

    @Override
    public void sendSerialMessage(SerialMessage m, SerialListener reply) {
        this.sendMessage(m, reply);
    }

    @Override
    protected AbstractMRReply newReply() {
        return new SerialReply();
    }

    @Override
    protected boolean endOfMessage(AbstractMRReply msg) {
        log.error("Not using endOfMessage, should not be called");
        return false;
    }

    @Override
    public void loadChars(AbstractMRReply msg, DataInputStream istream) throws IOException {
        boolean first = true;
        for (int i = 0; i < msg.maxSize() - 1; ++i) {
            byte char1 = this.readByteProtected(istream);
            msg.setElement(i, char1 & 0xFF);
            if (first) {
                first = false;
                log.debug("start message with {}", (Object)char1);
            }
            if (char1 == 3) {
                log.debug("ETX ends message");
                char1 = this.readByteProtected(istream);
                msg.setElement(i + 1, char1 & 0xFF);
                char1 = this.readByteProtected(istream);
                msg.setElement(i + 2, char1 & 0xFF);
                break;
            }
            if (char1 == 6) {
                log.debug("ACK ends message");
                char1 = this.readByteProtected(istream);
                msg.setElement(++i, char1 & 0xFF);
                char1 = this.readByteProtected(istream);
                msg.setElement(++i, char1 & 0xFF);
                char1 = this.readByteProtected(istream);
                msg.setElement(++i, char1 & 0xFF);
                char1 = this.readByteProtected(istream);
                msg.setElement(++i, char1 & 0xFF);
                break;
            }
            if (char1 != 21) continue;
            log.debug("NAK ends message");
            char1 = this.readByteProtected(istream);
            msg.setElement(++i, char1 & 0xFF);
            char1 = this.readByteProtected(istream);
            msg.setElement(++i, char1 & 0xFF);
            char1 = this.readByteProtected(istream);
            msg.setElement(++i, char1 & 0xFF);
            char1 = this.readByteProtected(istream);
            msg.setElement(++i, char1 & 0xFF);
            char1 = this.readByteProtected(istream);
            msg.setElement(++i, char1 & 0xFF);
            break;
        }
    }

    @Override
    protected void waitForStartOfReply(DataInputStream istream) throws IOException {
    }

    @Override
    protected int addHeaderToOutput(byte[] msg, AbstractMRMessage m) {
        return 0;
    }

    @Override
    protected void addTrailerToOutput(byte[] msg, int offset, AbstractMRMessage m) {
    }

    @Override
    protected int lengthOfByteStream(AbstractMRMessage m) {
        int len = m.getNumDataElements();
        return len;
    }
}

