/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.maple.assignment;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jmri.jmrix.maple.InputBits;
import jmri.jmrix.maple.MapleSystemConnectionMemo;
import jmri.jmrix.maple.OutputBits;
import jmri.jmrix.maple.SerialAddress;
import jmri.jmrix.maple.SerialNode;
import jmri.jmrix.maple.assignment.Bundle;
import jmri.util.JmriJFrame;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListFrame
extends JmriJFrame {
    protected int numConfigNodes = 0;
    protected SerialNode[] configNodes = new SerialNode[128];
    protected int[] configNodeAddresses = new int[128];
    protected boolean inputSelected = false;
    protected SerialNode selNode = null;
    protected String selNodeID = "x";
    public int selNodeNum = 0;
    public int numBits = 48;
    public int numInputBits = 24;
    public int numOutputBits = 48;
    JLabel nodeLabel = new JLabel(Bundle.getMessage("NodeBoxLabel") + " ");
    JComboBox<String> nodeSelBox = new JComboBox();
    ButtonGroup bitTypeGroup = new ButtonGroup();
    JRadioButton inputBits = new JRadioButton(Bundle.getMessage("ShowInputButton") + "   ", false);
    JRadioButton outputBits = new JRadioButton(Bundle.getMessage("ShowOutputButton"), true);
    JLabel nodeInfoText = new JLabel(Bundle.getMessage("NodeInfoText"));
    protected JPanel assignmentPanel = null;
    protected Border inputBorder = BorderFactory.createEtchedBorder();
    protected Border inputBorderTitled = BorderFactory.createTitledBorder(this.inputBorder, Bundle.getMessage("AssignmentPanelInputName"));
    protected Border outputBorder = BorderFactory.createEtchedBorder();
    protected Border outputBorderTitled = BorderFactory.createTitledBorder(this.outputBorder, Bundle.getMessage("AssignmentPanelOutputName"));
    protected JTable assignmentTable = null;
    protected TableModel assignmentListModel = null;
    JButton printButton = new JButton(Bundle.getMessage("PrintButtonText"));
    ListFrame curFrame;
    private MapleSystemConnectionMemo _memo = null;
    private final String[] assignmentTableColumnNames = new String[]{Bundle.getMessage("HeadingBit"), Bundle.getMessage("HeadingAddress"), Bundle.getMessage("HeadingSystemName"), Bundle.getMessage("HeadingUserName")};
    private static final Logger log = LoggerFactory.getLogger(ListFrame.class);

    public ListFrame(MapleSystemConnectionMemo memo) {
        this.curFrame = this;
        this._memo = memo;
    }

    @Override
    public void initComponents() {
        this.setTitle(Bundle.getMessage("WindowTitle"));
        this.setSize(500, 400);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        this.initializeNodes();
        this.nodeSelBox.setEditable(false);
        if (this.numConfigNodes > 0) {
            this.nodeSelBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ListFrame.this.displayNodeInfo((String)ListFrame.this.nodeSelBox.getSelectedItem());
                }
            });
            this.inputBits.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (!ListFrame.this.inputSelected) {
                        ListFrame.this.inputSelected = true;
                        ListFrame.this.displayNodeInfo(ListFrame.this.selNodeID);
                    }
                }
            });
            this.outputBits.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (ListFrame.this.inputSelected) {
                        ListFrame.this.inputSelected = false;
                        ListFrame.this.displayNodeInfo(ListFrame.this.selNodeID);
                    }
                }
            });
        } else {
            this.nodeInfoText.setText(Bundle.getMessage("NoNodesError"));
        }
        this.nodeSelBox.setToolTipText(Bundle.getMessage("NodeBoxTip"));
        this.inputBits.setToolTipText(Bundle.getMessage("ShowInputTip"));
        this.outputBits.setToolTipText(Bundle.getMessage("ShowOutputTip"));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 1));
        JPanel panel11 = new JPanel();
        panel11.add(this.nodeLabel);
        panel11.add(this.nodeSelBox);
        this.bitTypeGroup.add(this.outputBits);
        this.bitTypeGroup.add(this.inputBits);
        panel11.add(this.inputBits);
        panel11.add(this.outputBits);
        JPanel panel12 = new JPanel();
        panel12.add(this.nodeInfoText);
        panel1.add(panel11);
        panel1.add(panel12);
        Border panel1Border = BorderFactory.createEtchedBorder();
        TitledBorder panel1Titled = BorderFactory.createTitledBorder(panel1Border, Bundle.getMessage("NodePanelName"));
        panel1.setBorder(panel1Titled);
        contentPane.add(panel1);
        if (this.numConfigNodes > 0) {
            this.assignmentPanel = new JPanel();
            this.assignmentPanel.setLayout(new BoxLayout(this.assignmentPanel, 1));
            this.assignmentListModel = new AssignmentTableModel();
            this.assignmentTable = new JTable(this.assignmentListModel);
            this.assignmentTable.setRowSelectionAllowed(false);
            this.assignmentTable.setPreferredScrollableViewportSize(new Dimension(300, 350));
            TableColumnModel assignmentColumnModel = this.assignmentTable.getColumnModel();
            TableColumn bitColumn = assignmentColumnModel.getColumn(0);
            bitColumn.setMinWidth(20);
            bitColumn.setMaxWidth(40);
            bitColumn.setResizable(true);
            TableColumn addressColumn = assignmentColumnModel.getColumn(1);
            addressColumn.setMinWidth(40);
            addressColumn.setMaxWidth(85);
            addressColumn.setResizable(true);
            TableColumn sysColumn = assignmentColumnModel.getColumn(2);
            sysColumn.setMinWidth(75);
            sysColumn.setMaxWidth(100);
            sysColumn.setResizable(true);
            TableColumn userColumn = assignmentColumnModel.getColumn(3);
            userColumn.setMinWidth(90);
            userColumn.setMaxWidth(450);
            userColumn.setResizable(true);
            JScrollPane assignmentScrollPane = new JScrollPane(this.assignmentTable);
            this.assignmentPanel.add((Component)assignmentScrollPane, "Center");
            if (this.inputSelected) {
                this.assignmentPanel.setBorder(this.inputBorderTitled);
            } else {
                this.assignmentPanel.setBorder(this.outputBorderTitled);
            }
            contentPane.add(this.assignmentPanel);
        }
        JPanel panel3 = new JPanel();
        panel3.setLayout(new FlowLayout());
        this.printButton.setVisible(true);
        this.printButton.setToolTipText(Bundle.getMessage("PrintButtonTip"));
        if (this.numConfigNodes > 0) {
            this.printButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ListFrame.this.printButtonActionPerformed(e);
                }
            });
        }
        panel3.add(this.printButton);
        contentPane.add(panel3);
        if (this.numConfigNodes > 0) {
            this.displayNodeInfo((String)this.nodeSelBox.getSelectedItem());
        }
        this.addHelpMenu("package.jmri.jmrix.maple.assignment.ListFrame", true);
        this.pack();
    }

    public void initializeNodes() {
        String str = "";
        for (int i = 0; i < 128; ++i) {
            this.configNodeAddresses[i] = -1;
            this.configNodes[i] = null;
        }
        SerialNode node = (SerialNode)this._memo.getTrafficController().getNode(0);
        int index = 1;
        while (node != null) {
            this.configNodes[this.numConfigNodes] = node;
            this.configNodeAddresses[this.numConfigNodes] = node.getNodeAddress();
            str = Integer.toString(this.configNodeAddresses[this.numConfigNodes]);
            this.nodeSelBox.addItem(str);
            if (index == 1) {
                this.selNode = node;
                this.selNodeNum = this.configNodeAddresses[this.numConfigNodes];
                this.selNodeID = "y";
            }
            ++this.numConfigNodes;
            node = (SerialNode)this._memo.getTrafficController().getNode(index);
            ++index;
        }
    }

    public void displayNodeInfo(String nodeID) {
        if (!nodeID.equals(this.selNodeID)) {
            int nAdd = Integer.parseInt(nodeID);
            SerialNode s = null;
            for (int k = 0; k < this.numConfigNodes; ++k) {
                if (nAdd != this.configNodeAddresses[k]) continue;
                s = this.configNodes[k];
            }
            if (s == null) {
                log.error("Cannot find Node {} in list of configured Nodes.", (Object)nodeID);
                return;
            }
            this.selNodeID = nodeID;
            this.selNode = s;
            this.selNodeNum = nAdd;
            this.numInputBits = InputBits.getNumInputBits();
            this.numOutputBits = OutputBits.getNumOutputBits();
            this.nodeInfoText.setText(" - " + Bundle.getMessage("BitsInfoText", this.numInputBits, this.numOutputBits));
        }
        if (this.inputSelected) {
            this.numBits = this.numInputBits;
            this.assignmentPanel.setBorder(this.inputBorderTitled);
        } else {
            this.numBits = this.numOutputBits;
            this.assignmentPanel.setBorder(this.outputBorderTitled);
        }
        ((AssignmentTableModel)this.assignmentListModel).fireTableDataChanged();
    }

    public void printButtonActionPerformed(ActionEvent e) {
        int[] colWidth = new int[4];
        TableColumnModel assignmentColumnModel = this.assignmentTable.getColumnModel();
        colWidth[0] = assignmentColumnModel.getColumn(0).getWidth();
        colWidth[1] = assignmentColumnModel.getColumn(1).getWidth();
        colWidth[2] = assignmentColumnModel.getColumn(2).getWidth();
        colWidth[3] = assignmentColumnModel.getColumn(3).getWidth();
        String head = this.inputSelected ? Bundle.getMessage("AssignmentPanelInputName") + " - " + Bundle.getMessage("NodeBoxLabel") + " " + this.selNodeID : Bundle.getMessage("AssignmentPanelOutputName") + " - " + Bundle.getMessage("NodeBoxLabel") + " " + this.selNodeID;
        HardcopyWriter writer = null;
        try {
            writer = new HardcopyWriter(this.curFrame, head, 10, 0.8, 0.5, 0.5, 0.5, false);
        }
        catch (HardcopyWriter.PrintCanceledException ex) {
            return;
        }
        writer.increaseLineSpacing(20);
        ((AssignmentTableModel)this.assignmentListModel).printTable(writer, colWidth);
    }

    public class AssignmentTableModel
    extends AbstractTableModel {
        private String free = Bundle.getMessage("AssignmentFree");
        private int curRow = -1;
        private String curRowSysName = "";
        public static final int BIT_COLUMN = 0;
        public static final int ADDRESS_COLUMN = 1;
        public static final int SYSNAME_COLUMN = 2;
        public static final int USERNAME_COLUMN = 3;

        @Override
        public String getColumnName(int c) {
            return ListFrame.this.assignmentTableColumnNames[c];
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return false;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return ListFrame.this.numBits;
        }

        @Override
        public Object getValueAt(int r, int c) {
            if (c == 0) {
                return Integer.toString(r + 1);
            }
            if (c == 1) {
                if (ListFrame.this.inputSelected) {
                    return Integer.toString(r + 1);
                }
                return Integer.toString(r + 1001);
            }
            if (c == 2) {
                String sName = null;
                if (this.curRow != r) {
                    sName = ListFrame.this.inputSelected ? SerialAddress.isInputBitFree(r + 1, ListFrame.this._memo.getSystemPrefix()) : SerialAddress.isOutputBitFree(r + 1, ListFrame.this._memo.getSystemPrefix());
                    this.curRow = r;
                    this.curRowSysName = sName;
                } else {
                    sName = this.curRowSysName;
                }
                if (sName == null) {
                    return this.free;
                }
                return sName;
            }
            if (c == 3) {
                String sName = null;
                if (this.curRow != r) {
                    sName = ListFrame.this.inputSelected ? SerialAddress.isInputBitFree(r + 1, ListFrame.this._memo.getSystemPrefix()) : SerialAddress.isOutputBitFree(r + 1, ListFrame.this._memo.getSystemPrefix());
                    this.curRow = r;
                    this.curRowSysName = sName;
                } else {
                    sName = this.curRowSysName;
                }
                if (sName == null) {
                    return "";
                }
                return SerialAddress.getUserNameFromSystemName(sName, ListFrame.this._memo.getSystemPrefix());
            }
            return "";
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
        }

        public void printTable(HardcopyWriter w, int[] colWidth) {
            int[] columnSize = new int[4];
            int charPerLine = w.getCharactersPerLine();
            int tableLineWidth = 0;
            int totalColWidth = 0;
            for (int j = 0; j < 4; ++j) {
                totalColWidth += colWidth[j];
            }
            float ratio = (float)charPerLine / (float)totalColWidth;
            for (int j = 0; j < 4; ++j) {
                columnSize[j] = (int)((float)colWidth[j] * ratio) - 1;
                tableLineWidth += columnSize[j] + 1;
            }
            w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), tableLineWidth);
            String[] columnStrings = new String[4];
            for (int i = 0; i < 4; ++i) {
                columnStrings[i] = this.getColumnName(i);
            }
            w.setFontStyle(1);
            this.printColumns(w, columnStrings, columnSize);
            w.setFontStyle(0);
            w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), tableLineWidth);
            String[] spaces = new String[4];
            for (int k = 0; k < 4; ++k) {
                spaces[k] = "";
                for (int i = 0; i < columnSize[k]; ++i) {
                    spaces[k] = spaces[k] + " ";
                }
            }
            for (int i = 0; i < this.getRowCount(); ++i) {
                for (int j = 0; j < 4; ++j) {
                    columnStrings[j] = this.getValueAt(i, j) == null ? spaces[j] : (String)this.getValueAt(i, j);
                }
                this.printColumns(w, columnStrings, columnSize);
                w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), tableLineWidth);
            }
            w.close();
        }

        protected void printColumns(HardcopyWriter w, String[] columnStrings, int[] columnSize) {
            Object columnString = "";
            StringBuilder lineString = new StringBuilder("");
            StringBuilder[] spaces = new StringBuilder[4];
            for (int k = 0; k < 4; ++k) {
                spaces[k] = new StringBuilder("");
                for (int i = 0; i < columnSize[k]; ++i) {
                    spaces[k].append(" ");
                }
            }
            boolean complete = false;
            while (!complete) {
                int k;
                complete = true;
                for (int i = 0; i < 4; ++i) {
                    if (columnStrings[i].length() > columnSize[i]) {
                        boolean noWord = true;
                        for (k = columnSize[i]; k >= 1; --k) {
                            if (!columnStrings[i].substring(k - 1, k).equals(" ") && !columnStrings[i].substring(k - 1, k).equals("-") && !columnStrings[i].substring(k - 1, k).equals("_")) continue;
                            columnString = columnStrings[i].substring(0, k) + spaces[i].substring(columnStrings[i].substring(0, k).length());
                            columnStrings[i] = columnStrings[i].substring(k);
                            noWord = false;
                            complete = false;
                            break;
                        }
                        if (noWord) {
                            columnString = columnStrings[i].substring(0, columnSize[i]);
                            columnStrings[i] = columnStrings[i].substring(columnSize[i]);
                            complete = false;
                        }
                    } else {
                        columnString = columnStrings[i] + spaces[i].substring(columnStrings[i].length());
                        columnStrings[i] = "";
                    }
                    lineString.append((String)columnString).append(" ");
                }
                try {
                    w.write(lineString.toString());
                    int iLine = w.getCurrentLineNumber();
                    int i = 0;
                    k = 0;
                    while (i < w.getCharactersPerLine()) {
                        w.write(iLine, i, iLine + 1, i);
                        i = k < 4 ? i + columnSize[k] + 1 : w.getCharactersPerLine();
                        ++k;
                    }
                    w.write("\n");
                    lineString = new StringBuilder("");
                }
                catch (IOException e) {
                    log.warn("error during printing:", (Throwable)e);
                }
            }
        }
    }
}

