/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.maple.nodeconfig;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import jmri.InstanceManager;
import jmri.configurexml.ShutdownPreferences;
import jmri.jmrix.maple.InputBits;
import jmri.jmrix.maple.MapleSystemConnectionMemo;
import jmri.jmrix.maple.OutputBits;
import jmri.jmrix.maple.SerialNode;
import jmri.jmrix.maple.nodeconfig.Bundle;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJOptionPane;

public class NodeConfigFrame
extends JmriJFrame {
    protected JSpinner nodeAddrSpinner;
    protected JLabel nodeAddrStatic = new JLabel("000");
    protected JTextField pollTimeoutField = new JTextField(3);
    protected JTextField sendDelayField = new JTextField(3);
    protected JTextField numInputField = new JTextField(4);
    protected JTextField numOutputField = new JTextField(4);
    protected JButton addButton = new JButton(Bundle.getMessage("ButtonAdd"));
    protected JButton editButton = new JButton(Bundle.getMessage("ButtonEdit"));
    protected JButton deleteButton = new JButton(Bundle.getMessage("ButtonDelete"));
    protected JButton doneButton = new JButton(Bundle.getMessage("ButtonDone"));
    protected JButton updateButton = new JButton(Bundle.getMessage("ButtonUpdate"));
    protected JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
    protected JLabel statusText1 = new JLabel();
    protected JLabel statusText2 = new JLabel();
    protected JLabel statusText3 = new JLabel();
    protected JPanel panel2 = new JPanel();
    protected JPanel panel2a = new JPanel();
    protected boolean changedNode = false;
    protected boolean editMode = false;
    private boolean checkEnabled = InstanceManager.getDefault(ShutdownPreferences.class).isStoreCheckEnabled();
    protected SerialNode curNode = null;
    protected int nodeAddress = 0;
    protected int pollTimeoutTime = 2000;
    protected int sendDelay = 200;
    protected int inputBits = 40;
    protected int outputBits = 40;
    protected boolean errorInStatus1 = false;
    protected boolean errorInStatus2 = false;
    protected String stdStatus1 = Bundle.getMessage("NotesStd1");
    protected String stdStatus2 = Bundle.getMessage("NotesStd2");
    protected String stdStatus3 = Bundle.getMessage("NotesStd3");
    protected String editStatus1 = Bundle.getMessage("NotesEdit1");
    protected String editStatus2 = Bundle.getMessage("NotesEdit2");
    protected String editStatus3 = Bundle.getMessage("NotesEdit3");
    private MapleSystemConnectionMemo _memo = null;

    public NodeConfigFrame(MapleSystemConnectionMemo memo) {
        this._memo = memo;
        this.addHelpMenu("package.jmri.jmrix.maple.nodeconfig.NodeConfigFrame", true);
    }

    @Override
    public void initComponents() {
        this.setTitle(Bundle.getMessage("WindowTitle"));
        this.inputBits = InputBits.getNumInputBits();
        this.pollTimeoutTime = InputBits.getTimeoutTime();
        this.outputBits = OutputBits.getNumOutputBits();
        this.sendDelay = OutputBits.getSendDelay();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 1));
        JPanel panel11 = new JPanel();
        panel11.setLayout(new FlowLayout());
        panel11.add(new JLabel(Bundle.getMessage("LabelNodeAddress") + " "));
        this.nodeAddrSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 99, 1));
        panel11.add(this.nodeAddrSpinner);
        this.nodeAddrSpinner.setToolTipText(Bundle.getMessage("TipNodeAddress"));
        panel11.add(this.nodeAddrStatic);
        this.nodeAddrStatic.setVisible(false);
        JPanel panel12 = new JPanel();
        panel12.setLayout(new FlowLayout());
        panel12.add(new JLabel(Bundle.getMessage("LabelPollTimeout") + " "));
        panel12.add(this.pollTimeoutField);
        panel12.add(new JLabel(Bundle.getMessage("LabelMilliseconds")));
        this.pollTimeoutField.setToolTipText(Bundle.getMessage("TipPollTimeout"));
        this.pollTimeoutField.setText("" + this.pollTimeoutTime);
        JPanel panel120 = new JPanel();
        panel120.setLayout(new FlowLayout());
        panel120.add(new JLabel(Bundle.getMessage("LabelSendDelay") + " "));
        panel120.add(this.sendDelayField);
        panel120.add(new JLabel(Bundle.getMessage("LabelMilliseconds")));
        this.sendDelayField.setToolTipText(Bundle.getMessage("TipSendDelay"));
        this.sendDelayField.setText("" + this.sendDelay);
        JPanel panel14 = new JPanel();
        panel14.setLayout(new FlowLayout());
        panel14.add(new JLabel(Bundle.getMessage("LabelNumInputBits") + " "));
        panel14.add(this.numInputField);
        this.numInputField.setToolTipText(Bundle.getMessage("TipInputBits"));
        this.numInputField.setText("" + this.inputBits);
        JPanel panel15 = new JPanel();
        panel15.setLayout(new FlowLayout());
        panel15.add(new JLabel(Bundle.getMessage("LabelNumOutputBits") + " "));
        panel15.add(this.numOutputField);
        this.numOutputField.setToolTipText(Bundle.getMessage("TipOutputBits"));
        this.numOutputField.setText("" + this.outputBits);
        panel1.add(panel11);
        panel1.add(panel12);
        panel1.add(panel120);
        panel1.add(panel14);
        panel1.add(panel15);
        contentPane.add(panel1);
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 1));
        JPanel panel31 = new JPanel();
        panel31.setLayout(new FlowLayout());
        this.statusText1.setText(this.stdStatus1);
        this.statusText1.setVisible(true);
        panel31.add(this.statusText1);
        JPanel panel32 = new JPanel();
        panel32.setLayout(new FlowLayout());
        this.statusText2.setText(this.stdStatus2);
        this.statusText2.setVisible(true);
        panel32.add(this.statusText2);
        JPanel panel33 = new JPanel();
        panel33.setLayout(new FlowLayout());
        this.statusText3.setText(this.stdStatus3);
        this.statusText3.setVisible(true);
        panel33.add(this.statusText3);
        panel3.add(panel31);
        panel3.add(panel32);
        panel3.add(panel33);
        Border panel3Border = BorderFactory.createEtchedBorder();
        TitledBorder panel3Titled = BorderFactory.createTitledBorder(panel3Border, Bundle.getMessage("BoxLabelNotes"));
        panel3.setBorder(panel3Titled);
        contentPane.add(panel3);
        JPanel panel4 = new JPanel();
        panel4.setLayout(new FlowLayout());
        this.addButton.setText(Bundle.getMessage("ButtonAdd"));
        this.addButton.setVisible(true);
        this.addButton.setToolTipText(Bundle.getMessage("TipAddButton"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeConfigFrame.this.addButtonActionPerformed();
            }
        });
        panel4.add(this.addButton);
        this.editButton.setText(Bundle.getMessage("ButtonEdit"));
        this.editButton.setVisible(true);
        this.editButton.setToolTipText(Bundle.getMessage("TipEditButton"));
        panel4.add(this.editButton);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeConfigFrame.this.editButtonActionPerformed();
            }
        });
        panel4.add(this.deleteButton);
        this.deleteButton.setText(Bundle.getMessage("ButtonDelete"));
        this.deleteButton.setVisible(true);
        this.deleteButton.setToolTipText(Bundle.getMessage("TipDeleteButton"));
        panel4.add(this.deleteButton);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeConfigFrame.this.deleteButtonActionPerformed();
            }
        });
        panel4.add(this.doneButton);
        this.doneButton.setText(Bundle.getMessage("ButtonDone"));
        this.doneButton.setVisible(true);
        this.doneButton.setToolTipText(Bundle.getMessage("TipDoneButton"));
        panel4.add(this.doneButton);
        this.doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeConfigFrame.this.doneButtonActionPerformed();
            }
        });
        panel4.add(this.updateButton);
        this.updateButton.setText(Bundle.getMessage("ButtonUpdate"));
        this.updateButton.setVisible(true);
        this.updateButton.setToolTipText(Bundle.getMessage("TipUpdateButton"));
        panel4.add(this.updateButton);
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeConfigFrame.this.updateButtonActionPerformed();
            }
        });
        this.updateButton.setVisible(false);
        panel4.add(this.cancelButton);
        this.cancelButton.setText(Bundle.getMessage("ButtonCancel"));
        this.cancelButton.setVisible(true);
        this.cancelButton.setToolTipText(Bundle.getMessage("TipCancelButton"));
        panel4.add(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeConfigFrame.this.cancelButtonActionPerformed();
            }
        });
        this.cancelButton.setVisible(false);
        contentPane.add(panel4);
        this.pack();
    }

    public void addButtonActionPerformed() {
        int nodeAddress = this.readNodeAddress();
        if (nodeAddress < 0) {
            return;
        }
        this.curNode = (SerialNode)this._memo.getTrafficController().getNodeFromAddress(nodeAddress);
        if (this.curNode != null) {
            this.statusText1.setText(Bundle.getMessage("Error1", Integer.toString(nodeAddress)));
            this.statusText1.setVisible(true);
            this.errorInStatus1 = true;
            this.resetNotes2();
            return;
        }
        if (!this.readPollTimeout()) {
            return;
        }
        if (!this.readSendDelay()) {
            return;
        }
        if (!this.readNumInputBits()) {
            return;
        }
        if (!this.readNumOutputBits()) {
            return;
        }
        this.curNode = new SerialNode(nodeAddress, 0, this._memo.getTrafficController());
        this.setNodeParameters();
        this.resetNotes();
        this.changedNode = true;
        this.statusText1.setText(Bundle.getMessage("FeedBackAdd") + " " + Integer.toString(nodeAddress));
        this.errorInStatus1 = true;
    }

    public void editButtonActionPerformed() {
        this.nodeAddress = this.readNodeAddress();
        if (this.nodeAddress <= 0) {
            return;
        }
        this.curNode = (SerialNode)this._memo.getTrafficController().getNodeFromAddress(this.nodeAddress);
        if (this.curNode == null) {
            this.statusText1.setText(Bundle.getMessage("Error4"));
            this.statusText1.setVisible(true);
            this.errorInStatus1 = true;
            this.resetNotes2();
            return;
        }
        this.nodeAddrStatic.setText(Integer.toString(this.nodeAddress));
        this.nodeAddrSpinner.setVisible(false);
        this.nodeAddrStatic.setVisible(true);
        this.inputBits = InputBits.getNumInputBits();
        this.numInputField.setText(Integer.toString(this.inputBits));
        this.outputBits = OutputBits.getNumOutputBits();
        this.numOutputField.setText(Integer.toString(this.outputBits));
        this.pollTimeoutTime = InputBits.getTimeoutTime();
        this.pollTimeoutField.setText(Integer.toString(this.pollTimeoutTime));
        this.sendDelay = OutputBits.getSendDelay();
        this.sendDelayField.setText(Integer.toString(this.sendDelay));
        this.editMode = true;
        this.addButton.setVisible(false);
        this.editButton.setVisible(false);
        this.deleteButton.setVisible(false);
        this.doneButton.setVisible(false);
        this.updateButton.setVisible(true);
        this.cancelButton.setVisible(true);
        this.statusText1.setText(this.editStatus1);
        this.statusText2.setText(this.editStatus2);
        this.statusText3.setText(this.editStatus3);
    }

    public void deleteButtonActionPerformed() {
        int nodeAddress = this.readNodeAddress();
        if (nodeAddress < 0) {
            return;
        }
        this.curNode = (SerialNode)this._memo.getTrafficController().getNodeFromAddress(nodeAddress);
        if (this.curNode == null) {
            this.statusText1.setText(Bundle.getMessage("Error4"));
            this.statusText1.setVisible(true);
            this.errorInStatus1 = true;
            this.resetNotes2();
            return;
        }
        if (0 == JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("ConfirmDelete1") + " " + nodeAddress + "?", Bundle.getMessage("ConfirmDeleteTitle"), 2, 2)) {
            this._memo.getTrafficController().deleteNode(nodeAddress);
            this.resetNotes();
            this.statusText1.setText(Bundle.getMessage("FeedBackDelete") + " " + Integer.toString(nodeAddress));
            this.errorInStatus1 = true;
            this.changedNode = true;
        } else {
            this.resetNotes();
        }
    }

    public void doneButtonActionPerformed() {
        if (this.editMode) {
            this.editMode = false;
            this.curNode = null;
            this.addButton.setVisible(true);
            this.editButton.setVisible(true);
            this.deleteButton.setVisible(true);
            this.doneButton.setVisible(true);
            this.updateButton.setVisible(false);
            this.cancelButton.setVisible(false);
            this.nodeAddrSpinner.setVisible(true);
            this.nodeAddrStatic.setVisible(false);
        }
        if (this.changedNode && !this.checkEnabled) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("ReminderNode1") + "\n" + Bundle.getMessage("Reminder2"), Bundle.getMessage("ReminderTitle"), 1);
        }
        this.setVisible(false);
        this.dispose();
    }

    public void updateButtonActionPerformed() {
        if (!this.readPollTimeout()) {
            return;
        }
        if (!this.readSendDelay()) {
            return;
        }
        if (!this.readNumInputBits()) {
            return;
        }
        if (!this.readNumOutputBits()) {
            return;
        }
        this.setNodeParameters();
        this.changedNode = true;
        this.editMode = false;
        this.curNode = null;
        this.addButton.setVisible(true);
        this.editButton.setVisible(true);
        this.deleteButton.setVisible(true);
        this.doneButton.setVisible(true);
        this.updateButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.nodeAddrSpinner.setVisible(true);
        this.nodeAddrStatic.setVisible(false);
        this.statusText2.setText(this.stdStatus2);
        this.statusText3.setText(this.stdStatus3);
        this.statusText1.setText(Bundle.getMessage("FeedBackUpdate") + " " + Integer.toString(this.nodeAddress));
        this.errorInStatus1 = true;
    }

    public void cancelButtonActionPerformed() {
        this.editMode = false;
        this.curNode = null;
        this.addButton.setVisible(true);
        this.editButton.setVisible(true);
        this.deleteButton.setVisible(true);
        this.doneButton.setVisible(true);
        this.updateButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.nodeAddrSpinner.setVisible(true);
        this.nodeAddrStatic.setVisible(false);
        this.statusText1.setText(this.stdStatus1);
        this.statusText2.setText(this.stdStatus2);
        this.statusText3.setText(this.stdStatus3);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.doneButtonActionPerformed();
        super.windowClosing(e);
    }

    void setNodeParameters() {
        InputBits.setTimeoutTime(this.pollTimeoutTime);
        OutputBits.setSendDelay(this.sendDelay);
        InputBits.setNumInputBits(this.inputBits);
        OutputBits.setNumOutputBits(this.outputBits);
    }

    private void resetNotes() {
        if (this.errorInStatus1) {
            if (this.editMode) {
                this.statusText1.setText(this.editStatus1);
            } else {
                this.statusText1.setText(this.stdStatus1);
            }
            this.errorInStatus1 = false;
        }
        this.resetNotes2();
    }

    private void resetNotes2() {
        if (this.errorInStatus2) {
            if (this.editMode) {
                this.statusText1.setText(this.editStatus2);
            } else {
                this.statusText2.setText(this.stdStatus2);
            }
            this.errorInStatus2 = false;
        }
    }

    private int readNodeAddress() {
        return (Integer)this.nodeAddrSpinner.getValue();
    }

    protected boolean readPollTimeout() {
        try {
            this.pollTimeoutTime = Integer.parseInt(this.pollTimeoutField.getText());
        }
        catch (Exception e) {
            this.statusText1.setText(Bundle.getMessage("Error7"));
            this.statusText1.setVisible(true);
            this.pollTimeoutTime = 0;
            this.errorInStatus1 = true;
            this.resetNotes2();
            return false;
        }
        if (this.pollTimeoutTime <= 0) {
            this.statusText1.setText(Bundle.getMessage("Error8"));
            this.statusText1.setVisible(true);
            this.pollTimeoutTime = 0;
            this.errorInStatus1 = true;
            this.resetNotes2();
            return false;
        }
        if (this.pollTimeoutTime > 10000) {
            this.statusText1.setText(Bundle.getMessage("Error9"));
            this.statusText1.setVisible(true);
            this.pollTimeoutTime = 0;
            this.errorInStatus1 = true;
            this.resetNotes2();
            return false;
        }
        return true;
    }

    protected boolean readSendDelay() {
        try {
            this.sendDelay = Integer.parseInt(this.sendDelayField.getText());
        }
        catch (Exception e) {
            this.statusText1.setText(Bundle.getMessage("Error19"));
            this.statusText1.setVisible(true);
            this.sendDelay = 0;
            this.errorInStatus1 = true;
            this.resetNotes2();
            return false;
        }
        if (this.sendDelay < 0) {
            this.statusText1.setText(Bundle.getMessage("Error20"));
            this.statusText1.setVisible(true);
            this.sendDelay = 0;
            this.errorInStatus1 = true;
            this.resetNotes2();
            return false;
        }
        if (this.sendDelay > 65535) {
            this.statusText1.setText(Bundle.getMessage("Error21"));
            this.statusText1.setVisible(true);
            this.sendDelay = 0;
            this.errorInStatus1 = true;
            this.resetNotes2();
            return false;
        }
        return true;
    }

    protected boolean readNumInputBits() {
        try {
            this.inputBits = Integer.parseInt(this.numInputField.getText());
        }
        catch (Exception e) {
            this.statusText1.setText(Bundle.getMessage("Error10"));
            this.statusText1.setVisible(true);
            this.inputBits = 0;
            this.errorInStatus1 = true;
            this.resetNotes2();
            return false;
        }
        if (this.inputBits <= 0) {
            this.statusText1.setText(Bundle.getMessage("Error11"));
            this.statusText1.setVisible(true);
            this.inputBits = 0;
            this.errorInStatus1 = true;
            this.resetNotes2();
            return false;
        }
        if (this.inputBits > 1000) {
            this.statusText1.setText(Bundle.getMessage("Error12"));
            this.statusText1.setVisible(true);
            this.inputBits = 0;
            this.errorInStatus1 = true;
            this.resetNotes2();
            return false;
        }
        return true;
    }

    protected boolean readNumOutputBits() {
        try {
            this.outputBits = Integer.parseInt(this.numOutputField.getText());
        }
        catch (Exception e) {
            this.statusText1.setText(Bundle.getMessage("Error13"));
            this.statusText1.setVisible(true);
            this.outputBits = 0;
            this.errorInStatus1 = true;
            this.resetNotes2();
            return false;
        }
        if (this.outputBits <= 0) {
            this.statusText1.setText(Bundle.getMessage("Error14"));
            this.statusText1.setVisible(true);
            this.outputBits = 0;
            this.errorInStatus1 = true;
            this.resetNotes2();
            return false;
        }
        if (this.outputBits > 8000) {
            this.statusText1.setText(Bundle.getMessage("Error15"));
            this.statusText1.setVisible(true);
            this.outputBits = 0;
            this.errorInStatus1 = true;
            this.resetNotes2();
            return false;
        }
        return true;
    }
}

