/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.maple.serialmon;

import jmri.jmrix.AbstractMonFrame;
import jmri.jmrix.maple.MapleSystemConnectionMemo;
import jmri.jmrix.maple.SerialListener;
import jmri.jmrix.maple.SerialMessage;
import jmri.jmrix.maple.SerialReply;
import jmri.util.StringUtil;

public class SerialMonFrame
extends AbstractMonFrame
implements SerialListener {
    private MapleSystemConnectionMemo _memo = null;

    public SerialMonFrame(MapleSystemConnectionMemo memo) {
        this._memo = memo;
    }

    @Override
    protected String title() {
        return "Maple Serial Command Monitor";
    }

    @Override
    protected void init() {
        this._memo.getTrafficController().addSerialListener(this);
    }

    @Override
    public void dispose() {
        this._memo.getTrafficController().removeSerialListener(this);
        super.dispose();
    }

    @Override
    protected void setHelp() {
        this.addHelpMenu("package.jmri.jmrix.maple.serialmon.SerialMonFrame", true);
    }

    @Override
    public synchronized void message(SerialMessage l) {
        if (l.getNumDataElements() < 2) {
            this.nextLine("Truncated message of length " + l.getNumDataElements() + "\n", l.toString());
        } else if (l.isPoll()) {
            if (l.getNumDataElements() <= 6 && l.getElement(0) == 15) {
                this.nextLine("Poll Reply - NAK (error)", l.toString());
            } else {
                this.nextLine("Poll node " + l.getUA() + "\n", l.toString());
            }
        } else if (l.isXmt()) {
            if (l.getNumDataElements() > 12) {
                int n = l.getNumItems();
                StringBuilder s = new StringBuilder(String.format("Transmit node=%d ADDR = %d N = %d OB=", l.getUA(), l.getAddress(), n));
                int i = 11;
                while (n > 0) {
                    for (int j = 0; j < 8 && n > 0; ++j, --n) {
                        s.append((l.getElement(i) & 1) != 0 ? "1" : "0");
                        ++i;
                    }
                    s.append(" ");
                }
                this.nextLine(s.append("\n").toString(), l.toString());
            } else {
                StringBuilder s = new StringBuilder("Transmit Reply - ");
                if (l.getElement(0) == 6) {
                    s.append("ACK (OK)");
                } else if (l.getElement(0) == 15) {
                    s.append("NAK (error)");
                }
                this.nextLine(s.append("\n").toString(), l.toString());
            }
        } else {
            this.nextLine("unrecognized cmd: \"" + l.toString() + "\"\n", "");
        }
    }

    @Override
    public synchronized void reply(SerialReply l) {
        if (l.getNumDataElements() < 2) {
            this.nextLine("Truncated reply of length " + l.getNumDataElements() + "\n", l.toString());
        } else if (l.isRcv()) {
            String s = "Receive node=" + l.getUA() + " IB=";
            for (int i = 2; i < l.getNumDataElements(); ++i) {
                s = StringUtil.appendTwoHexFromInt(l.getElement(i), s) + " ";
            }
            this.nextLine(s + "\n", l.toString());
        } else if (l.getElement(0) == 21) {
            String s = "Negative reply " + l.toString();
            this.nextLine(s + "\n", l.toString());
        } else if (l.getElement(0) == 6) {
            String s = "Positive reply " + l.toString();
            this.nextLine(s + "\n", l.toString());
        } else {
            this.nextLine("unrecognized rep: \"" + l.toString() + "\"\n", "");
        }
    }
}

