/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.marklin;

import jmri.jmrix.AbstractMRMessage;

public class MarklinMessage
extends AbstractMRMessage {
    static int MY_UID = 305419896;

    MarklinMessage() {
        this._dataChars = new int[13];
        this._nDataChars = 13;
        this.setBinary(true);
        for (int i = 0; i < 13; ++i) {
            this._dataChars[i] = 0;
        }
    }

    public MarklinMessage(int[] d) {
        this();
        System.arraycopy(d, 0, this._dataChars, 0, d.length);
    }

    public MarklinMessage(byte[] d) {
        this();
        for (int i = 0; i < d.length; ++i) {
            this._dataChars[i] = d[i] & 0xFF;
        }
    }

    public MarklinMessage(int i) {
        this();
    }

    public MarklinMessage(MarklinMessage m) {
        super(m);
    }

    public static MarklinMessage getEnableMain() {
        MarklinMessage m = new MarklinMessage();
        m.setElement(0, 0);
        m.setElement(1, 0);
        m.setElement(2, 71);
        m.setElement(3, 17);
        m.setElement(4, 5);
        m.setElement(9, 1);
        return m;
    }

    public static MarklinMessage getKillMain() {
        MarklinMessage m = new MarklinMessage();
        m.setElement(0, 0);
        m.setElement(1, 0);
        m.setElement(2, 71);
        m.setElement(3, 17);
        m.setElement(4, 5);
        m.setElement(9, 0);
        return m;
    }

    public static MarklinMessage getSetTurnout(int addr, int state, int power) {
        MarklinMessage m = new MarklinMessage();
        m.setElement(0, 0);
        m.setElement(1, 22);
        m.setElement(2, 71);
        m.setElement(3, 17);
        m.setElement(4, 6);
        m.setElement(5, addr >> 24 & 0xFF);
        m.setElement(6, addr >> 16 & 0xFF);
        m.setElement(7, addr >> 8 & 0xFF);
        m.setElement(8, addr & 0xFF);
        m.setElement(9, state & 0xFF);
        m.setElement(10, power & 0xFF);
        return m;
    }

    public static MarklinMessage getQryLocoSpeed(int addr) {
        MarklinMessage m = new MarklinMessage();
        m.setElement(0, 0);
        m.setElement(1, 8);
        m.setElement(2, 71);
        m.setElement(3, 17);
        m.setElement(4, 4);
        m.setElement(5, addr >> 24 & 0xFF);
        m.setElement(6, addr >> 16 & 0xFF);
        m.setElement(7, addr >> 8 & 0xFF);
        m.setElement(8, addr & 0xFF);
        return m;
    }

    public static MarklinMessage setLocoSpeed(int addr, int speed) {
        MarklinMessage m = new MarklinMessage();
        m.setElement(0, 0);
        m.setElement(1, 8);
        m.setElement(2, 71);
        m.setElement(3, 17);
        m.setElement(4, 6);
        m.setElement(5, addr >> 24 & 0xFF);
        m.setElement(6, addr >> 16 & 0xFF);
        m.setElement(7, addr >> 8 & 0xFF);
        m.setElement(8, addr & 0xFF);
        m.setElement(9, speed >> 8 & 0xFF);
        m.setElement(10, speed & 0xFF);
        return m;
    }

    public static MarklinMessage setLocoEmergencyStop(int addr) {
        MarklinMessage m = new MarklinMessage();
        m.setElement(0, 0);
        m.setElement(1, 0);
        m.setElement(2, 71);
        m.setElement(3, 17);
        m.setElement(4, 5);
        m.setElement(5, addr >> 24 & 0xFF);
        m.setElement(6, addr >> 16 & 0xFF);
        m.setElement(7, addr >> 8 & 0xFF);
        m.setElement(8, addr & 0xFF);
        m.setElement(9, 3);
        return m;
    }

    public static MarklinMessage setLocoSpeedSteps(int addr, int step) {
        MarklinMessage m = new MarklinMessage();
        m.setElement(0, 0);
        m.setElement(1, 0);
        m.setElement(2, 71);
        m.setElement(3, 17);
        m.setElement(4, 5);
        m.setElement(5, addr >> 24 & 0xFF);
        m.setElement(6, addr >> 16 & 0xFF);
        m.setElement(7, addr >> 8 & 0xFF);
        m.setElement(8, addr & 0xFF);
        m.setElement(9, 5);
        m.setElement(10, step & 0xFF);
        return m;
    }

    public static MarklinMessage getQryLocoDirection(int addr) {
        MarklinMessage m = new MarklinMessage();
        m.setElement(0, 0);
        m.setElement(1, 10);
        m.setElement(2, 71);
        m.setElement(3, 17);
        m.setElement(4, 4);
        m.setElement(5, addr >> 24 & 0xFF);
        m.setElement(6, addr >> 16 & 0xFF);
        m.setElement(7, addr >> 8 & 0xFF);
        m.setElement(8, addr & 0xFF);
        return m;
    }

    public static MarklinMessage setLocoDirection(int addr, int dir) {
        MarklinMessage m = new MarklinMessage();
        m.setElement(0, 0);
        m.setElement(1, 10);
        m.setElement(2, 71);
        m.setElement(3, 17);
        m.setElement(4, 5);
        m.setElement(5, addr >> 24 & 0xFF);
        m.setElement(6, addr >> 16 & 0xFF);
        m.setElement(7, addr >> 8 & 0xFF);
        m.setElement(8, addr & 0xFF);
        m.setElement(9, dir & 0xFF);
        return m;
    }

    public static MarklinMessage getQryLocoFunction(int addr, int funct) {
        MarklinMessage m = new MarklinMessage();
        m.setElement(0, 0);
        m.setElement(1, 12);
        m.setElement(2, 71);
        m.setElement(3, 17);
        m.setElement(4, 5);
        m.setElement(5, addr >> 24 & 0xFF);
        m.setElement(6, addr >> 16 & 0xFF);
        m.setElement(7, addr >> 8 & 0xFF);
        m.setElement(8, addr & 0xFF);
        m.setElement(9, funct & 0xFF);
        return m;
    }

    public static MarklinMessage setLocoFunction(int addr, int funct, int state) {
        MarklinMessage m = new MarklinMessage();
        m.setElement(0, 0);
        m.setElement(1, 12);
        m.setElement(2, 71);
        m.setElement(3, 17);
        m.setElement(4, 6);
        m.setElement(5, addr >> 24 & 0xFF);
        m.setElement(6, addr >> 16 & 0xFF);
        m.setElement(7, addr >> 8 & 0xFF);
        m.setElement(8, addr & 0xFF);
        m.setElement(9, funct & 0xFF);
        m.setElement(10, state & 0xFF);
        m.getAddress();
        return m;
    }

    public static MarklinMessage sensorPollMessage(int module) {
        MarklinMessage m = new MarklinMessage();
        m.setElement(0, 0);
        m.setElement(1, 32);
        m.setElement(2, 71);
        m.setElement(3, 17);
        m.setElement(4, 5);
        m.setElement(5, MY_UID >> 24 & 0xFF);
        m.setElement(6, MY_UID >> 16 & 0xFF);
        m.setElement(7, MY_UID >> 8 & 0xFF);
        m.setElement(8, MY_UID & 0xFF);
        m.setElement(9, module & 0xFF);
        return m;
    }

    public long getAddress() {
        long addr = this.getElement(5);
        addr = (addr << 8) + (long)this.getElement(6);
        addr = (addr << 8) + (long)this.getElement(7);
        addr = (addr << 8) + (long)this.getElement(8);
        return addr;
    }

    public static MarklinMessage getProgMode() {
        return new MarklinMessage();
    }

    public static MarklinMessage getExitProgMode() {
        return new MarklinMessage();
    }

    public static MarklinMessage getReadPagedCV(int cv) {
        return new MarklinMessage();
    }

    public static MarklinMessage getWritePagedCV(int cv, int val) {
        return new MarklinMessage();
    }

    public static MarklinMessage getReadRegister(int reg) {
        return new MarklinMessage();
    }

    public static MarklinMessage getWriteRegister(int reg, int val) {
        return new MarklinMessage();
    }

    public static MarklinMessage getReadDirectCV(int cv) {
        return new MarklinMessage();
    }

    public static MarklinMessage getWriteDirectCV(int cv, int val) {
        return new MarklinMessage();
    }
}

