/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.marklin;

import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.marklin.swing.monitor.MarklinMon;

public class MarklinReply
extends AbstractMRReply {
    public MarklinReply() {
    }

    public MarklinReply(String s) {
        super(s);
    }

    public MarklinReply(MarklinReply l) {
        super(l);
    }

    public MarklinReply(int[] d) {
        this();
        this._nDataChars = d.length;
        System.arraycopy(d, 0, this._dataChars, 0, d.length);
    }

    @Override
    public int maxSize() {
        return 13;
    }

    @Override
    protected int skipPrefix(int index) {
        return index;
    }

    @Override
    public int value() {
        if (this.isBinary()) {
            return this.getElement(0);
        }
        return super.value();
    }

    @Override
    public int getElement(int n) {
        return super.getElement(n) & 0xFF;
    }

    @Override
    public boolean isUnsolicited() {
        return !this.isResponse();
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("0x").append(Integer.toHexString(this._dataChars[0]));
        for (int i = 1; i < this._nDataChars; ++i) {
            buf.append(", 0x").append(Integer.toHexString(this._dataChars[i]));
        }
        return buf.toString();
    }

    @Override
    public String toMonitorString() {
        return MarklinMon.displayReply(this);
    }

    public boolean isResponse() {
        return (this.getElement(1) & 1) == 1;
    }

    public int getCanDataLength() {
        return this.getElement(4);
    }

    public int[] getCanData() {
        int[] arr = new int[this.maxSize() - 5];
        for (int i = 5; i < this.maxSize(); ++i) {
            arr[i - 5] = this.getElement(i);
        }
        return arr;
    }

    public int[] getCanAddress() {
        int[] arr = new int[4];
        for (int i = 5; i < 9; ++i) {
            arr[i - 5] = this.getElement(i);
        }
        return arr;
    }

    public long getAddress() {
        long addr = this.getElement(5);
        addr = (addr << 8) + (long)this.getElement(6);
        addr = (addr << 8) + (long)this.getElement(7);
        addr = (addr << 8) + (long)this.getElement(8);
        return addr;
    }

    public void setAddress(long address) {
        this.setElement(5, (byte)(address >> 24 & 0xFFL));
        this.setElement(6, (byte)(address >> 16 & 0xFFL));
        this.setElement(7, (byte)(address >> 8 & 0xFFL));
        this.setElement(8, (byte)(address & 0xFFL));
    }

    public int getPriority() {
        return this.getElement(0) >> 4;
    }

    public int getCommand() {
        int result = this.getElement(0) << 7;
        result = result + this.getElement(1) >> 1;
        return result;
    }

    public void setCommand(int command) {
        int element0 = this.getElement(0) & 0xFFFFFF80 | command >> 7 & 0x7F;
        int element1 = this.getElement(1) & 0xFFFFFF01 | (command & 0x7F) << 1;
        this.setElement(0, element0);
        this.setElement(1, element1);
    }

    public int[] getHash() {
        int[] arr = new int[]{this.getElement(2), this.getElement(3)};
        return arr;
    }
}

