/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.marklin;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.ThrottleManager;
import jmri.jmrix.AbstractThrottle;
import jmri.jmrix.marklin.MarklinListener;
import jmri.jmrix.marklin.MarklinMessage;
import jmri.jmrix.marklin.MarklinReply;
import jmri.jmrix.marklin.MarklinSystemConnectionMemo;
import jmri.jmrix.marklin.MarklinTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarklinThrottle
extends AbstractThrottle
implements MarklinListener {
    private LocoAddress address;
    MarklinTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(MarklinThrottle.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MarklinThrottle(MarklinSystemConnectionMemo memo, LocoAddress address) {
        super(memo);
        this.tc = memo.getTrafficController();
        MarklinThrottle marklinThrottle = this;
        synchronized (marklinThrottle) {
            this.speedSetting = 0.0f;
        }
        this.address = address;
        this.isForward = true;
        this.setSpeedStepMode(SpeedStepMode.NMRA_DCC_128);
        this.tc.addMarklinListener(this);
        this.tc.sendMarklinMessage(MarklinMessage.getQryLocoSpeed(this.getCANAddress()), this);
        this.tc.sendMarklinMessage(MarklinMessage.getQryLocoDirection(this.getCANAddress()), this);
        for (int i = 0; i <= 28; ++i) {
            this.tc.sendMarklinMessage(MarklinMessage.getQryLocoFunction(this.getCANAddress(), i), this);
        }
    }

    @Override
    protected void sendFunctionGroup1() {
        this.tc.sendMarklinMessage(MarklinMessage.setLocoFunction(this.getCANAddress(), 0, this.getFunction(0) ? 1 : 0), this);
        this.tc.sendMarklinMessage(MarklinMessage.setLocoFunction(this.getCANAddress(), 1, this.getFunction(1) ? 1 : 0), this);
        this.tc.sendMarklinMessage(MarklinMessage.setLocoFunction(this.getCANAddress(), 2, this.getFunction(2) ? 1 : 0), this);
        this.tc.sendMarklinMessage(MarklinMessage.setLocoFunction(this.getCANAddress(), 3, this.getFunction(3) ? 1 : 0), this);
        this.tc.sendMarklinMessage(MarklinMessage.setLocoFunction(this.getCANAddress(), 4, this.getFunction(4) ? 1 : 0), this);
    }

    @Override
    protected void sendFunctionGroup2() {
        this.tc.sendMarklinMessage(MarklinMessage.setLocoFunction(this.getCANAddress(), 5, this.getFunction(5) ? 1 : 0), this);
        this.tc.sendMarklinMessage(MarklinMessage.setLocoFunction(this.getCANAddress(), 6, this.getFunction(6) ? 1 : 0), this);
        this.tc.sendMarklinMessage(MarklinMessage.setLocoFunction(this.getCANAddress(), 7, this.getFunction(7) ? 1 : 0), this);
        this.tc.sendMarklinMessage(MarklinMessage.setLocoFunction(this.getCANAddress(), 8, this.getFunction(8) ? 1 : 0), this);
    }

    @Override
    protected void sendFunctionGroup3() {
        this.tc.sendMarklinMessage(MarklinMessage.setLocoFunction(this.getCANAddress(), 9, this.getFunction(9) ? 1 : 0), this);
        this.tc.sendMarklinMessage(MarklinMessage.setLocoFunction(this.getCANAddress(), 10, this.getFunction(10) ? 1 : 0), this);
        this.tc.sendMarklinMessage(MarklinMessage.setLocoFunction(this.getCANAddress(), 11, this.getFunction(11) ? 1 : 0), this);
        this.tc.sendMarklinMessage(MarklinMessage.setLocoFunction(this.getCANAddress(), 12, this.getFunction(12) ? 1 : 0), this);
    }

    @Override
    protected void sendFunctionGroup4() {
        this.tc.sendMarklinMessage(MarklinMessage.setLocoFunction(this.getCANAddress(), 13, this.getFunction(13) ? 1 : 0), this);
        this.tc.sendMarklinMessage(MarklinMessage.setLocoFunction(this.getCANAddress(), 14, this.getFunction(14) ? 1 : 0), this);
        this.tc.sendMarklinMessage(MarklinMessage.setLocoFunction(this.getCANAddress(), 15, this.getFunction(15) ? 1 : 0), this);
        this.tc.sendMarklinMessage(MarklinMessage.setLocoFunction(this.getCANAddress(), 16, this.getFunction(16) ? 1 : 0), this);
        this.tc.sendMarklinMessage(MarklinMessage.setLocoFunction(this.getCANAddress(), 17, this.getFunction(17) ? 1 : 0), this);
        this.tc.sendMarklinMessage(MarklinMessage.setLocoFunction(this.getCANAddress(), 18, this.getFunction(18) ? 1 : 0), this);
        this.tc.sendMarklinMessage(MarklinMessage.setLocoFunction(this.getCANAddress(), 19, this.getFunction(19) ? 1 : 0), this);
        this.tc.sendMarklinMessage(MarklinMessage.setLocoFunction(this.getCANAddress(), 20, this.getFunction(20) ? 1 : 0), this);
    }

    @Override
    protected void sendFunctionGroup5() {
        this.tc.sendMarklinMessage(MarklinMessage.setLocoFunction(this.getCANAddress(), 21, this.getFunction(21) ? 1 : 0), this);
        this.tc.sendMarklinMessage(MarklinMessage.setLocoFunction(this.getCANAddress(), 22, this.getFunction(22) ? 1 : 0), this);
        this.tc.sendMarklinMessage(MarklinMessage.setLocoFunction(this.getCANAddress(), 23, this.getFunction(23) ? 1 : 0), this);
        this.tc.sendMarklinMessage(MarklinMessage.setLocoFunction(this.getCANAddress(), 24, this.getFunction(24) ? 1 : 0), this);
        this.tc.sendMarklinMessage(MarklinMessage.setLocoFunction(this.getCANAddress(), 25, this.getFunction(25) ? 1 : 0), this);
        this.tc.sendMarklinMessage(MarklinMessage.setLocoFunction(this.getCANAddress(), 26, this.getFunction(26) ? 1 : 0), this);
        this.tc.sendMarklinMessage(MarklinMessage.setLocoFunction(this.getCANAddress(), 27, this.getFunction(27) ? 1 : 0), this);
        this.tc.sendMarklinMessage(MarklinMessage.setLocoFunction(this.getCANAddress(), 28, this.getFunction(28) ? 1 : 0), this);
    }

    @Override
    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
    public synchronized void setSpeedSetting(float speed) {
        float oldSpeed = this.speedSetting;
        this.speedSetting = speed;
        int value = (int)(1000.0f * this.speedSetting);
        if (value > 1000) {
            value = 1000;
        }
        if (this.speedSetting > 0.0f && value == 0) {
            value = 1;
        }
        if (value < 0) {
            this.tc.sendMarklinMessage(MarklinMessage.setLocoEmergencyStop(this.getCANAddress()), this);
        } else {
            this.tc.sendMarklinMessage(MarklinMessage.setLocoSpeed(this.getCANAddress(), value), this);
        }
        log.debug("Float speed = {} Int speed = {}", (Object)Float.valueOf(speed), (Object)value);
        this.firePropertyChange("SpeedSetting", Float.valueOf(oldSpeed), Float.valueOf(this.speedSetting));
        this.record(speed);
    }

    protected float floatSpeed(int lSpeed) {
        if (lSpeed == 0) {
            return 0.0f;
        }
        return (float)lSpeed / 1000.0f;
    }

    @Override
    public void setIsForward(boolean forward) {
        boolean old = this.isForward;
        this.isForward = forward;
        this.setSpeedSetting(0.0f);
        this.tc.sendMarklinMessage(MarklinMessage.setLocoDirection(this.getCANAddress(), forward ? 1 : 2), this);
        this.firePropertyChange("IsForward", old, this.isForward);
    }

    @Override
    public void setSpeedStepMode(SpeedStepMode Mode) {
        if (log.isDebugEnabled()) {
            log.debug("Speed Step Mode Change to Mode: {} Current mode is: {}", (Object)Mode, (Object)this.speedStepMode);
        }
        boolean isLong = this.adapterMemo.get(ThrottleManager.class).canBeLongAddress(this.address.getNumber());
        switch (this.address.getProtocol()) {
            case DCC: {
                if (Mode == SpeedStepMode.NMRA_DCC_28 && isLong) {
                    this.tc.sendMarklinMessage(MarklinMessage.setLocoSpeedSteps(this.getCANAddress(), 3), this);
                    break;
                }
                if (Mode == SpeedStepMode.NMRA_DCC_28 && !isLong) {
                    this.tc.sendMarklinMessage(MarklinMessage.setLocoSpeedSteps(this.getCANAddress(), 0), this);
                    break;
                }
                if (Mode == SpeedStepMode.NMRA_DCC_128 && isLong) {
                    this.tc.sendMarklinMessage(MarklinMessage.setLocoSpeedSteps(this.getCANAddress(), 4), this);
                    break;
                }
                if (Mode != SpeedStepMode.NMRA_DCC_128 || isLong) break;
                this.tc.sendMarklinMessage(MarklinMessage.setLocoSpeedSteps(this.getCANAddress(), 2), this);
                break;
            }
            default: {
                Mode = SpeedStepMode.NMRA_DCC_28;
            }
        }
        super.setSpeedStepMode(Mode);
    }

    @Override
    public LocoAddress getLocoAddress() {
        return this.address;
    }

    @Override
    public void throttleDispose() {
        this.active = false;
        this.finishRecord();
    }

    @Override
    public void message(MarklinMessage m) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reply(MarklinReply m) {
        if (m.getPriority() == 0 && m.getCommand() >= 1 && m.getCommand() <= 10) {
            if (m.getAddress() != (long)this.getCANAddress()) {
                if (log.isDebugEnabled()) {
                    log.debug("Addressed packet is not for us {} {}", (Object)m.getAddress(), (Object)this.getCANAddress());
                }
                return;
            }
            if (m.getCommand() == 5) {
                if (log.isDebugEnabled()) {
                    log.debug("Loco Direction {}", (Object)m.getElement(9));
                }
                MarklinThrottle marklinThrottle = this;
                synchronized (marklinThrottle) {
                    switch (m.getElement(9)) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            if (!this.isForward) {
                                this.speedSetting = 0.0f;
                                super.setSpeedSetting(this.speedSetting);
                                this.isForward = true;
                                this.firePropertyChange("IsForward", false, this.isForward);
                            }
                            return;
                        }
                        case 2: {
                            if (this.isForward) {
                                this.speedSetting = 0.0f;
                                super.setSpeedSetting(this.speedSetting);
                                this.isForward = false;
                                this.firePropertyChange("IsForward", true, this.isForward);
                            }
                            return;
                        }
                        case 3: {
                            this.speedSetting = 0.0f;
                            super.setSpeedSetting(this.speedSetting);
                            this.isForward = !this.isForward;
                            this.firePropertyChange("IsForward", !this.isForward, this.isForward);
                            return;
                        }
                    }
                    log.error("No Match Found for loco direction {}", (Object)m.getElement(9));
                    return;
                }
            }
            if (m.getCommand() == 4) {
                int speed = m.getElement(9);
                speed = (speed << 8) + m.getElement(10);
                float newSpeed = this.floatSpeed(speed);
                log.debug("Speed raw {} float {}", (Object)speed, (Object)Float.valueOf(newSpeed));
                super.setSpeedSetting(newSpeed);
            }
            if (m.getCommand() == 6) {
                this.updateFunction(m.getElement(9), m.getElement(10) != 0);
            }
        }
    }

    int getCANAddress() {
        switch (this.address.getProtocol()) {
            case DCC: {
                return 49152 + this.address.getNumber();
            }
            case MOTOROLA: {
                return this.address.getNumber();
            }
            case SELECTRIX: {
                return 32768 + this.address.getNumber();
            }
            case MFX: {
                return 16384 + this.address.getNumber();
            }
        }
        return 49152 + this.address.getNumber();
    }
}

