/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.marklin;

import java.util.concurrent.ConcurrentLinkedQueue;
import jmri.CommandStation;
import jmri.InstanceManager;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.AbstractMRTrafficController;
import jmri.jmrix.marklin.MarklinInterface;
import jmri.jmrix.marklin.MarklinListener;
import jmri.jmrix.marklin.MarklinMessage;
import jmri.jmrix.marklin.MarklinReply;
import jmri.jmrix.marklin.MarklinSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarklinTrafficController
extends AbstractMRTrafficController
implements MarklinInterface,
CommandStation {
    MarklinSystemConnectionMemo adaptermemo;
    protected String defaultUserName = "Marklin-CS2";
    private final ConcurrentLinkedQueue<PollMessage> pollQueue = new ConcurrentLinkedQueue();
    private boolean disablePoll = false;
    private static final Logger log = LoggerFactory.getLogger(MarklinTrafficController.class);

    public MarklinTrafficController() {
        log.debug("creating a new MarklinTrafficController object");
        InstanceManager.store(this, CommandStation.class);
        this.setAllowUnexpectedReply(true);
    }

    public void setAdapterMemo(MarklinSystemConnectionMemo memo) {
        this.adaptermemo = memo;
    }

    @Override
    public synchronized void addMarklinListener(MarklinListener l) {
        this.addListener(l);
    }

    @Override
    public synchronized void removeMarklinListener(MarklinListener l) {
        this.removeListener(l);
    }

    @Override
    protected int enterProgModeDelayTime() {
        return 1000;
    }

    @Override
    public boolean sendPacket(byte[] packet, int count) {
        return true;
    }

    @Override
    protected void forwardMessage(AbstractMRListener client, AbstractMRMessage m) {
        ((MarklinListener)client).message((MarklinMessage)m);
    }

    @Override
    protected void forwardReply(AbstractMRListener client, AbstractMRReply r) {
        ((MarklinListener)client).reply((MarklinReply)r);
    }

    @Override
    public void sendMarklinMessage(MarklinMessage m, MarklinListener reply) {
        this.sendMessage(m, reply);
    }

    @Override
    protected AbstractMRMessage enterProgMode() {
        return MarklinMessage.getProgMode();
    }

    @Override
    protected AbstractMRMessage enterNormalMode() {
        return MarklinMessage.getExitProgMode();
    }

    @Override
    protected AbstractMRReply newReply() {
        return new MarklinReply();
    }

    @Override
    protected boolean canReceive() {
        return true;
    }

    @Override
    protected boolean endOfMessage(AbstractMRReply msg) {
        return false;
    }

    public boolean getPollQueueDisabled() {
        return this.disablePoll;
    }

    public void setPollQueueDisabled(boolean poll) {
        this.disablePoll = poll;
    }

    public void addPollMessage(MarklinMessage mm, MarklinListener ml) {
        mm.setTimeout(500);
        for (PollMessage pm : this.pollQueue) {
            if (pm.getListener() != ml || !pm.getMessage().toString().equals(mm.toString())) continue;
            log.debug("Message is already in the poll queue so will not add");
            return;
        }
        PollMessage pm = new PollMessage(mm, ml);
        this.pollQueue.offer(pm);
    }

    public void removePollMessage(MarklinMessage mm, MarklinListener ml) {
        for (PollMessage pm : this.pollQueue) {
            if (pm.getListener() != ml || !pm.getMessage().toString().equals(mm.toString())) continue;
            this.pollQueue.remove(pm);
        }
    }

    @Override
    protected AbstractMRMessage pollMessage() {
        PollMessage pm;
        if (!this.disablePoll && !this.pollQueue.isEmpty() && (pm = this.pollQueue.peek()) != null) {
            return pm.getMessage();
        }
        return null;
    }

    @Override
    protected AbstractMRListener pollReplyHandler() {
        PollMessage pm;
        if (!this.disablePoll && !this.pollQueue.isEmpty() && (pm = this.pollQueue.poll()) != null) {
            this.pollQueue.offer(pm);
            return pm.getListener();
        }
        return null;
    }

    @Override
    public String getUserName() {
        if (this.adaptermemo == null) {
            return this.defaultUserName;
        }
        return this.adaptermemo.getUserName();
    }

    @Override
    public String getSystemPrefix() {
        if (this.adaptermemo == null) {
            return "M";
        }
        return this.adaptermemo.getSystemPrefix();
    }

    public void dispose() {
        this.terminateThreads();
        InstanceManager.deregister(this, CommandStation.class);
    }

    private static class PollMessage {
        MarklinListener ml;
        MarklinMessage mm;

        PollMessage(MarklinMessage mm, MarklinListener ml) {
            this.mm = mm;
            this.ml = ml;
        }

        MarklinListener getListener() {
            return this.ml;
        }

        MarklinMessage getMessage() {
            return this.mm;
        }
    }
}

