/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.marklin;

import javax.annotation.Nonnull;
import jmri.Turnout;
import jmri.jmrix.marklin.MarklinSystemConnectionMemo;
import jmri.jmrix.marklin.MarklinTrafficController;
import jmri.jmrix.marklin.MarklinTurnout;
import jmri.managers.AbstractTurnoutManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarklinTurnoutManager
extends AbstractTurnoutManager {
    private final MarklinTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(MarklinTurnoutManager.class);

    public MarklinTurnoutManager(MarklinSystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getTrafficController();
    }

    @Override
    @Nonnull
    public MarklinSystemConnectionMemo getMemo() {
        return (MarklinSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Turnout createNewTurnout(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        int addr;
        try {
            addr = Integer.parseInt(systemName.substring(this.getSystemPrefix().length() + 1));
        }
        catch (NumberFormatException e) {
            log.error("Failed to convert systemName {} to a turnout address", (Object)systemName);
            throw new IllegalArgumentException("failed to convert systemName '" + systemName + "' to a Turnout address");
        }
        MarklinTurnout t = new MarklinTurnout(addr, this.getSystemPrefix(), this.tc);
        t.setUserName(userName);
        return t;
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }
}

