/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.marklin.cdb.serialdriver;

import java.util.Arrays;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.marklin.MarklinTrafficController;
import jmri.jmrix.marklin.cdb.CdBPortController;
import jmri.jmrix.marklin.cdb.CdBSystemConnectionMemo;
import jmri.jmrix.marklin.cdb.serialdriver.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialDriverAdapter
extends CdBPortController {
    private final String[] validSpeeds = new String[]{Bundle.getMessage("Baud500000")};
    private final int[] validSpeedValues = new int[]{500000};
    private static final Logger log = LoggerFactory.getLogger(SerialDriverAdapter.class);

    public SerialDriverAdapter() {
        super(new CdBSystemConnectionMemo());
        this.setManufacturer("CAN-digital-Bahn");
    }

    @Override
    public String openPort(String portName, String appName) {
        this.currentSerialPort = this.activatePort(portName, log);
        if (this.currentSerialPort == null) {
            log.error("failed to connect Marklin CDB to {}", (Object)portName);
            return Bundle.getMessage("SerialPortNotFound", portName);
        }
        log.info("Connecting Marklin CDB to {} {}", (Object)portName, (Object)this.currentSerialPort);
        int baud = this.currentBaudNumber(this.mBaudRate);
        this.setBaudRate(this.currentSerialPort, baud);
        this.configureLeads(this.currentSerialPort, true, true);
        this.setFlowControl(this.currentSerialPort, AbstractSerialPortController.FlowControl.NONE);
        this.reportPortStatus(log, portName);
        this.opened = true;
        return null;
    }

    @Override
    public void configure() {
        MarklinTrafficController tc = new MarklinTrafficController();
        this.getSystemConnectionMemo().setMarklinTrafficController(tc);
        tc.setAdapterMemo(this.getSystemConnectionMemo());
        tc.connectPort(this);
        this.getSystemConnectionMemo().configureManagers();
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }
}

