/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.marklin.swing.packetgen;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.jmrix.marklin.MarklinListener;
import jmri.jmrix.marklin.MarklinMessage;
import jmri.jmrix.marklin.MarklinReply;
import jmri.jmrix.marklin.MarklinSystemConnectionMemo;
import jmri.jmrix.marklin.swing.MarklinPanel;
import jmri.jmrix.marklin.swing.packetgen.Bundle;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketGenPanel
extends MarklinPanel
implements MarklinListener {
    private final JLabel entryLabel = new JLabel();
    private final JLabel replyLabel = new JLabel();
    private final JButton sendButton = new JButton();
    private final JTextField packetTextField = new JTextField(20);
    private final JTextField packetReplyField = new JTextField(20);
    private static final Logger log = LoggerFactory.getLogger(PacketGenPanel.class);

    @Override
    public void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel entrybox = new JPanel();
        this.entryLabel.setText(Bundle.getMessage("CommandLabel"));
        this.entryLabel.setVisible(true);
        this.entryLabel.setLabelFor(this.packetTextField);
        this.replyLabel.setText(Bundle.getMessage("ReplyLabel"));
        this.replyLabel.setVisible(true);
        this.replyLabel.setLabelFor(this.packetReplyField);
        this.sendButton.setText(Bundle.getMessage("ButtonSend"));
        this.sendButton.setVisible(true);
        this.sendButton.setToolTipText(Bundle.getMessage("SendToolTip"));
        this.packetTextField.setText("");
        this.packetTextField.setToolTipText(Bundle.getMessage("EnterHexToolTip"));
        this.packetTextField.setMaximumSize(new Dimension(this.packetTextField.getMaximumSize().width, this.packetTextField.getPreferredSize().height));
        entrybox.setLayout(new GridLayout(2, 2));
        entrybox.add(this.entryLabel);
        entrybox.add(this.packetTextField);
        entrybox.add(this.replyLabel);
        JPanel buttonbox = new JPanel();
        FlowLayout buttonLayout = new FlowLayout(4);
        buttonbox.setLayout(buttonLayout);
        buttonbox.add(this.sendButton);
        entrybox.add(buttonbox);
        this.add(entrybox);
        this.add(this.packetReplyField);
        this.add(Box.createVerticalGlue());
        this.sendButton.addActionListener(this::sendButtonActionPerformed);
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.marklin.swing.packetgen.PacketGenFrame";
    }

    @Override
    public String getTitle() {
        return Bundle.getMessage("SendCommandTitle");
    }

    @Override
    public void initComponents(MarklinSystemConnectionMemo memo) {
        super.initComponents(memo);
        memo.getTrafficController().addMarklinListener(this);
    }

    public void sendButtonActionPerformed(ActionEvent e) {
        String text = this.packetTextField.getText();
        if (text != null && !Objects.equals(text, "")) {
            if (text.length() == 0) {
                return;
            }
            log.info("Entry[{}]", (Object)text);
            if (text.startsWith("0x")) {
                text = text.replaceAll("\\s", "");
                text = text.substring(2);
                String[] arr = text.split(",");
                byte[] msgArray = new byte[arr.length];
                int pos = 0;
                for (String s : arr) {
                    msgArray[pos++] = (byte)(Integer.parseInt(s, 16) & 0xFF);
                }
                MarklinMessage m = new MarklinMessage(msgArray);
                if (this.memo != null) {
                    this.memo.getTrafficController().sendMarklinMessage(m, this);
                }
            } else {
                log.error("Only hex commands are supported");
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("HexOnlyDialog"), Bundle.getMessage("WarningTitle"), 0);
            }
        }
    }

    @Override
    public void message(MarklinMessage m) {
    }

    @Override
    public void reply(MarklinReply r) {
        this.packetReplyField.setText(r.toString());
    }

    @Override
    public void dispose() {
        if (this.memo != null) {
            this.memo.getTrafficController().removeMarklinListener(this);
        }
        super.dispose();
    }
}

