/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mqtt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TimerTask;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.jmrix.AbstractNetworkPortController;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.mqtt.Bundle;
import jmri.jmrix.mqtt.MqttEventListener;
import jmri.jmrix.mqtt.MqttSystemConnectionMemo;
import jmri.util.FileUtil;
import jmri.util.LoggingUtil;
import jmri.util.TimerUtil;
import jmri.util.node.NodeIdentity;
import jmri.web.server.WebServerPreferences;
import org.apiguardian.api.API;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.MAINTAINED)
public class MqttAdapter
extends AbstractNetworkPortController
implements MqttCallback {
    private static final String PROTOCOL = "tcp://";
    private static final String DEFAULT_BASETOPIC = Bundle.getMessage("TopicBase");
    private static final String MQTT_USERNAME_OPTION = "0.1";
    private static final String MQTT_PASSWORD_OPTION = "0.2";
    public boolean retained = true;
    public int qosflag = 2;
    @API(status=API.Status.MAINTAINED)
    public String baseTopic = DEFAULT_BASETOPIC;
    HashMap<String, ArrayList<MqttEventListener>> mqttEventListeners = new HashMap();
    MqttClient mqttClient;
    private static final Logger log = LoggerFactory.getLogger(MqttAdapter.class);

    @API(status=API.Status.INTERNAL)
    public MqttAdapter() {
        super(new MqttSystemConnectionMemo());
        log.debug("Doing ctor...");
        this.options.put(MQTT_USERNAME_OPTION, new AbstractPortController.Option(Bundle.getMessage("MQTT_Username"), new String[]{""}, AbstractPortController.Option.Type.TEXT));
        this.options.put(MQTT_PASSWORD_OPTION, new AbstractPortController.Option(Bundle.getMessage("MQTT_Password"), new String[]{""}, AbstractPortController.Option.Type.PASSWORD));
        this.option2Name = "0 MQTTchannel";
        this.options.put(this.option2Name, new AbstractPortController.Option(Bundle.getMessage("NameTopicBase"), new String[]{this.baseTopic}, AbstractPortController.Option.Type.TEXT));
        this.options.put("10.3", new AbstractPortController.Option(Bundle.getMessage("NameTopicTurnoutSend"), new String[]{Bundle.getMessage("TopicTurnoutSend")}, AbstractPortController.Option.Type.TEXT));
        this.options.put("10.5", new AbstractPortController.Option(Bundle.getMessage("NameTopicTurnoutRcv"), new String[]{Bundle.getMessage("TopicTurnoutRcv")}, AbstractPortController.Option.Type.TEXT));
        this.options.put("11.3", new AbstractPortController.Option(Bundle.getMessage("NameTopicSensorSend"), new String[]{Bundle.getMessage("TopicSensorSend")}, AbstractPortController.Option.Type.TEXT));
        this.options.put("11.5", new AbstractPortController.Option(Bundle.getMessage("NameTopicSensorRcv"), new String[]{Bundle.getMessage("TopicSensorRcv")}, AbstractPortController.Option.Type.TEXT));
        this.options.put("12.3", new AbstractPortController.Option(Bundle.getMessage("NameTopicLightSend"), new String[]{Bundle.getMessage("TopicLightSend")}, AbstractPortController.Option.Type.TEXT));
        this.options.put("12.5", new AbstractPortController.Option(Bundle.getMessage("NameTopicLightRcv"), new String[]{Bundle.getMessage("TopicLightRcv")}, AbstractPortController.Option.Type.TEXT));
        this.options.put("13", new AbstractPortController.Option("Reporter topic :", new String[]{Bundle.getMessage("TopicReporter")}, AbstractPortController.Option.Type.TEXT));
        this.options.put("14", new AbstractPortController.Option("Signal Head topic :", new String[]{Bundle.getMessage("TopicSignalHead")}, AbstractPortController.Option.Type.TEXT));
        this.options.put("15", new AbstractPortController.Option("Signal Mast topic :", new String[]{Bundle.getMessage("TopicSignalMast")}, AbstractPortController.Option.Type.TEXT));
        this.options.put("16.3", new AbstractPortController.Option(Bundle.getMessage("NameTopicThrottleSend"), new String[]{Bundle.getMessage("TopicThrottleSend")}, AbstractPortController.Option.Type.TEXT));
        this.options.put("16.5", new AbstractPortController.Option(Bundle.getMessage("NameTopicThrottleRcv"), new String[]{Bundle.getMessage("TopicThrottleRcv")}, AbstractPortController.Option.Type.TEXT));
        this.options.put("17.3", new AbstractPortController.Option(Bundle.getMessage("NameTopicDirectionSend"), new String[]{Bundle.getMessage("TopicDirectionSend")}, AbstractPortController.Option.Type.TEXT));
        this.options.put("17.5", new AbstractPortController.Option(Bundle.getMessage("NameTopicDirectionRcv"), new String[]{Bundle.getMessage("TopicDirectionRcv")}, AbstractPortController.Option.Type.TEXT));
        this.options.put("18.3", new AbstractPortController.Option(Bundle.getMessage("NameTopicFunctionSend"), new String[]{Bundle.getMessage("TopicFunctionSend")}, AbstractPortController.Option.Type.TEXT));
        this.options.put("18.5", new AbstractPortController.Option(Bundle.getMessage("NameTopicFunctionRcv"), new String[]{Bundle.getMessage("TopicFunctionRcv")}, AbstractPortController.Option.Type.TEXT));
        this.options.put("19.3", new AbstractPortController.Option(Bundle.getMessage("NameTopicConsistSend"), new String[]{Bundle.getMessage("TopicConsistSend")}, AbstractPortController.Option.Type.TEXT));
        this.options.put("20.3", new AbstractPortController.Option(Bundle.getMessage("NameTopicPowerSend"), new String[]{Bundle.getMessage("TopicPowerSend")}, AbstractPortController.Option.Type.TEXT));
        this.options.put("20.5", new AbstractPortController.Option(Bundle.getMessage("NameTopicPowerRcv"), new String[]{Bundle.getMessage("TopicPowerRcv")}, AbstractPortController.Option.Type.TEXT));
        this.options.put("LastWillTopic", new AbstractPortController.Option(Bundle.getMessage("NameTopicLastWill"), new String[]{Bundle.getMessage("TopicLastWill")}, AbstractPortController.Option.Type.TEXT));
        this.options.put("LastWillMessage", new AbstractPortController.Option(Bundle.getMessage("NameMessageLastWill"), new String[]{Bundle.getMessage("MessageLastWill")}, AbstractPortController.Option.Type.TEXT));
        this.allowConnectionRecovery = true;
    }

    public MqttConnectOptions getMqttConnectionOptions() {
        MqttConnectOptions mqttConnOpts = new MqttConnectOptions();
        mqttConnOpts.setCleanSession(true);
        mqttConnOpts.setMaxInflight(100);
        if (this.getOptionState(MQTT_USERNAME_OPTION) != null && !this.getOptionState(MQTT_USERNAME_OPTION).isEmpty()) {
            mqttConnOpts.setUserName(this.getOptionState(MQTT_USERNAME_OPTION));
            mqttConnOpts.setPassword(this.getOptionState(MQTT_PASSWORD_OPTION).toCharArray());
        }
        if (!this.getOptionState("LastWillTopic").isEmpty() && !this.getOptionState("LastWillMessage").isEmpty()) {
            mqttConnOpts.setWill(this.baseTopic + this.getOptionState("LastWillTopic"), this.getOptionState("LastWillMessage").getBytes(), this.qosflag, true);
        }
        return mqttConnOpts;
    }

    @Override
    @API(status=API.Status.INTERNAL)
    public void configure() {
        log.debug("Doing configure...");
        this.mqttEventListeners = new HashMap();
        this.getSystemConnectionMemo().setMqttAdapter(this);
        this.getSystemConnectionMemo().configureManagers();
    }

    @Override
    @API(status=API.Status.INTERNAL)
    public void connect() throws IOException {
        log.info("MQTT starting connect with MQTTchannel = \"{}\"", (Object)this.getOptionState(this.option2Name));
        try {
            if (this.getOptionState(this.option2Name) != null && !this.getOptionState(this.option2Name).trim().isEmpty()) {
                this.baseTopic = this.getOptionState(this.option2Name);
            }
            if (!DEFAULT_BASETOPIC.equals(this.baseTopic)) {
                this.options.put(this.option2Name, new AbstractPortController.Option("MQTT channel: ", new String[]{this.baseTopic, DEFAULT_BASETOPIC}));
            }
            Object clientID = InstanceManager.getDefault(WebServerPreferences.class).getRailroadName();
            clientID = ((String)clientID).replaceAll("[^A-Za-z0-9]", "");
            String clientIDsuffix = "JMRI" + Integer.toHexString(NodeIdentity.networkIdentity().hashCode()).toUpperCase() + this.getSystemPrefix();
            if (((String)clientID).length() > 23 - clientIDsuffix.length()) {
                clientID = ((String)clientID).substring(0, 23 - clientIDsuffix.length());
            }
            clientID = (String)clientID + clientIDsuffix;
            log.info("Connection {} is using a clientID of \"{}\"", (Object)this.getSystemPrefix(), clientID);
            String tempdirName = FileUtil.getExternalFilename("profile:");
            log.debug("will use {} as temporary directory", (Object)tempdirName);
            this.mqttClient = this.getNewMqttClient((String)clientID, tempdirName);
            if (this.getOptionState(MQTT_USERNAME_OPTION) != null && !this.getOptionState(MQTT_USERNAME_OPTION).isEmpty() || !this.getOptionState("LastWillTopic").isEmpty() && !this.getOptionState("LastWillMessage").isEmpty()) {
                this.mqttClient.connect(this.getMqttConnectionOptions());
            } else {
                this.mqttClient.connect();
            }
            if (!this.getOptionState("LastWillTopic").isEmpty()) {
                this.publish(this.getOptionState("LastWillTopic"), "");
            }
            this.mqttClient.setCallback((MqttCallback)this);
        }
        catch (MqttException ex) {
            throw new IOException("Can't create MQTT client", ex);
        }
    }

    MqttClient getNewMqttClient(String clientID, String tempdirName) throws MqttException {
        return new MqttClient(PROTOCOL + this.getCurrentPortName(), clientID, (MqttClientPersistence)new MqttDefaultFilePersistence(tempdirName));
    }

    @Override
    @API(status=API.Status.MAINTAINED)
    public MqttSystemConnectionMemo getSystemConnectionMemo() {
        return (MqttSystemConnectionMemo)super.getSystemConnectionMemo();
    }

    @API(status=API.Status.MAINTAINED)
    public void subscribe(String topic, MqttEventListener mel) {
        if (this.mqttEventListeners == null || this.mqttClient == null) {
            LoggingUtil.warnOnce(log, "Trying to subscribe before connect/configure is done", new Object[0]);
            return;
        }
        try {
            String fullTopic = this.baseTopic + topic;
            if (this.mqttEventListeners.containsKey(fullTopic)) {
                if (!this.mqttEventListeners.get(fullTopic).contains(mel)) {
                    this.mqttEventListeners.get(fullTopic).add(mel);
                }
                return;
            }
            ArrayList<MqttEventListener> mels = new ArrayList<MqttEventListener>();
            mels.add(mel);
            this.mqttEventListeners.put(fullTopic, mels);
            this.mqttClient.subscribe(fullTopic);
            log.debug("Subscribed : \"{}\"", (Object)fullTopic);
        }
        catch (MqttException ex) {
            log.error("Can't subscribe : ", (Throwable)ex);
        }
    }

    @API(status=API.Status.MAINTAINED)
    public void unsubscribe(String topic, MqttEventListener mel) {
        String fullTopic = this.baseTopic + topic;
        if (this.mqttEventListeners == null || this.mqttClient == null) {
            LoggingUtil.warnOnce(log, "Trying to unsubscribe before connect/configure is done", new Object[0]);
            return;
        }
        try {
            this.mqttEventListeners.get(fullTopic).remove(mel);
        }
        catch (NullPointerException e) {
            log.debug("Unsubscribe but not subscribed: \"{}\"", (Object)fullTopic);
            return;
        }
        if (this.mqttEventListeners.get(fullTopic).isEmpty()) {
            try {
                this.mqttClient.unsubscribe(fullTopic);
                this.mqttEventListeners.remove(fullTopic);
                log.debug("Unsubscribed : \"{}\"", (Object)fullTopic);
            }
            catch (MqttException ex) {
                log.error("Can't unsubscribe : ", (Throwable)ex);
            }
        }
    }

    @API(status=API.Status.MAINTAINED)
    public void unsubscribeall(MqttEventListener mel) {
        this.mqttEventListeners.keySet().forEach(t -> this.unsubscribe((String)t, mel));
    }

    @API(status=API.Status.MAINTAINED)
    public void publish(@Nonnull String topic, @Nonnull byte[] payload) {
        this.publish(topic, payload, this.retained);
    }

    @API(status=API.Status.MAINTAINED)
    public void publish(@Nonnull String topic, @Nonnull byte[] payload, boolean retain) {
        try {
            String fullTopic = this.baseTopic + topic;
            this.mqttClient.publish(fullTopic, payload, this.qosflag, retain);
        }
        catch (MqttException ex) {
            log.error("Can't publish : ", (Throwable)ex);
        }
    }

    @API(status=API.Status.MAINTAINED)
    public void publish(@Nonnull String topic, @Nonnull String payload) {
        this.publish(topic, payload.getBytes());
    }

    @API(status=API.Status.MAINTAINED)
    public void publish(@Nonnull String topic, @Nonnull String payload, boolean retain) {
        this.publish(topic, payload.getBytes(), retain);
    }

    public MqttClient getMQttClient() {
        return this.mqttClient;
    }

    private void tryToReconnect(boolean showLogMessages) {
        if (showLogMessages) {
            log.warn("Try to reconnect");
        }
        try {
            if (this.getOptionState(MQTT_USERNAME_OPTION) != null && !this.getOptionState(MQTT_USERNAME_OPTION).isEmpty() || !this.getOptionState("LastWillTopic").isEmpty() && !this.getOptionState("LastWillMessage").isEmpty()) {
                this.mqttClient.connect(this.getMqttConnectionOptions());
            } else {
                this.mqttClient.connect();
            }
            if (!this.getOptionState("LastWillTopic").isEmpty()) {
                this.publish(this.getOptionState("LastWillTopic"), "");
            }
            log.warn("Succeeded to reconnect");
            this.mqttClient.setCallback((MqttCallback)this);
            HashSet<String> set = new HashSet<String>(this.mqttEventListeners.keySet());
            for (String t : set) {
                this.mqttClient.subscribe(t);
            }
        }
        catch (MqttException ex) {
            if (showLogMessages) {
                log.error("Unable to reconnect", (Throwable)ex);
            }
            this.scheduleReconnectTimer(false);
        }
    }

    private void scheduleReconnectTimer(final boolean showLogMessages) {
        TimerUtil.scheduleOnLayoutThread(new TimerTask(){

            @Override
            public void run() {
                MqttAdapter.this.tryToReconnect(showLogMessages);
            }
        }, 500L);
    }

    @API(status=API.Status.INTERNAL)
    public void connectionLost(Throwable thrwbl) {
        log.warn("Lost MQTT broker connection...");
        if (this.allowConnectionRecovery) {
            log.info("...trying to reconnect repeatedly");
            this.scheduleReconnectTimer(true);
            return;
        }
        log.error("Won't reconnect");
    }

    @API(status=API.Status.INTERNAL)
    public void messageArrived(String topic, MqttMessage mm) throws Exception {
        log.debug("Message received, topic : {} - '{}'", (Object)topic, (Object)mm);
        boolean found = false;
        HashMap<String, ArrayList<MqttEventListener>> tempMap = new HashMap<String, ArrayList<MqttEventListener>>(this.mqttEventListeners);
        for (Map.Entry e : tempMap.entrySet()) {
            if (!MqttTopic.isMatched((String)((String)e.getKey()), (String)topic)) continue;
            found = true;
            ((ArrayList)e.getValue()).forEach(mel -> {
                try {
                    mel.notifyMqttMessage(topic, mm.toString());
                }
                catch (Exception exception) {
                    log.error("MqttEventListener exception: ", (Throwable)exception);
                }
            });
        }
        if (!found) {
            log.error("No one subscribed to {}", (Object)topic);
            throw new Exception("No subscriber for MQTT topic " + topic);
        }
    }

    @API(status=API.Status.INTERNAL)
    public void deliveryComplete(IMqttDeliveryToken imdt) {
        log.debug("Message delivered");
    }

    @Override
    protected void closeConnection() {
        log.debug("Closing MqttAdapter");
        try {
            if (this.mqttClient != null) {
                this.mqttClient.disconnect();
            }
        }
        catch (Exception exception) {
            log.error("MqttEventListener exception: ", (Throwable)exception);
        }
    }

    @Override
    public void dispose() {
        log.debug("Disposing MqttAdapter");
        this.closeConnection();
        super.dispose();
    }
}

