/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mqtt;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nonnull;
import jmri.DccLocoAddress;
import jmri.implementation.DccConsist;
import jmri.jmrix.mqtt.MqttAdapter;
import jmri.jmrix.mqtt.MqttSystemConnectionMemo;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttConsist
extends DccConsist {
    private final MqttAdapter mqttAdapter;
    @Nonnull
    public String sendTopicPrefix = "cab/{0}/consist";
    private boolean active = false;
    private static final Logger log = LoggerFactory.getLogger(MqttConsist.class);

    public MqttConsist(int address, MqttSystemConnectionMemo memo, String sendTopicPrefix) {
        super(address);
        this.mqttAdapter = memo.getMqttAdapter();
        this.sendTopicPrefix = sendTopicPrefix;
        this.consistType = 1;
        log.debug("Consist {} created.", (Object)this.getConsistAddress());
    }

    public MqttConsist(DccLocoAddress address, MqttSystemConnectionMemo memo, String sendTopicPrefix) {
        super(address);
        this.mqttAdapter = memo.getMqttAdapter();
        this.sendTopicPrefix = sendTopicPrefix;
        this.consistType = 1;
        log.debug("Consist {} created.", (Object)this.getConsistAddress());
    }

    @Override
    public void dispose() {
        super.dispose();
        log.debug("Consist {} disposed.", (Object)this.getConsistAddress());
    }

    @Override
    public void setConsistType(int consist_type) {
        log.debug("Set Consist Type {}", (Object)consist_type);
        if (consist_type == 1) {
            this.consistType = consist_type;
        } else {
            log.error("Consist Type Not Supported");
            this.notifyConsistListeners(new DccLocoAddress(0, false), 1);
        }
    }

    @Override
    public boolean isAddressAllowed(DccLocoAddress address) {
        return address.getNumber() != 0;
    }

    @Override
    public int sizeLimit() {
        if (this.consistType == 1) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean contains(DccLocoAddress address) {
        if (this.consistType == 1) {
            return this.consistList.contains(address);
        }
        log.error("Consist Type Not Supported");
        this.notifyConsistListeners(address, 1);
        return false;
    }

    @Override
    public boolean getLocoDirection(DccLocoAddress address) {
        if (this.consistType == 1) {
            return this.consistDir.getOrDefault(address, false);
        }
        log.error("Consist Type Not Supported");
        this.notifyConsistListeners(address, 1);
        return false;
    }

    private synchronized void addToConsistList(DccLocoAddress locoAddress, boolean directionNormal) {
        log.debug("Add to consist list address {} direction {}", (Object)locoAddress, (Object)directionNormal);
        if (!this.consistList.contains(locoAddress)) {
            this.consistList.add(locoAddress);
        }
        this.consistDir.put(locoAddress, directionNormal);
        this.notifyConsistListeners(locoAddress, 2);
    }

    private synchronized void removeFromConsistList(DccLocoAddress locoAddress) {
        log.debug("Remove from consist list address {}", (Object)locoAddress);
        this.consistDir.remove(locoAddress);
        this.consistList.remove(locoAddress);
        this.notifyConsistListeners(locoAddress, 2);
    }

    @Override
    public synchronized void add(DccLocoAddress locoAddress, boolean directionNormal) {
        log.debug("Add to consist address {} direction {}", (Object)locoAddress, (Object)directionNormal);
        if (this.consistType == 1) {
            this.addToConsistList(locoAddress, directionNormal);
            if (this.active) {
                this.publish();
            }
        } else {
            log.error("Consist Type Not Supported");
            this.notifyConsistListeners(locoAddress, 1);
        }
    }

    @Override
    public synchronized void restore(DccLocoAddress locoAddress, boolean directionNormal) {
        log.debug("Restore to consist address {} direction {}", (Object)locoAddress, (Object)directionNormal);
        if (this.consistType == 1) {
            this.addToConsistList(locoAddress, directionNormal);
        } else {
            log.error("Consist Type Not Supported");
            this.notifyConsistListeners(locoAddress, 1);
        }
    }

    @Override
    public synchronized void remove(DccLocoAddress locoAddress) {
        log.debug("Remove from consist address {}", (Object)locoAddress);
        if (this.consistType == 1) {
            this.removeFromConsistList(locoAddress);
            if (this.active) {
                this.publish();
            }
        } else {
            log.error("Consist Type Not Supported");
            this.notifyConsistListeners(locoAddress, 1);
        }
    }

    public void activate() {
        log.info("Activating consist {}", (Object)this.consistID);
        this.active = true;
        this.publish();
    }

    public void deactivate() {
        log.info("Deactivating consist {}", (Object)this.consistID);
        this.active = false;
        ThreadingUtil.runOnLayoutEventually(() -> this.mqttAdapter.publish(this.sendTopicPrefix.replaceFirst("\\{0\\}", String.valueOf(this.consistAddress.getNumber())), ""));
    }

    @SuppressFBWarnings(value={"WMI_WRONG_MAP_ITERATOR"}, justification="false positive")
    private String getConsistMakeup() {
        String consistMakeup = "";
        for (DccLocoAddress address : this.consistDir.keySet()) {
            consistMakeup = consistMakeup.concat((Boolean)this.consistDir.get(address) != false ? "" : "-").concat(String.valueOf(address.getNumber())).concat(" ");
        }
        return consistMakeup.trim();
    }

    private void publish() {
        ThreadingUtil.runOnLayout(() -> this.mqttAdapter.publish(this.sendTopicPrefix.replaceFirst("\\{0\\}", String.valueOf(this.consistAddress.getNumber())), this.getConsistMakeup()));
    }
}

