/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mqtt;

import javax.annotation.Nonnull;
import jmri.Consist;
import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.implementation.AbstractConsistManager;
import jmri.jmrix.mqtt.MqttConsist;
import jmri.jmrix.mqtt.MqttSystemConnectionMemo;

public class MqttConsistManager
extends AbstractConsistManager {
    protected MqttSystemConnectionMemo adapterMemo;
    @Nonnull
    public String sendTopicPrefix = "cab/{0}/consist";

    public MqttConsistManager(MqttSystemConnectionMemo memo) {
        this.adapterMemo = memo;
    }

    public void setSendTopic(@Nonnull String sendTopicPrefix) {
        this.sendTopicPrefix = sendTopicPrefix;
    }

    @Override
    public boolean isCommandStationConsistPossible() {
        return true;
    }

    @Override
    public boolean csConsistNeedsSeperateAddress() {
        return true;
    }

    @Override
    public Consist addConsist(LocoAddress address) {
        if (!(address instanceof DccLocoAddress)) {
            throw new IllegalArgumentException("address is not a DccLocoAddress object");
        }
        if (this.consistTable.containsKey(address)) {
            return (Consist)this.consistTable.get(address);
        }
        MqttConsist consist = new MqttConsist((DccLocoAddress)address, this.adapterMemo, this.sendTopicPrefix);
        this.consistTable.put(address, consist);
        this.notifyConsistListChanged();
        return consist;
    }

    @Override
    public void requestUpdateFromLayout() {
    }

    @Override
    protected boolean shouldRequestUpdateFromLayout() {
        return false;
    }

    public void activateConsist(LocoAddress address) {
        ((MqttConsist)this.addConsist(address)).activate();
    }

    public void deactivateConsist(LocoAddress address) {
        if (!this.consistTable.containsKey(address)) {
            return;
        }
        ((MqttConsist)this.consistTable.get(address)).deactivate();
    }
}

