/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mqtt;

import javax.annotation.Nonnull;
import jmri.Light;
import jmri.implementation.AbstractVariableLight;
import jmri.jmrix.mqtt.MqttAdapter;
import jmri.jmrix.mqtt.MqttContentParser;
import jmri.jmrix.mqtt.MqttEventListener;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttLight
extends AbstractVariableLight
implements MqttEventListener {
    private final MqttAdapter mqttAdapter;
    private final String sendTopic;
    private final String rcvTopic;
    public static String intensityText = "INTENSITY ";
    MqttContentParser<Light> parser = new MqttContentParser<Light>(){
        private static final String onText = "ON";
        private static final String offText = "OFF";

        int stateFromString(String payload) {
            if (payload.startsWith(intensityText)) {
                return -1;
            }
            switch (payload) {
                case "ON": {
                    return 2;
                }
                case "OFF": {
                    return 4;
                }
            }
            return 1;
        }

        @Override
        public void beanFromPayload(@Nonnull Light bean, @Nonnull String payload, @Nonnull String topic) {
            log.debug("beanFromPayload {} {} {}", new Object[]{bean, payload, topic});
            int state = this.stateFromString(payload);
            if (state == -1) {
                log.trace("  no changes");
                return;
            }
            boolean couldBeSendMessage = topic.endsWith(MqttLight.this.sendTopic);
            boolean couldBeRcvMessage = topic.endsWith(MqttLight.this.rcvTopic);
            if (couldBeSendMessage) {
                log.trace("   setCommandedState {}", (Object)state);
                MqttLight.this.setCommandedState(state);
            } else if (couldBeRcvMessage) {
                MqttLight.this.setState(state);
                log.trace("   setState {}", (Object)state);
            } else {
                log.warn("{} failure to decode topic {} {}", new Object[]{MqttLight.this.getDisplayName(), topic, payload});
            }
        }

        @Override
        @Nonnull
        public String payloadFromBean(@Nonnull Light bean, int newState) {
            String toReturn = "UNKNOWN";
            switch (MqttLight.this.getState()) {
                case 2: {
                    toReturn = onText;
                    break;
                }
                case 4: {
                    toReturn = offText;
                    break;
                }
                default: {
                    log.error("Light {} has a state which is not supported {}", (Object)MqttLight.this.getDisplayName(), (Object)newState);
                }
            }
            return toReturn;
        }
    };
    private static final Logger log = LoggerFactory.getLogger(MqttLight.class);

    public MqttLight(MqttAdapter ma, String systemName, String userName, String sendTopic, String rcvTopic) {
        super(systemName, userName);
        this.sendTopic = sendTopic;
        this.rcvTopic = rcvTopic;
        this.mqttAdapter = ma;
        this.mqttAdapter.subscribe(rcvTopic, this);
    }

    public void setParser(MqttContentParser<Light> parser) {
        this.parser = parser;
    }

    @Override
    protected int getNumberOfSteps() {
        return 20;
    }

    @Override
    protected void sendIntensity(double intensity) {
        this.sendMessage(intensityText + intensity);
    }

    @Override
    protected void sendOnOffCommand(int newState) {
        switch (newState) {
            case 2: {
                this.sendMessage(true);
                break;
            }
            case 4: {
                this.sendMessage(false);
                break;
            }
            default: {
                log.error("Unexpected state to sendOnOff: {}", (Object)newState);
            }
        }
    }

    @Override
    protected void doNewState(int oldState, int newState) {
        log.debug("doNewState with old state {} new state {}", (Object)oldState, (Object)newState);
        if (oldState == newState) {
            return;
        }
        if ((newState & 2) != 0) {
            if ((newState & 4) != 0) {
                log.error("Cannot command {} to both ON and OFF {}", (Object)this.getDisplayName(), (Object)newState);
                return;
            }
            this.sendMessage(true);
        } else {
            this.sendMessage(false);
        }
    }

    private void sendMessage(boolean on) {
        this.sendMessage(on ? "ON" : "OFF");
    }

    private void sendMessage(String c) {
        ThreadingUtil.runOnLayoutEventually(() -> this.mqttAdapter.publish(this.sendTopic, c.getBytes()));
        log.debug("sent {}", (Object)c);
    }

    @Override
    public void setState(int newState) {
        log.debug("setState {} was {}", (Object)newState, (Object)this.mState);
        if (newState != 2 && newState != 4 && newState != 1) {
            throw new IllegalArgumentException("cannot set state value " + newState);
        }
        this.doNewState(this.mState, newState);
        this.notifyStateChange(this.mState, newState);
    }

    @Override
    public void requestUpdateFromLayout() {
    }

    @Override
    public void notifyMqttMessage(String receivedTopic, String message) {
        if (!receivedTopic.endsWith(this.rcvTopic) && !receivedTopic.endsWith(this.sendTopic)) {
            log.error("{} got a message whose topic ({}) wasn't for me ({})", new Object[]{this.getDisplayName(), receivedTopic, this.rcvTopic});
            return;
        }
        log.debug("notifyMqttMessage with {}", (Object)message);
        if (message.startsWith(intensityText)) {
            String stringValue = message.substring(intensityText.length());
            try {
                double intensity = Double.parseDouble(stringValue);
                log.debug("setting received intensity with {}", (Object)intensity);
                this.setObservedAnalogValue(intensity);
            }
            catch (NumberFormatException e) {
                log.warn("could not parse input {}", (Object)receivedTopic, (Object)e);
            }
        }
        this.parser.beanFromPayload(this, message, receivedTopic);
    }

    @Override
    public void dispose() {
        this.mqttAdapter.unsubscribe(this.rcvTopic, this);
        super.dispose();
    }
}

