/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mqtt;

import java.text.MessageFormat;
import javax.annotation.Nonnull;
import jmri.Light;
import jmri.jmrix.mqtt.MqttLight;
import jmri.jmrix.mqtt.MqttSystemConnectionMemo;
import jmri.managers.AbstractLightManager;

public class MqttLightManager
extends AbstractLightManager {
    @Nonnull
    public String sendTopicPrefix = "track/light/";
    @Nonnull
    public String rcvTopicPrefix = "track/light/";

    public MqttLightManager(@Nonnull MqttSystemConnectionMemo memo) {
        super(memo);
    }

    public void setSendTopicPrefix(@Nonnull String sendTopicPrefix) {
        this.sendTopicPrefix = sendTopicPrefix;
    }

    public void setRcvTopicPrefix(@Nonnull String rcvTopicPrefix) {
        this.rcvTopicPrefix = rcvTopicPrefix;
    }

    @Override
    @Nonnull
    public MqttSystemConnectionMemo getMemo() {
        return (MqttSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Light createNewLight(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        String suffix = systemName.substring(this.getSystemNamePrefix().length());
        String sendTopic = MessageFormat.format((String)(this.sendTopicPrefix.contains("{0}") ? this.sendTopicPrefix : this.sendTopicPrefix + "{0}"), suffix);
        String rcvTopic = MessageFormat.format((String)(this.rcvTopicPrefix.contains("{0}") ? this.rcvTopicPrefix : this.rcvTopicPrefix + "{0}"), suffix);
        MqttLight t = new MqttLight(this.getMemo().getMqttAdapter(), systemName, userName, sendTopic, rcvTopic);
        t.setUserName(userName);
        return t;
    }

    @Override
    public boolean validSystemNameConfig(String systemName) {
        return true;
    }

    @Override
    public boolean allowMultipleAdditions(String systemName) {
        return true;
    }

    @Override
    public String getEntryToolTip() {
        return "A string which will be inserted into \"" + this.sendTopicPrefix + "\" for transmission";
    }
}

