/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mqtt;

import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.jmrix.mqtt.MqttAdapter;
import jmri.jmrix.mqtt.MqttEventListener;
import jmri.jmrix.mqtt.MqttSystemConnectionMemo;
import jmri.managers.AbstractPowerManager;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttPowerManager
extends AbstractPowerManager<MqttSystemConnectionMemo>
implements MqttEventListener {
    private static final String onText = "ON";
    private static final String offText = "OFF";
    private final MqttAdapter mqttAdapter;
    @Nonnull
    public String sendTopic = "track/power";
    @Nonnull
    public String rcvTopic = "track/power";
    private static final Logger log = LoggerFactory.getLogger(MqttPowerManager.class);

    public MqttPowerManager(MqttSystemConnectionMemo memo) {
        super(memo);
        this.mqttAdapter = memo.getMqttAdapter();
    }

    public void setSendTopic(@Nonnull String sendTopic) {
        this.sendTopic = sendTopic;
    }

    public void setRcvTopic(@Nonnull String rcvTopic) {
        this.mqttAdapter.unsubscribe(rcvTopic, this);
        this.rcvTopic = rcvTopic;
        this.mqttAdapter.subscribe(rcvTopic, this);
        log.info("Subscribed to {}", (Object)rcvTopic);
    }

    @Override
    public boolean implementsIdle() {
        return false;
    }

    @Override
    public void setPower(int v) throws JmriException {
        if (v == 2) {
            this.sendMessage(onText);
        } else if (v == 4) {
            this.sendMessage(offText);
        } else {
            log.warn("Saw unknown power state : {}", (Object)v);
        }
    }

    @Override
    public void dispose() throws JmriException {
        this.mqttAdapter.unsubscribe(this.rcvTopic, this);
    }

    private void sendMessage(String c) {
        ThreadingUtil.runOnLayoutEventually(() -> this.mqttAdapter.publish(this.sendTopic, c));
        log.debug("sent {}", (Object)c);
    }

    @Override
    public void notifyMqttMessage(String receivedTopic, String message) {
        if (!receivedTopic.endsWith(this.rcvTopic)) {
            log.error("Got a message whose topic ({}) wasn't for me ({})", (Object)receivedTopic, (Object)this.rcvTopic);
            return;
        }
        log.debug("notifyMqttMessage with {}", (Object)message);
        try {
            switch (message) {
                case "ON": {
                    super.setPower(2);
                    break;
                }
                case "OFF": {
                    super.setPower(4);
                    break;
                }
                default: {
                    log.error("Invalid message to power manager: {}", (Object)message);
                    break;
                }
            }
        }
        catch (JmriException e) {
            log.error("JMRI Exception", (Throwable)e);
        }
    }
}

