/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mqtt;

import jmri.IdTag;
import jmri.IdTagManager;
import jmri.InstanceManager;
import jmri.implementation.AbstractIdTagReporter;
import jmri.jmrix.mqtt.MqttAdapter;
import jmri.jmrix.mqtt.MqttEventListener;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MqttReporter
extends AbstractIdTagReporter
implements MqttEventListener {
    private final MqttAdapter mqttAdapter;
    private final String rcvTopic;
    private static final Logger log = LoggerFactory.getLogger(MqttReporter.class);

    MqttReporter(MqttAdapter ma, String systemName, String rcvTopic) {
        super(systemName);
        this.rcvTopic = rcvTopic;
        this.mqttAdapter = ma;
        this.mqttAdapter.subscribe(rcvTopic, this);
    }

    @Override
    public void notifyMqttMessage(String receivedTopic, String message) {
        if (!receivedTopic.endsWith(this.rcvTopic)) {
            log.error("Got a message whose topic ({}) wasn't for me ({})", (Object)receivedTopic, (Object)this.rcvTopic);
            return;
        }
        log.trace("start parse of {}", (Object)message);
        String[] terms = message.split(" ", 2);
        if (terms.length < 1 || terms[0].isEmpty()) {
            log.debug("No loco ID present in ({}), record empty report", (Object)message);
            ThreadingUtil.runOnLayout(() -> this.notify(null));
            return;
        }
        String loco = terms[0];
        String content = "";
        if (terms.length > 1) {
            content = terms[1];
        }
        try {
            IdTag idTag = InstanceManager.getDefault(IdTagManager.class).provideIdTag(loco);
            idTag.setProperty("content", content);
            ThreadingUtil.runOnLayout(() -> this.notify(null));
            ThreadingUtil.runOnLayout(() -> this.notify(idTag));
        }
        catch (IllegalArgumentException e) {
            log.error("Reporter {} cannot make a tag from input ({})", (Object)this.getSystemName(), (Object)message);
        }
    }

    @Override
    public void dispose() {
        this.mqttAdapter.unsubscribe(this.rcvTopic, this);
        super.dispose();
    }
}

