/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mqtt;

import java.text.MessageFormat;
import javax.annotation.Nonnull;
import jmri.Manager;
import jmri.Reporter;
import jmri.SystemConnectionMemo;
import jmri.jmrix.mqtt.Bundle;
import jmri.jmrix.mqtt.MqttReporter;
import jmri.jmrix.mqtt.MqttSystemConnectionMemo;
import jmri.managers.AbstractReporterManager;

public class MqttReporterManager
extends AbstractReporterManager {
    @Nonnull
    public String rcvTopicPrefix = "track/reporter/";

    public MqttReporterManager(@Nonnull SystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public MqttSystemConnectionMemo getMemo() {
        return (MqttSystemConnectionMemo)this.memo;
    }

    public void setRcvTopicPrefix(@Nonnull String rcvTopicPrefix) {
        this.rcvTopicPrefix = rcvTopicPrefix;
    }

    @Override
    public boolean allowMultipleAdditions(String systemName) {
        return true;
    }

    @Override
    public String createSystemName(@Nonnull String topicSuffix, @Nonnull String prefix) {
        return prefix + this.typeLetter() + topicSuffix;
    }

    @Override
    @Nonnull
    public Reporter createNewReporter(String systemName, String userName) {
        String suffix = systemName.substring(this.getSystemPrefix().length() + 1);
        String rcvTopic = MessageFormat.format((String)(this.rcvTopicPrefix.contains("{0}") ? this.rcvTopicPrefix : this.rcvTopicPrefix + "{0}"), suffix);
        MqttReporter r = new MqttReporter(this.getMemo().getMqttAdapter(), systemName, rcvTopic);
        r.setUserName(userName);
        return r;
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(String systemName) {
        return Manager.NameValidity.VALID;
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddInputEntryToolTip");
    }
}

