/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mqtt;

import javax.annotation.Nonnull;
import jmri.Sensor;
import jmri.implementation.AbstractSensor;
import jmri.jmrix.mqtt.MqttAdapter;
import jmri.jmrix.mqtt.MqttContentParser;
import jmri.jmrix.mqtt.MqttEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttSensor
extends AbstractSensor
implements MqttEventListener {
    private final MqttAdapter mqttAdapter;
    private final String sendTopic;
    private final String rcvTopic;
    MqttContentParser<Sensor> parser = new MqttContentParser<Sensor>(){
        private static final String inactiveText = "INACTIVE";
        private static final String activeText = "ACTIVE";

        @Override
        public void beanFromPayload(@Nonnull Sensor bean, @Nonnull String payload, @Nonnull String topic) {
            switch (payload) {
                case "INACTIVE": {
                    MqttSensor.this.setOwnState(!MqttSensor.this._inverted ? 4 : 2);
                    break;
                }
                case "ACTIVE": {
                    MqttSensor.this.setOwnState(!MqttSensor.this._inverted ? 2 : 4);
                    break;
                }
                default: {
                    log.warn("{} saw unknown state : {}", (Object)MqttSensor.this.getDisplayName(), (Object)payload);
                }
            }
        }

        @Override
        @Nonnull
        public String payloadFromBean(@Nonnull Sensor bean, int newState) {
            if ((newState & 4) != 0 ^ MqttSensor.this.getInverted()) {
                if ((newState & 2) != 0 ^ MqttSensor.this.getInverted()) {
                    log.error("Cannot command both INACTIVE and ACTIVE: {}", (Object)newState);
                    throw new IllegalArgumentException("Cannot command both INACTIVE and ACTIVE: " + newState);
                }
                return inactiveText;
            }
            return activeText;
        }
    };
    private static final Logger log = LoggerFactory.getLogger(MqttSensor.class);

    MqttSensor(MqttAdapter ma, String systemName, String sendTopic, String rcvTopic) {
        super(systemName);
        this.sendTopic = sendTopic;
        this.rcvTopic = rcvTopic;
        this.mqttAdapter = ma;
        this.mqttAdapter.subscribe(rcvTopic, this);
    }

    public void setParser(MqttContentParser<Sensor> parser) {
        this.parser = parser;
    }

    @Override
    public boolean canInvert() {
        return true;
    }

    @Override
    public void requestUpdateFromLayout() {
    }

    @Override
    public void setKnownState(int s) {
        String payload = this.parser.payloadFromBean(this, s);
        log.debug("payload: {}", (Object)payload);
        this.sendMessage(payload);
        this.setOwnState(s);
    }

    private void sendMessage(String c) {
        this.mqttAdapter.publish(this.sendTopic, c);
    }

    @Override
    public void notifyMqttMessage(String receivedTopic, String message) {
        if (!receivedTopic.endsWith(this.rcvTopic) && !receivedTopic.endsWith(this.sendTopic)) {
            log.error("{} got a message whose topic ({}) wasn't for me ({})", new Object[]{this.getDisplayName(), receivedTopic, this.rcvTopic});
            return;
        }
        this.parser.beanFromPayload(this, message, receivedTopic);
    }

    @Override
    public void dispose() {
        this.mqttAdapter.unsubscribe(this.rcvTopic, this);
        super.dispose();
    }
}

