/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mqtt;

import java.text.MessageFormat;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.Manager;
import jmri.Sensor;
import jmri.SystemConnectionMemo;
import jmri.jmrix.mqtt.Bundle;
import jmri.jmrix.mqtt.MqttContentParser;
import jmri.jmrix.mqtt.MqttSensor;
import jmri.jmrix.mqtt.MqttSystemConnectionMemo;
import jmri.managers.AbstractSensorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttSensorManager
extends AbstractSensorManager {
    @Nonnull
    public String sendTopicPrefix = "track/sensor/";
    @Nonnull
    public String rcvTopicPrefix = "track/sensor/";
    static int defaultState = 1;
    protected String prefix = "M";
    MqttContentParser<Sensor> parser = null;
    private static final Logger log = LoggerFactory.getLogger(MqttSensorManager.class);

    public MqttSensorManager(@Nonnull SystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public MqttSystemConnectionMemo getMemo() {
        return (MqttSystemConnectionMemo)this.memo;
    }

    public void setSendTopicPrefix(@Nonnull String sendTopicPrefix) {
        this.sendTopicPrefix = sendTopicPrefix;
    }

    public void setRcvTopicPrefix(@Nonnull String rcvTopicPrefix) {
        this.rcvTopicPrefix = rcvTopicPrefix;
    }

    @Override
    public boolean allowMultipleAdditions(String systemName) {
        return true;
    }

    @Override
    public String createSystemName(@Nonnull String topicSuffix, @Nonnull String prefix) throws JmriException {
        return prefix + this.typeLetter() + topicSuffix;
    }

    @Override
    @Nonnull
    protected Sensor createNewSensor(String systemName, String userName) throws IllegalArgumentException {
        String suffix = systemName.substring(this.getSystemPrefix().length() + 1);
        String sendTopic = MessageFormat.format((String)(this.sendTopicPrefix.contains("{0}") ? this.sendTopicPrefix : this.sendTopicPrefix + "{0}"), suffix);
        String rcvTopic = MessageFormat.format((String)(this.rcvTopicPrefix.contains("{0}") ? this.rcvTopicPrefix : this.rcvTopicPrefix + "{0}"), suffix);
        MqttSensor s = new MqttSensor(this.getMemo().getMqttAdapter(), systemName, sendTopic, rcvTopic);
        s.setUserName(userName);
        if (this.parser != null) {
            s.setParser(this.parser);
        }
        return s;
    }

    public static synchronized void setDefaultStateForNewSensors(int defaultSetting) {
        log.debug("Default new-Sensor state set to {}", (Object)defaultSetting);
        defaultState = defaultSetting;
    }

    public static synchronized int getDefaultStateForNewSensors() {
        return defaultState;
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(String systemName) {
        return Manager.NameValidity.VALID;
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddInputEntryToolTip");
    }

    public void setParser(MqttContentParser<Sensor> parser) {
        this.parser = parser;
    }
}

