/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mqtt;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.implementation.AbstractSignalMast;
import jmri.jmrix.mqtt.MqttAdapter;
import jmri.jmrix.mqtt.MqttSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttSignalMast
extends AbstractSignalMast {
    @Nonnull
    @SuppressFBWarnings(value={"MS_PKGPROTECT"}, justification="Public accessibility for scripts that update the prefixes")
    public static String sendTopicPrefix = "track/signalmast/";
    private static final String mastType = "IF$mqm";
    private final String sendTopic;
    private MqttAdapter mqttAdapter;
    private static volatile int lastRef = 0;
    private static final Logger log = LoggerFactory.getLogger(MqttSignalMast.class);

    public MqttSignalMast(String systemName, String userName) {
        super(systemName, userName);
        this.configureFromName(systemName);
        this.sendTopic = this.makeSendTopic(systemName);
        this.mqttAdapter = InstanceManager.getDefault(MqttSystemConnectionMemo.class).getMqttAdapter();
    }

    public MqttSignalMast(String systemName) {
        super(systemName);
        this.configureFromName(systemName);
        this.sendTopic = this.makeSendTopic(systemName);
        this.mqttAdapter = InstanceManager.getDefault(MqttSystemConnectionMemo.class).getMqttAdapter();
    }

    public static void setSendTopicPrefix(@Nonnull String prefix) {
        sendTopicPrefix = prefix;
        log.debug("sendTopicPrefix set to {}", (Object)prefix);
    }

    protected String makeSendTopic(String systemName) {
        String[] pieces = systemName.split("\\(");
        if (pieces.length == 2) {
            String result = pieces[1].substring(1, pieces[1].length() - 1);
            return sendTopicPrefix + result;
        }
        log.warn("not just one '(' in {}", (Object)systemName);
        return sendTopicPrefix + systemName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureFromName(String systemName) {
        String[] parts = systemName.split(":");
        if (parts.length < 3) {
            log.error("SignalMast system name needs at least three parts: {}", (Object)systemName);
            throw new IllegalArgumentException("System name needs at least three parts: " + systemName);
        }
        if (!parts[0].equals(mastType)) {
            log.warn("SignalMast system name should start with {} but is {}", (Object)mastType, (Object)systemName);
        }
        String system = parts[1];
        String mast = parts[2];
        mast = mast.substring(0, mast.indexOf("("));
        this.setMastType(mast);
        String tmp = parts[2].substring(parts[2].indexOf("($") + 2, parts[2].indexOf(")"));
        try {
            log.debug("Parse {} as integer from {}?", (Object)tmp, (Object)parts[2]);
            int autoNumber = Integer.parseInt(tmp);
            Class<MqttSignalMast> clazz = MqttSignalMast.class;
            synchronized (MqttSignalMast.class) {
                if (autoNumber > MqttSignalMast.getLastRef()) {
                    MqttSignalMast.setLastRef(autoNumber);
                }
                // ** MonitorExit[var7_8] (shouldn't be in output)
            }
        }
        catch (NumberFormatException e) {
            log.debug("Auto generated SystemName {} does not have numeric form, skipping autoincrement", (Object)systemName);
        }
        {
            this.configureSignalSystemDefinition(system);
            this.configureAspectTable(system, mast);
            return;
        }
    }

    @Override
    public void setAspect(@Nonnull String aspect) {
        if (!this.map.checkAspect(aspect)) {
            log.warn("attempting to set invalid aspect: {} on mast: {}", (Object)aspect, (Object)this.getDisplayName());
            throw new IllegalArgumentException("attempting to set invalid aspect: " + aspect + " on mast: " + this.getDisplayName());
        }
        if (this.disabledAspects.contains(aspect)) {
            log.warn("attempting to set an aspect that has been disabled: {} on mast: {}", (Object)aspect, (Object)this.getDisplayName());
            throw new IllegalArgumentException("attempting to set an aspect that has been disabled: " + aspect + " on mast: " + this.getDisplayName());
        }
        log.debug("Setting aspect {}", (Object)aspect);
        super.setAspect(aspect);
        this.report();
    }

    @Override
    public void setHeld(boolean held) {
        log.debug("Setting held {}", (Object)held);
        super.setHeld(held);
        this.report();
    }

    @Override
    public void setLit(boolean lit) {
        log.debug("Setting lit {}", (Object)lit);
        super.setLit(lit);
        this.report();
    }

    private void report() {
        String msg = this.aspect + "; ";
        msg = msg + (this.getLit() ? "Lit; " : "Unlit; ");
        msg = msg + (this.getHeld() ? "Held" : "Unheld");
        this.sendMessage(msg);
    }

    private void sendMessage(String c) {
        log.debug("publishing \"{}\" on \"{}\"", (Object)c, (Object)this.sendTopic);
        this.mqttAdapter.publish(this.sendTopic, c);
    }

    protected static void setLastRef(int newVal) {
        lastRef = newVal;
    }

    public static int getLastRef() {
        return lastRef;
    }
}

