/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mqtt;

import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.SignalAppearanceMap;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.SignalSystem;
import jmri.SystemConnectionMemo;
import jmri.jmrit.beantable.signalmast.SignalMastAddPane;
import jmri.jmrix.mqtt.Bundle;
import jmri.jmrix.mqtt.MqttSignalMast;
import jmri.jmrix.mqtt.MqttSystemConnectionMemo;
import jmri.util.javaworld.GridLayout2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttSignalMastAddPane
extends SignalMastAddPane {
    JLabel aspectAddressLabel = new JLabel(Bundle.getMessage("TopicSuffix"));
    JTextField aspectAddressField = new JTextField(5);
    JCheckBox allowUnLit = new JCheckBox();
    LinkedHashMap<String, JCheckBox> disabledAspects = new LinkedHashMap(12);
    JPanel disabledAspectsPanel = new JPanel();
    MqttSignalMast currentMast = null;
    DecimalFormat paddedNumber = new DecimalFormat("0000");
    private static final Logger log = LoggerFactory.getLogger(MqttSignalMastAddPane.class);

    public MqttSignalMastAddPane() {
        this.initPanel();
    }

    final void initPanel() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel(Bundle.getMessage("AllowUnLitLabel") + ": "));
        p.add(this.allowUnLit);
        p.setAlignmentX(0.0f);
        this.add(p);
        this.add(this.addressDataPane());
        TitledBorder disableborder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black));
        disableborder.setTitle(Bundle.getMessage("DisableAspectsLabel"));
        JScrollPane disabledAspectsScroll = new JScrollPane(this.disabledAspectsPanel);
        disabledAspectsScroll.setBorder(disableborder);
        this.add(disabledAspectsScroll);
    }

    JPanel addressDataPane() {
        JPanel p = new JPanel();
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black));
        p.setBorder(border);
        p.setLayout(new GridLayout2(1, 2));
        p.add(this.aspectAddressLabel);
        this.aspectAddressField.setText(this.paddedNumber.format(MqttSignalMast.getLastRef() + 1));
        this.aspectAddressField.setEnabled(true);
        p.add(this.aspectAddressField);
        return p;
    }

    @Override
    @Nonnull
    public String getPaneName() {
        return Bundle.getMessage("MqttMast");
    }

    @Override
    public void setAspectNames(@Nonnull SignalAppearanceMap map, @Nonnull SignalSystem sigSystem) {
        Enumeration<String> aspects = map.getAspects();
        this.disabledAspects = new LinkedHashMap(12);
        this.disabledAspectsPanel.removeAll();
        while (aspects.hasMoreElements()) {
            String aspect = aspects.nextElement();
            JCheckBox disabled = new JCheckBox(aspect);
            this.disabledAspects.put(aspect, disabled);
        }
        for (Map.Entry<String, JCheckBox> entry : this.disabledAspects.entrySet()) {
            this.disabledAspectsPanel.add(entry.getValue());
        }
        this.disabledAspectsPanel.setLayout(new GridLayout2(0, 1));
        this.disabledAspectsPanel.revalidate();
    }

    @Override
    public boolean canHandleMast(@Nonnull SignalMast mast) {
        return mast instanceof MqttSignalMast;
    }

    @Override
    public void setMast(SignalMast mast) {
        log.trace("setMast {} start", (Object)mast);
        if (mast == null) {
            this.currentMast = null;
            return;
        }
        if (!(mast instanceof MqttSignalMast)) {
            log.error("mast was wrong type: {} {}", (Object)mast.getSystemName(), (Object)mast.getClass().getName());
            return;
        }
        this.aspectAddressField.setEnabled(false);
        String[] pieces = mast.getSystemName().split("\\(");
        if (pieces.length == 2) {
            String number = pieces[1].substring(1, pieces[1].length() - 1);
            this.aspectAddressField.setText(number);
        } else {
            log.warn("not just one '(' in {}", (Object)mast.getSystemName());
        }
        this.currentMast = (MqttSignalMast)mast;
        List<String> disabled = this.currentMast.getDisabledAspects();
        if (disabled != null) {
            for (String aspect : disabled) {
                if (!this.disabledAspects.containsKey(aspect)) continue;
                this.disabledAspects.get(aspect).setSelected(true);
            }
        }
        this.allowUnLit.setSelected(this.currentMast.allowUnLit());
        log.trace("setMast {} end", (Object)mast);
    }

    @Override
    public boolean createMast(@Nonnull String sigsysname, @Nonnull String mastname, @Nonnull String username) {
        log.trace("createMast {} {} {} start with currentMast: {}", new Object[]{sigsysname, mastname, username, this.currentMast});
        if (this.currentMast == null) {
            String name = "IF$mqm:" + sigsysname + ":" + mastname.substring(11, mastname.length() - 4);
            name = name + "($" + this.aspectAddressField.getText() + ")";
            this.currentMast = new MqttSignalMast(name);
            if (!username.isEmpty()) {
                this.currentMast.setUserName(username);
            }
            this.currentMast.setMastType(mastname.substring(11, mastname.length() - 4));
            try {
                InstanceManager.getDefault(SignalMastManager.class).register(this.currentMast);
            }
            catch (NamedBean.DuplicateSystemNameException e) {
                this.currentMast = null;
                throw e;
            }
        }
        for (Map.Entry<String, JCheckBox> entry : this.disabledAspects.entrySet()) {
            if (entry.getValue().isSelected()) {
                this.currentMast.setAspectDisabled(entry.getKey());
                continue;
            }
            this.currentMast.setAspectEnabled(entry.getKey());
        }
        this.currentMast.setAllowUnLit(this.allowUnLit.isSelected());
        this.aspectAddressField.setText(this.paddedNumber.format(MqttSignalMast.getLastRef() + 1));
        log.trace("createMast {} {} {} end", new Object[]{sigsysname, mastname, username});
        return true;
    }

    public static class SignalMastAddPaneProvider
    extends SignalMastAddPane.SignalMastAddPaneProvider {
        @Override
        public boolean isAvailable() {
            for (SystemConnectionMemo memo : InstanceManager.getList(SystemConnectionMemo.class)) {
                if (!(memo instanceof MqttSystemConnectionMemo)) continue;
                return true;
            }
            return false;
        }

        @Override
        @Nonnull
        public String getPaneName() {
            return Bundle.getMessage("MqttMast");
        }

        @Override
        @Nonnull
        public SignalMastAddPane getNewPane() {
            return new MqttSignalMastAddPane();
        }
    }
}

